/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.sponsor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentPresentationController;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.kns.web.ui.SectionBridge;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class SponsorMaintainableImpl
extends KraMaintainableImpl {
    private static final Logger LOG = LogManager.getLogger(SponsorMaintainableImpl.class);
    private static final long serialVersionUID = 3366318004175290243L;
    public static final String SECTION_ID = "Edit Sponsor";
    public static final String SPONSOR_CODE_NAME = "sponsorCode";
    public static final String ROLODEX_ID_SEQUENCE_NAME = "SEQ_ROLODEX_ID";
    private transient ParameterService parameterService;
    private transient DataFieldMaxValueIncrementer sponsorCodeIncrementer;
    private transient SequenceAccessorService sequenceAccessorService;
    private transient BusinessObjectService businessObjectService;

    public void setGenerateDefaultValues(String docTypeName) {
        super.setGenerateDefaultValues(docTypeName);
        Sponsor sponsor = (Sponsor)this.getBusinessObject();
        if (this.isAutoGenerateCode()) {
            sponsor.setSponsorCode(this.getSponsorCodeIncrementer().nextStringValue());
        }
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        if (this.isAutoGenerateCode()) {
            this.disableSponsorCode(sections);
        }
        return sections;
    }

    public List<Section> getCoreSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        ArrayList<Section> sections = new ArrayList<Section>();
        MaintenanceDocumentRestrictions maintenanceRestrictions = this.getBusinessObjectAuthorizationService().getMaintenanceDocumentRestrictions(document, this.getGlobalVariableService().getUserSession().getPerson());
        MaintenanceDocumentPresentationController maintenanceDocumentPresentationController = (MaintenanceDocumentPresentationController)this.getDocumentHelperService().getDocumentPresentationController((Document)document);
        Set conditionallyRequiredFields = maintenanceDocumentPresentationController.getConditionallyRequiredPropertyNames(document);
        List sectionDefinitions = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(this.getDocumentTypeName());
        if (!this.getParameterService().getParameterValueAsBoolean("KC-GEN", "Document", "FIN_SYSTEM_INTEGRATION_ON_SPONSOR").booleanValue()) {
            this.filterKFSFields(sectionDefinitions);
        }
        try {
            for (MaintainableSectionDefinition maintSectionDef : sectionDefinitions) {
                ArrayList<String> displayedFieldNames = new ArrayList<String>();
                if (maintenanceRestrictions.isHiddenSectionId(maintSectionDef.getId())) continue;
                for (MaintainableItemDefinition item : maintSectionDef.getMaintainableItems()) {
                    if (!(item instanceof MaintainableFieldDefinition)) continue;
                    displayedFieldNames.add(item.getName());
                }
                Section section1 = SectionBridge.toSection((MaintainableSectionDefinition)maintSectionDef, (BusinessObject)this.getBusinessObject(), (Maintainable)this, (Maintainable)oldMaintainable, (String)this.getMaintenanceAction(), displayedFieldNames, (Set)conditionallyRequiredFields);
                if (maintenanceRestrictions.isReadOnlySectionId(maintSectionDef.getId())) {
                    section1.setReadOnly(true);
                }
                sections.add(section1);
            }
            return sections;
        }
        catch (IllegalAccessException | InstantiationException var13) {
            LOG.error("Unable to create instance of object class" + var13.getMessage());
            throw new RuntimeException("Unable to create instance of object class" + var13.getMessage(), var13);
        }
    }

    protected void filterKFSFields(List<MaintainableSectionDefinition> sections) {
        sections.stream().filter(section -> StringUtils.equals((CharSequence)section.getId(), (CharSequence)SECTION_ID)).forEach(section -> section.getMaintainableItems().removeIf(item -> StringUtils.equals((CharSequence)item.getName(), (CharSequence)"dunningCampaignId") || StringUtils.equals((CharSequence)item.getName(), (CharSequence)"customerExists") || StringUtils.equals((CharSequence)item.getName(), (CharSequence)"customerNumber") || StringUtils.equals((CharSequence)item.getName(), (CharSequence)"customerTypeCode") || StringUtils.equals((CharSequence)item.getName(), (CharSequence)"state")));
    }

    protected void disableSponsorCode(List<Section> sections) {
        sections.stream().filter(section -> StringUtils.equals((CharSequence)section.getSectionId(), (CharSequence)SECTION_ID)).flatMap(section -> section.getRows().stream()).flatMap(row -> row.getFields().stream()).filter(field -> StringUtils.equals((CharSequence)field.getPropertyName(), (CharSequence)SPONSOR_CODE_NAME)).forEach(field -> field.setReadOnly(true));
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        this.setGenerateDefaultValues(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
    }

    protected boolean isAutoGenerateCode() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "AUTO_GENERATE_SPONSOR_CODE");
    }

    public void saveDataObject() {
        if (this.getBusinessObject() instanceof Sponsor) {
            Sponsor sponsor = (Sponsor)this.getBusinessObject();
            Rolodex rolodex = sponsor.getRolodex();
            if (!(rolodex == null || rolodex.getRolodexId() != null && sponsor.getSponsorCode().equals(rolodex.getSponsorCode()))) {
                rolodex.setRolodexId(Integer.parseInt(this.getSequenceAccessorService().getNextAvailableSequenceNumber(ROLODEX_ID_SEQUENCE_NAME, Rolodex.class).toString()));
                sponsor.setRolodexId(rolodex.getRolodexId());
            }
            if (rolodex != null) {
                rolodex.setSponsorCode(sponsor.getSponsorCode());
                rolodex.setOrganization(sponsor.getSponsorName());
                rolodex.setOwnedByUnit(sponsor.getOwnedByUnit());
                rolodex.setSponsorAddressFlag(true);
                rolodex.setActive(sponsor.isActive());
                this.getBusinessObjectService().save((PersistableBusinessObject)rolodex);
            }
        }
        super.saveDataObject();
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DataFieldMaxValueIncrementer getSponsorCodeIncrementer() {
        if (this.sponsorCodeIncrementer == null) {
            this.sponsorCodeIncrementer = (DataFieldMaxValueIncrementer)KcServiceLocator.getService("sponsorCodeIncrementer");
        }
        return this.sponsorCodeIncrementer;
    }

    public void setSponsorCodeIncrementer(DataFieldMaxValueIncrementer sponsorCodeIncrementer) {
        this.sponsorCodeIncrementer = sponsorCodeIncrementer;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = (SequenceAccessorService)KcServiceLocator.getService("sequenceAccessorService");
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

