<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="8.5in" page-width="11in" margin-left="0.8in" margin-right="0.8in">
				<fo:region-body margin-top="0.3in" margin-bottom="0.3in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="2pt" text-align="center" display-align="center">
											<fo:block>
												<fo:inline font-size="14pt" font-weight="bold">
													<xsl:text>Questionnaire&#160; </xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="120"/>
								<fo:table-column column-width="247"/>
								<fo:table-column column-width="72"/>
								<fo:table-column column-width="332"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" text-align="justify" display-align="before">
											<fo:block>
												<fo:inline width="40pt">
													<xsl:text>Questionnaire Name:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="Questionnaire">
													<xsl:for-each select="QuestionnaireName">
														<xsl:variable name="value-of-template">
															<xsl:apply-templates/>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																<fo:block>
																	<xsl:copy-of select="$value-of-template"/>
																</fo:block>
															</xsl:when>
															<xsl:otherwise>
																<fo:inline>
																	<xsl:copy-of select="$value-of-template"/>
																</fo:inline>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" text-align="justify" display-align="before">
											<fo:block>
												<fo:inline>
													<xsl:text>Description:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="Questionnaire">
													<xsl:for-each select="QuestionnaireDesc">
														<xsl:variable name="value-of-template">
															<xsl:apply-templates/>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																<fo:block>
																	<xsl:copy-of select="$value-of-template"/>
																</fo:block>
															</xsl:when>
															<xsl:otherwise>
																<fo:inline>
																	<xsl:copy-of select="$value-of-template"/>
																</fo:inline>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<xsl:for-each select="Questionnaire">
										<xsl:for-each select="ModuleUsage">
											<xsl:for-each select="ModuleInfo">
												<fo:table-row>
													<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" text-align="justify" display-align="before">
														<fo:block>
															<fo:inline>
																<xsl:text>Module:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="ModuleDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline>
																<xsl:text>Sub Module:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="SubModuleDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
									
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									
								</fo:table-body>
							</fo:table>
							<xsl:choose>
								<xsl:when test="/Questionnaire/ProtocolInfo">
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:table font-size="9pt" font-weight="bold" table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="120pt"/>
										<fo:table-column column-width="180pt"/>
										<fo:table-column column-width="180pt"/>
										<fo:table-column column-width="180pt"/>
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-weight="normal" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="Questionnaire">
															<xsl:for-each select="AnswerHeader">
																<xsl:for-each select="ModuleKey">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block width="2120pt">
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline width="2120pt">
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-left="70pt" text-align="left" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Sequence Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-weight="normal" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="Questionnaire">
															<xsl:for-each select="AnswerHeader">
																<xsl:for-each select="SubModuleKey">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-weight="normal" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="Questionnaire">
															<xsl:for-each select="ProtocolInfo">
																<xsl:for-each select="Title">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-left="70pt" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Prinicipal Investigator:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-weight="normal" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="Questionnaire">
															<xsl:for-each select="ProtocolInfo">
																<xsl:for-each select="Investigator">
																	<xsl:for-each select="Fullname">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</xsl:when>
								<xsl:when test="/Questionnaire/ProposalInfo">
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:table font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="120"/>
										<fo:table-column column-width="247"/>
										<fo:table-column column-width="150pt"/>
										<fo:table-column column-width="332"/>
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" text-align="justify" display-align="before">
													<fo:block>
														<fo:inline>
															<xsl:text>Proposal Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="Questionnaire">
															<xsl:for-each select="AnswerHeader">
																<xsl:for-each select="ModuleKey">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Principal Investigator:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="Questionnaire">
															<xsl:for-each select="ProposalInfo">
																<xsl:for-each select="Investigator">
																	<xsl:for-each select="Fullname">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:table font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="120"/>
										<fo:table-column column-width="1000"/>
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" text-align="justify" display-align="before">
													<fo:block>
														<fo:inline>
															<xsl:text>Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="Questionnaire">
															<xsl:for-each select="ProposalInfo">
																<xsl:for-each select="Title">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
										<xsl:if test="/Questionnaire/ProposalInfo/ProposalPersonUsed &gt; 0">
											<fo:table>
												<fo:table-column column-width="120"/>
												<fo:table-column column-width="247"/>
												<fo:table-column column-width="150pt"/>
												<fo:table-column column-width="332"/>
												<fo:table-body start-indent="0pt">
													<fo:table-row>
														<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" text-align="justify" display-align="before">
															<fo:block>
																<fo:inline>
																	<xsl:text>Proposal Person:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="Questionnaire">
																	<xsl:for-each select="ProposalInfo">
																		<xsl:for-each select="ProposalPersonName">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" text-align="justify" display-align="before">
															<fo:block>
																<fo:inline>
																	<xsl:text>Person Role:</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell padding="2pt" display-align="center">
															<fo:block>
																<xsl:for-each select="Questionnaire">
																	<xsl:for-each select="ProposalInfo">
																		<xsl:for-each select="ProposalPersonRole">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>															
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="auto">
															<fo:table>
																<fo:table-column column-width="75%"/>
																<fo:table-column column-width="25%"/>
																<fo:table-body>
                                                                    <fo:table-row>
                                                                         <fo:table-cell padding="2pt" display-align="auto">
                                                                             <fo:block>
                                                                                 My signature below certifies that I hereby authorize the above referenced proposal to be submitted as an institutionally authorized proposal.
                                                                             </fo:block>
                                                                             <fo:block>
                                                                                <xsl:text>&#160;</xsl:text>
                                                                             </fo:block>
                                                                             <fo:block>
                                                                                 Please contact your department Chairperson, Dean or OSPR if you cannot certify the following:
                                                                             </fo:block>
                                                                         </fo:table-cell>
                                                                         <fo:table-cell padding="2pt" display-align="auto">
                                                                             <fo:block>
                                                                             </fo:block>
                                                                         </fo:table-cell>
                                                                    </fo:table-row>
																</fo:table-body>
															</fo:table>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</xsl:if>
									<fo:block/>
								</xsl:when>
							</xsl:choose>
							<fo:block margin="0pt">
								<fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="Questionnaire">
															<xsl:for-each select="Questions">
																<xsl:if test="../UserOption/UserOptionsInfo/PrintAnswers  = &apos;No&apos;">
																	<xsl:for-each select="QuestionInfo">
																		<xsl:if test="not(  Question  =  preceding-sibling::QuestionInfo[1]/Question )">
																			<fo:block/>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:list-block provisional-distance-between-starts="7mm" provisional-label-separation="2mm">
																				<fo:list-item>
																					<fo:list-item-label end-indent="label-end()" text-align="right">
																						<fo:block font-family="ZapfDingbats" font-size="7pt">&#x25A0;</fo:block>
																					</fo:list-item-label>
																					<fo:list-item-body start-indent="body-start()">
																						<fo:block>
																							<xsl:for-each select="Question">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																							<fo:block>
																								<fo:leader leader-pattern="space"/>
																							</fo:block>
																							<fo:inline-container>
																								<fo:block>
																									<xsl:text>&#x2029;</xsl:text>
																								</fo:block>
																							</fo:inline-container>
																							<fo:block margin="0pt">
																								<fo:block/>
																							</fo:block>
																						</fo:block>
																					</fo:list-item-body>
																				</fo:list-item>
																			</fo:list-block>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:if>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block>
														<xsl:choose>
															<xsl:when test="/Questionnaire/UserOption/UserOptionsInfo/PrintAnsweredQuestionsOnly = &apos;Yes&apos;">
															
															 <xsl:for-each select="Questionnaire">
															 	<xsl:for-each select="Questions">
															 		<fo:block>
															  			<fo:leader leader-pattern="space" /> 
															  		</fo:block>
															  		<xsl:call-template name="Template1" /> 
															  </xsl:for-each>
															  </xsl:for-each>
															  <fo:block />  

															</xsl:when>
															<xsl:when test="/Questionnaire/UserOption/UserOptionsInfo/PrintAnsweredQuestionsOnly = &apos;No&apos;">
 
															 <xsl:for-each select="Questionnaire">
															 	<xsl:for-each select="Questions">
															 		<fo:block>
															  			<fo:leader leader-pattern="space" /> 
															  		</fo:block>
															  		<xsl:call-template name="Template1" /> 
															  </xsl:for-each>
															 </xsl:for-each>
															  <fo:block /> 
															</xsl:when>
														</xsl:choose>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:block>
							</fo:block>
						</xsl:for-each>
						<xsl:if test="/Questionnaire/ProposalInfo/ProposalPersonUsed &gt; 0">
							<fo:block><xsl:text>&#160;</xsl:text></fo:block>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="5%"/>
								<fo:table-column column-width="55%"/>
								<fo:table-column column-width="5%"/>
								<fo:table-column column-width="30%"/>
								<fo:table-column column-width="10%"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell>
											<fo:block><xsl:text>&#160;</xsl:text></fo:block>
										</fo:table-cell>
										<fo:table-cell border-bottom-style="solid" font-weight="bold">
											<fo:block><xsl:text>&#160;</xsl:text></fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block><xsl:text>&#160;</xsl:text></fo:block>
										</fo:table-cell>
										<fo:table-cell border-bottom-style="solid" font-weight="bold">
											<fo:block><xsl:text>&#160;</xsl:text></fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block><xsl:text>&#160;</xsl:text></fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell>
											<fo:block><xsl:text>&#160;</xsl:text></fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" text-align="right" display-align="before">
											<fo:block>
												<fo:inline>
													<xsl:text>Signature</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block><xsl:text>&#160;</xsl:text></fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="9pt" font-weight="bold" padding="2pt" text-align="justify" display-align="before">
											<fo:block>
												<fo:inline>
													<xsl:text>Date</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block><xsl:text>&#160;</xsl:text></fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</xsl:if>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>		
	</xsl:template>
	<xsl:template match="Questionnaire">
		<xsl:variable name="value-of-template">
			<xsl:apply-templates/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
				<fo:block>
					<xsl:copy-of select="$value-of-template"/>
				</fo:block>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline>
					<xsl:copy-of select="$value-of-template"/>
				</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Template1">
 		<xsl:for-each select="QuestionInfo">
			<fo:block>
				<fo:leader leader-pattern="space" /> 
			</fo:block>
			<fo:inline-container>
				<fo:block>
  					<xsl:text>​</xsl:text> 
  				</fo:block>
  			</fo:inline-container>
			<fo:list-block provisional-distance-between-starts="7mm" provisional-label-separation="2mm">
 				<fo:list-item>
 					<fo:list-item-label end-indent="label-end()" text-align="right">
  						<fo:block font-family="Courier">•</fo:block> 
  					</fo:list-item-label>
 					<fo:list-item-body start-indent="body-start()">
					 	<fo:block>
 							<xsl:call-template name="Template2" /> 
  						</fo:block>
  					</fo:list-item-body>
				</fo:list-item>
			</fo:list-block>
  		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Template2">
		<fo:inline-container>
			<fo:block>
  				<xsl:text>​</xsl:text> 
			</fo:block>
		</fo:inline-container>
		<fo:block margin="0pt">
			<xsl:for-each select="Question">
				<xsl:variable name="value-of-template_044058B8">
				<xsl:apply-templates /> 
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="contains(string($value-of-template_044058B8),'​')">
						<fo:block>
							<xsl:copy-of select="$value-of-template_044058B8" /> 
						</fo:block>
					</xsl:when>
				 	<xsl:otherwise>
				 		<fo:inline>
				  			<xsl:copy-of select="$value-of-template_044058B8" /> 
				  		</fo:inline>
				  	</xsl:otherwise>
				 </xsl:choose>
			</xsl:for-each>
		</fo:block>
		<fo:inline-container>
			<fo:block>
		  		<xsl:text>​</xsl:text> 
		  	</fo:block>
	  	</fo:inline-container>
		<fo:block margin="0pt">
			<xsl:for-each select="AnswerInfo">
				<xsl:for-each select="Answer">
					<xsl:variable name="value-of-template_04405998">
	  				<xsl:apply-templates /> 
	 				</xsl:variable>
		 			<xsl:choose>
			 			<xsl:when test="contains(string($value-of-template_04405998),'​')">
							<fo:block>
							 	<xsl:copy-of select="$value-of-template_04405998" /> 
							</fo:block>
						</xsl:when>
						<xsl:otherwise>
							<fo:inline>
							 	<xsl:copy-of select="$value-of-template_04405998" /> 
							</fo:inline>
						</xsl:otherwise>
				 	</xsl:choose>
				</xsl:for-each>
			</xsl:for-each>
		</fo:block>
		<fo:inline-container>
			<fo:block>
				<xsl:text>​</xsl:text> 
			</fo:block>
		</fo:inline-container>
		<fo:block margin="0pt">
			<xsl:call-template name="Template1" /> 
		</fo:block>
	</xsl:template>

	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
