/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.core;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.kuali.coeus.common.budget.framework.core.AbstractBudget;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.framework.auth.perm.DocumentLevelPermissionable;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.rice.kns.web.ui.ExtraButton;

@MappedSuperclass
public abstract class BudgetParentDocument<T extends BudgetParent>
extends KcTransactionalDocumentBase
implements DocumentLevelPermissionable {
    public Integer getNextBudgetVersionNumber() {
        List<? extends Budget> versions = this.getBudgetParent().getBudgets();
        if (versions.isEmpty()) {
            return 1;
        }
        Collections.sort(versions, new Comparator<Budget>(this){

            @Override
            public int compare(Budget o1, Budget o2) {
                return new CompareToBuilder().append((Object)o1.getBudgetVersionNumber(), (Object)o2.getBudgetVersionNumber()).toComparison() * -1;
            }
        });
        Budget lastVersion = versions.get(0);
        return lastVersion.getBudgetVersionNumber() + 1;
    }

    public Budget getBudgetDocumentVersion(int selectedLine) {
        return this.getBudgetParent().getBudgets().get(selectedLine);
    }

    public void updateBudgetDescriptions(List<? extends AbstractBudget> budgetVersions) {
        for (AbstractBudget abstractBudget : budgetVersions) {
            if (!abstractBudget.isNameUpdatable() || StringUtils.isBlank((CharSequence)abstractBudget.getName())) continue;
            abstractBudget.setNameUpdatable(false);
        }
    }

    public abstract Permissionable getBudgetPermissionable();

    public abstract boolean isComplete();

    public abstract ExtraButton configureReturnToParentTopButton();

    public abstract T getBudgetParent();
}

