/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.cache;

import java.util.Set;
import org.kuali.coeus.common.cache.RequestLevelCacheResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.annotation.RequestScope;

@Configuration
public class RequestLevelCacheConfiguration {
    static final String REQUEST_LEVEL_CACHE_MANAGER = "requestLevelCacheManager";
    public static final String REQUEST_LEVEL_CACHE_RESOLVER = "requestLevelCacheResolver";
    public static final String RULES_CACHE = "rules";

    @Bean(value={"requestLevelCacheManager"})
    @RequestScope
    public CacheManager requestLevelCacheManager() {
        SimpleCacheManager requestLevelCacheManager = new SimpleCacheManager();
        requestLevelCacheManager.setCaches(Set.of(new ConcurrentMapCache(RULES_CACHE)));
        return requestLevelCacheManager;
    }

    @Bean(value={"requestLevelCacheResolver"})
    public CacheResolver requestLevelCacheResolver(@Qualifier(value="requestLevelCacheManager") CacheManager requestLevelCacheManager) {
        return new RequestLevelCacheResolver(requestLevelCacheManager);
    }
}

