/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.version.VersionException;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.coeus.sys.framework.util.ObjectCopyUtils;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.notesandattachments.notes.AwardNotepad;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AwardHierarchyServiceImpl
implements AwardHierarchyService {
    private static final Logger LOG = LogManager.getLogger(AwardHierarchyServiceImpl.class);
    private static final String DOCUMENT_DESCRIPTION_FIELD_NAME = "documentDescription";
    AwardNumberService awardNumberService;
    LegacyDataAdapter legacyDataAdapter;
    DocumentService documentService;
    VersioningService versioningService;
    VersionHistoryService versionHistoryService;
    AwardAmountInfoService awardAmountInfoService;
    ParameterService parameterService;
    private AwardService awardService;
    AwardVersionService awardVersionService;
    GlobalVariableService globalVariableService;

    @Override
    public AwardHierarchy copyAwardAndAllDescendantsAsNewHierarchy(AwardHierarchy targetNode) {
        String newRootAwardNumber = this.awardNumberService.getNextAwardNumber();
        AwardHierarchy newRootNode = this.createBasicHierarchy(newRootAwardNumber);
        Award newRootAward = this.copyAward(targetNode.getAward(), newRootAwardNumber);
        newRootNode.setAward(newRootAward);
        this.finalizeAward(newRootAward);
        for (AwardHierarchy childNode : targetNode.getChildren()) {
            this.copyNodeRecursively(childNode, newRootNode, newRootNode);
        }
        return newRootNode;
    }

    @Override
    public AwardHierarchy copyAwardAndDescendantsAsChildOfAnAwardInAnotherHierarchy(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        return this.copyAwardAndDescendantsAsChildOfAnotherNode(sourceNode, targetParentNode);
    }

    @Override
    public AwardHierarchy copyAwardAndDescendantsAsChildOfAnAwardInCurrentHierarchy(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        return this.copyAwardAndDescendantsAsChildOfAnotherNode(sourceNode, targetParentNode);
    }

    @Override
    public AwardHierarchy copyAwardAsChildOfAnAwardInAnotherHierarchy(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        return this.copyAwardAsChildOfAnotherNode(sourceNode, targetParentNode);
    }

    @Override
    public AwardHierarchy copyAwardAsChildOfAnAwardInCurrentHierarchy(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        return this.copyAwardAsChildOfAnotherNode(sourceNode, targetParentNode);
    }

    @Override
    public AwardHierarchy copyAwardAsNewHierarchy(AwardHierarchy targetNode) {
        String nextAwardNumber = this.awardNumberService.getNextAwardNumber();
        Award newAward = this.copyAward(targetNode.getAward(), nextAwardNumber);
        newAward.setAwardDirectFandADistributions(new ArrayList<AwardDirectFandADistribution>());
        AwardHierarchy newNode = this.createBasicHierarchy(nextAwardNumber);
        newNode.setAward(newAward);
        return newNode;
    }

    @Override
    public AwardHierarchy createBasicHierarchy(String awardNumber) {
        return new AwardHierarchy(awardNumber, "000000-00000", awardNumber, awardNumber);
    }

    @Override
    public AwardHierarchy createNewAwardBasedOnAnotherAwardInHierarchy(AwardHierarchy nodeToCopyFrom, AwardHierarchy targetParentNode) {
        return this.copyAwardAsChildOfAnotherNode(nodeToCopyFrom, targetParentNode);
    }

    public void copyAwardAmountDateInfo(Award source, Award copy) {
        ArrayList<AwardAmountInfo> awardAmountInfoList = new ArrayList<AwardAmountInfo>();
        AwardAmountInfo initialInfo = new AwardAmountInfo();
        AwardAmountInfo awardAmount = source.getLastAwardAmountInfo();
        AwardAmountInfo awardAmountInfo = new AwardAmountInfo();
        awardAmountInfo.setFinalExpirationDate(awardAmount.getFinalExpirationDate());
        awardAmountInfo.setCurrentFundEffectiveDate(awardAmount.getCurrentFundEffectiveDate());
        awardAmountInfo.setObligationExpirationDate(awardAmount.getObligationExpirationDate());
        initialInfo.setFinalExpirationDate(awardAmount.getFinalExpirationDate());
        initialInfo.setCurrentFundEffectiveDate(awardAmount.getCurrentFundEffectiveDate());
        initialInfo.setObligationExpirationDate(awardAmount.getObligationExpirationDate());
        awardAmountInfo.setOriginatingAwardVersion(1);
        awardAmountInfo.setAward(copy);
        initialInfo.setAward(copy);
        awardAmountInfoList.add(initialInfo);
        awardAmountInfoList.add(awardAmountInfo);
        copy.setAwardAmountInfos(awardAmountInfoList);
    }

    @Override
    public AwardHierarchy createNewAwardBasedOnParent(AwardHierarchy targetNode) {
        String nextAwardNumber = this.generateNextAwardNumberInSequence(targetNode);
        Award newAward = this.copyAward(targetNode.getAward(), nextAwardNumber);
        AwardHierarchy newNode = new AwardHierarchy(targetNode.getRoot(), targetNode, nextAwardNumber, targetNode.getAward().getAwardNumber());
        newNode.setAward(newAward);
        targetNode.getChildren().add(newNode);
        return newNode;
    }

    public void copyAwardAmountDateInfoToNewChild(Award source, Award copy) {
        AwardAmountInfo parentAai = source.getAwardAmountInfos().get(source.getAwardAmountInfos().size() - 1);
        AwardAmountInfo awardAmountInfo = new AwardAmountInfo();
        awardAmountInfo.setFinalExpirationDate(parentAai.getFinalExpirationDate());
        awardAmountInfo.setCurrentFundEffectiveDate(parentAai.getCurrentFundEffectiveDate());
        awardAmountInfo.setObligationExpirationDate(parentAai.getObligationExpirationDate());
        awardAmountInfo.setAward(copy);
        copy.setAwardAmountInfos(new ArrayList<AwardAmountInfo>());
        copy.getAwardAmountInfos().add(awardAmountInfo);
    }

    @Override
    public AwardHierarchy createNewChildAward(AwardHierarchy targetNode) {
        Award newAward = new Award();
        Award copyDateAward = targetNode.getAward();
        newAward.setAwardNumber(this.generateNextAwardNumberInSequence(targetNode));
        AwardHierarchy newNode = new AwardHierarchy(targetNode.getRoot(), targetNode, newAward.getAwardNumber(), newAward.getAwardNumber());
        this.copyAwardAmountDateInfoToNewChild(copyDateAward, newAward);
        newNode.setAward(newAward);
        targetNode.getChildren().add(newNode);
        return newNode;
    }

    @Override
    public AwardHierarchy loadAwardHierarchy(String awardNumber) {
        return awardNumber == null || awardNumber.equals("000000-00000") ? null : this.loadAwardHierarchyBranch(awardNumber);
    }

    @Override
    public AwardHierarchy loadAwardHierarchyBranch(String awardNumber) {
        Map<String, AwardHierarchy> hierarchy = this.getAwardHierarchy(awardNumber, new ArrayList<String>());
        return hierarchy.get(awardNumber);
    }

    @Override
    public Map<String, AwardHierarchy> getAwardHierarchy(AwardHierarchy anyNode, List<String> order) {
        if (anyNode == null) {
            return Collections.emptyMap();
        }
        String rootAwardNumber = StringUtils.equals((CharSequence)"000000-00000", (CharSequence)anyNode.getRootAwardNumber()) ? anyNode.getAwardNumber() : anyNode.getRootAwardNumber();
        Map<String, AwardHierarchy> activeHierarchy = this.legacyDataAdapter.findMatching(AwardHierarchy.class, Map.of("rootAwardNumber", rootAwardNumber, "active", true)).stream().peek(hierarchy -> hierarchy.getChildren().clear()).map(hierarchy -> CollectionUtils.entry(hierarchy.getAwardNumber(), hierarchy)).collect(CollectionUtils.entriesToMap());
        if (!activeHierarchy.isEmpty()) {
            AwardHierarchy rootNode = (AwardHierarchy)activeHierarchy.get(rootAwardNumber);
            this.setRelationships(activeHierarchy, rootNode);
            this.sortChildren(activeHierarchy);
            this.setOrder(order, rootNode);
            return activeHierarchy;
        }
        return Collections.emptyMap();
    }

    private void setRelationships(Map<String, AwardHierarchy> hierarchies, AwardHierarchy rootNode) {
        hierarchies.values().forEach(hierarchy -> {
            hierarchy.setRoot(rootNode);
            AwardHierarchy parent = (AwardHierarchy)hierarchies.get(hierarchy.getParentAwardNumber());
            if (parent != null) {
                parent.getChildren().add((AwardHierarchy)hierarchy);
                hierarchy.setParent(parent);
            }
        });
    }

    private void sortChildren(Map<String, AwardHierarchy> hierarchies) {
        hierarchies.forEach((awardNumber, hierarchy) -> hierarchy.getChildren().sort(Comparator.comparing(AwardHierarchy::getAwardNumber)));
    }

    private void setOrder(List<String> order, AwardHierarchy rootNode) {
        LinkedList<AwardHierarchy> queue = new LinkedList<AwardHierarchy>();
        queue.add(rootNode);
        while (!queue.isEmpty()) {
            AwardHierarchy node = (AwardHierarchy)queue.poll();
            order.add(node.getAwardNumber());
            queue.addAll(node.getChildren());
        }
    }

    @Override
    public Map<String, AwardHierarchy> getAwardHierarchy(String awardNumber, List<String> order) {
        return this.getAwardHierarchy(this.loadSingleAwardHierarchyNode(awardNumber), order);
    }

    @Override
    public AwardHierarchy loadFullHierarchyFromAnyNode(String awardNumber) {
        ArrayList<String> order = new ArrayList<String>();
        Map<String, AwardHierarchy> hierarchy = this.getAwardHierarchy(awardNumber, order);
        if (!order.isEmpty()) {
            return hierarchy.get(order.get(0));
        }
        return null;
    }

    public AwardDocument loadPlaceholderDocument() {
        Collection<DocumentHeader> headers = this.findPlaceholderDocumentHeaders();
        try {
            for (DocumentHeader header : headers) {
                Document document = this.documentService.getByDocumentHeaderId(header.getDocumentNumber());
                if (!(document instanceof AwardDocument)) continue;
                return (AwardDocument)document;
            }
            return this.createPlaceholderDocument();
        }
        catch (WorkflowException e) {
            throw this.uncheckedException((Exception)((Object)e));
        }
    }

    @Override
    public void persistAwardHierarchy(AwardHierarchy node) {
        if (node.isNew()) {
            this.legacyDataAdapter.save((Object)node);
        }
    }

    @Override
    public void persistAwardHierarchies(Collection<AwardHierarchy> rootNodes) {
        if (rootNodes == null || rootNodes.size() == 0) {
            return;
        }
        for (AwardHierarchy rootNode : rootNodes) {
            this.persistAwardHierarchy(rootNode, true);
        }
    }

    @Override
    public void persistAwardHierarchy(AwardHierarchy branchNode, boolean recurse) {
        AwardDocument placeholderDocument = this.loadPlaceholderDocument();
        if (placeholderDocument != null) {
            int startingAwardCount = placeholderDocument.getAwardList().size();
            if (branchNode.hasChildren() && recurse) {
                List<AwardHierarchy> nodes = branchNode.getFlattenedListOfNodesInHierarchy();
                for (AwardHierarchy node : nodes) {
                    this.saveNodeWithAward(node, placeholderDocument);
                }
            } else {
                this.saveNodeWithAward(branchNode, placeholderDocument);
            }
            if (placeholderDocument.getAwardList().size() > startingAwardCount) {
                this.savePlaceholderDocument(placeholderDocument);
            }
        }
    }

    public void setAwardNumberService(AwardNumberService awardNumberService) {
        this.awardNumberService = awardNumberService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    Award copyAward(Award award, String nextAwardNumber) {
        Award newAward;
        try {
            String originalAwardNumber = award.getAwardNumber();
            Integer originalSequenceNumber = award.getSequenceNumber();
            ObjectCopyUtils.prepareObjectForDeepCopy(award);
            AwardDocument document = award.getAwardDocument();
            award.setAwardDocument(null);
            newAward = this.useOriginalAwardAsTemplateForCopy(award, nextAwardNumber);
            this.restoreOriginalAwardPropertiesAfterCopy(award, originalAwardNumber, originalSequenceNumber);
            award.setAwardDocument(document);
            this.copyAwardAmountDateInfo(award, newAward);
            award.setBudgets(new ArrayList<AwardBudgetExt>());
            newAward.setCurrentVersionBudgets(new ArrayList<AwardBudgetExt>());
            newAward.setSpecialReviews(new ArrayList<AwardSpecialReview>());
            this.clearFilteredAttributes(newAward);
            this.getAwardService().synchNewCustomAttributes(newAward, award);
            this.getAwardService().synchExistingCustomAttributes(newAward, award);
        }
        catch (Exception e) {
            throw this.uncheckedException(e);
        }
        return newAward;
    }

    protected void clearFilteredAttributes(Award newAward) {
        newAward.setAccountNumber(null);
        newAward.setFinancialAccountCreationDate(null);
        newAward.setFinancialAccountDocumentNumber(null);
        newAward.setFinancialChartOfAccountsCode(null);
        newAward.setNoticeDate(null);
        newAward.getFundingProposals().clear();
        newAward.getAllFundingProposals().clear();
        newAward.setAwardApprovedSubawards(new ArrayList<AwardApprovedSubaward>());
        newAward.setApprovedEquipmentItems(new ArrayList<AwardApprovedEquipment>());
        newAward.setApprovedForeignTravelTrips(new ArrayList<AwardApprovedForeignTravel>());
        newAward.setAwardNotepads(new ArrayList<AwardNotepad>());
        if (!this.shouldCopyModificationNumber()) {
            newAward.setModificationNumber(null);
        }
        try {
            String defaultTxnTypeStr = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "TXN_TYPE_DEF_COPIED_AWARD");
            if (StringUtils.isNotEmpty((CharSequence)defaultTxnTypeStr)) {
                newAward.setAwardTransactionTypeCode(Integer.parseInt(defaultTxnTypeStr));
            }
        }
        catch (Exception defaultTxnTypeStr) {
            // empty catch block
        }
        newAward.setAwardCloseoutItems(new ArrayList<AwardCloseout>());
        newAward.getAwardAttachments().clear();
        newAward.getSyncChanges().clear();
        newAward.getSyncStatuses().clear();
        newAward.getAwardBudgetLimits().clear();
        ArrayList<AwardReportTerm> newTerms = new ArrayList<AwardReportTerm>();
        String paymentReportClassCode = this.getPaymentAndInvoicesReportClass().getReportClassCode();
        for (AwardReportTerm term : newAward.getAwardReportTermItems()) {
            if (!this.shouldCopyPaymentInvTerms() && StringUtils.equals((CharSequence)paymentReportClassCode, (CharSequence)term.getReportClassCode())) continue;
            newTerms.add(term);
        }
        newAward.setAwardReportTermItems(newTerms);
        newAward.getPaymentScheduleItems().clear();
    }

    protected boolean shouldCopyModificationNumber() {
        return this.parameterService.getParameterValueAsBoolean("KC-AWARD", "Document", "AWARD_COPY_MOD_NUM");
    }

    protected boolean shouldCopyPaymentInvTerms() {
        return this.parameterService.getParameterValueAsBoolean("KC-AWARD", "Document", "INCLUDE_PAYMNT_INV_REQMTS_ON_COPY", Boolean.valueOf(false));
    }

    protected ReportClass getPaymentAndInvoicesReportClass() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("DESCRIPTION", "Payment/Invoice");
        return (ReportClass)this.legacyDataAdapter.findMatching(ReportClass.class, param).iterator().next();
    }

    AwardHierarchy copyAwardAsChildOfAnotherNode(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        String newAwardNumber = this.generateNextAwardNumberInSequence(targetParentNode);
        AwardHierarchy newLeafNode = new AwardHierarchy(targetParentNode.getRoot(), targetParentNode, newAwardNumber, sourceNode.getOriginatingAwardNumber());
        Award newLeafAward = this.copyAward(sourceNode.getAward(), newAwardNumber);
        newLeafNode.setAward(newLeafAward);
        targetParentNode.getChildren().add(newLeafNode);
        return newLeafNode;
    }

    protected AwardHierarchy getCopyOfSourceNode(AwardHierarchy sourceNode) {
        return sourceNode.clone();
    }

    AwardHierarchy copyAwardAndDescendantsAsChildOfAnotherNode(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        String newAwardNumber = this.generateNextAwardNumberInSequence(targetParentNode);
        AwardHierarchy newSource = this.getCopyOfSourceNode(sourceNode);
        List<AwardHierarchy> sourceChildren = Collections.unmodifiableList(newSource.getChildren());
        AwardHierarchy newBranchNode = new AwardHierarchy(targetParentNode.getRoot(), targetParentNode, newAwardNumber, sourceNode.getOriginatingAwardNumber());
        Award newBranchAward = this.copyAward(sourceNode.getAward(), newAwardNumber);
        this.finalizeAward(newBranchAward);
        targetParentNode.getChildren().add(newBranchNode);
        newBranchNode.setAward(newBranchAward);
        for (AwardHierarchy childNode : sourceChildren) {
            this.copyNodeRecursively(childNode, newBranchNode, targetParentNode.getRoot());
        }
        return newBranchNode;
    }

    protected void finalizeAward(Award newAward) {
        this.versionHistoryService.updateVersionHistory(newAward, VersionStatus.ACTIVE, GlobalVariables.getUserSession().getPrincipalName());
        this.awardService.updateAwardSequenceStatus(newAward, VersionStatus.ACTIVE);
    }

    void copyNodeRecursively(AwardHierarchy sourceNode, AwardHierarchy newParentNode, AwardHierarchy newRootNode) {
        String nextAwardNumberInHierarchy = this.generateNextAwardNumberInSequence(newParentNode);
        List<AwardHierarchy> sourceChildren = Collections.unmodifiableList(sourceNode.getChildren());
        AwardHierarchy newNode = new AwardHierarchy(newRootNode, newParentNode, nextAwardNumberInHierarchy, sourceNode.getOriginatingAwardNumber());
        Award newAward = this.copyAward(sourceNode.getAward(), nextAwardNumberInHierarchy);
        newNode.setAward(newAward);
        newParentNode.getChildren().add(newNode);
        this.finalizeAward(newAward);
        for (AwardHierarchy childNode : sourceChildren) {
            this.copyNodeRecursively(childNode, newNode, newRootNode);
        }
    }

    AwardDocument createPlaceholderDocument() throws WorkflowException {
        return this.getGlobalVariableService().doInNewGlobalVariables(new UserSession("admin"), () -> {
            AwardDocument document = (AwardDocument)this.documentService.getNewDocument(AwardDocument.class);
            document.getDocumentHeader().setDocumentDescription("*****PLACEHOLDER*****");
            document.getAwardList().clear();
            this.documentService.saveDocument((Document)document);
            this.documentService.blanketApproveDocument((Document)document, "Placeholder being routed to final", Collections.emptyList());
            LOG.info("Created Placeholder Document #" + document.getDocumentNumber());
            return document;
        });
    }

    Collection<DocumentHeader> findPlaceholderDocumentHeaders() {
        return this.legacyDataAdapter.findMatching(DocumentHeader.class, this.getDocumentDescriptionCriteriaMap());
    }

    AwardHierarchy loadSingleAwardHierarchyNode(String awardNumber) {
        return (AwardHierarchy)this.legacyDataAdapter.findByPrimaryKey(AwardHierarchy.class, this.getAwardHierarchyCriteriaMap(awardNumber));
    }

    Map<String, Object> getDocumentDescriptionCriteriaMap() {
        return Collections.singletonMap(DOCUMENT_DESCRIPTION_FIELD_NAME, "*****PLACEHOLDER*****");
    }

    protected void addNewAwardToPlaceholderDocument(AwardDocument doc, AwardHierarchy node) {
        Award award = node.getAward();
        if (award.isNew()) {
            doc.getAwardList().add(award);
        }
    }

    protected Map<String, Object> getAwardHierarchyCriteriaMap(String awardNumber) {
        return CollectionUtils.zipMap(new String[]{"awardNumber", "active"}, new Object[]{awardNumber, Boolean.TRUE});
    }

    protected void restoreOriginalAwardPropertiesAfterCopy(Award award, String originalAwardNumber, Integer originalSequenceNumber) {
        award.setAwardNumber(originalAwardNumber);
        award.setSequenceNumber(originalSequenceNumber);
    }

    protected void saveNodeWithAward(AwardHierarchy node, AwardDocument doc) {
        if (node.isNew()) {
            this.persistAwardHierarchy(node);
            this.addNewAwardToPlaceholderDocument(doc, node);
        }
    }

    protected void savePlaceholderDocument(AwardDocument doc) {
        try {
            this.documentService.saveDocument((Document)doc);
        }
        catch (WorkflowException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected RuntimeException uncheckedException(Exception e) {
        return new RuntimeException(e.getMessage(), e);
    }

    protected Award useOriginalAwardAsTemplateForCopy(Award award, String nextAwardNumber) throws VersionException {
        String originalAwardNumber = award.getAwardNumber();
        String originalFundingProposal = award.getAllFundingProposalsSortedBySequence().stream().findFirst().map(awardFundingProposal -> awardFundingProposal.getProposal().getProposalNumber()).orElse("None");
        award.setAwardNumber(nextAwardNumber);
        award.setSequenceNumber(0);
        Award newAward = this.versioningService.createNewVersion(award);
        newAward.getAwardComments().stream().filter(awardComment -> StringUtils.equals((CharSequence)"21", (CharSequence)awardComment.getCommentType().getCommentTypeCode())).forEach(awardComment -> awardComment.setComments("Copied Award from " + originalAwardNumber + "\nFunding Proposal: " + originalFundingProposal));
        return newAward;
    }

    @Override
    public void populateAwardHierarchyNodes(Map<String, AwardHierarchy> awardHierarchyItems, Map<String, AwardHierarchyNode> awardHierarchyNodes, String currentAwardNumber, String currentSequenceNumber) {
        for (Map.Entry<String, AwardHierarchy> awardHierarchy : awardHierarchyItems.entrySet()) {
            String tmpAwardNumber = awardHierarchy.getValue().getAwardNumber();
            if (awardHierarchyNodes.get(tmpAwardNumber) != null) continue;
            AwardHierarchyNode awardHierarchyNode = this.createAwardHierarchyNode(awardHierarchy.getValue(), currentAwardNumber, currentSequenceNumber);
            awardHierarchyNodes.put(awardHierarchyNode.getAwardNumber(), awardHierarchyNode);
        }
    }

    @Override
    public AwardHierarchyNode createAwardHierarchyNode(AwardHierarchy awardHierarchy, String currentAwardNumber, String currentSequenceNumber) {
        String awardNumber = awardHierarchy.getAwardNumber();
        AwardHierarchyNode awardHierarchyNode = new AwardHierarchyNode();
        awardHierarchyNode.setAwardNumber(awardNumber);
        awardHierarchyNode.setParentAwardNumber(awardHierarchy.getParentAwardNumber());
        awardHierarchyNode.setRootAwardNumber(awardHierarchy.getRootAwardNumber());
        VersionHistory activeVersionHistory = this.versionHistoryService.findActiveVersion(Award.class, awardNumber);
        Award award = this.awardVersionService.getWorkingAwardVersion(awardNumber);
        if (award == null) {
            award = this.getAwardFromDatabase(awardNumber);
        }
        AwardAmountInfo awardAmountInfo = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
        awardHierarchyNode.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        awardHierarchyNode.setLeadUnitName(award.getUnitName());
        awardHierarchyNode.setPrincipalInvestigatorName(award.getPrincipalInvestigatorName());
        awardHierarchyNode.setAccountNumber(award.getAccountNumber());
        awardHierarchyNode.setAwardStatusCode(award.getStatusCode());
        awardHierarchyNode.setObliDistributableAmount(awardAmountInfo.getObliDistributableAmount());
        awardHierarchyNode.setAmountObligatedToDate(awardAmountInfo.getAmountObligatedToDate());
        awardHierarchyNode.setObligatedTotalDirect(awardAmountInfo.getObligatedTotalDirect());
        awardHierarchyNode.setObligatedTotalIndirect(awardAmountInfo.getObligatedTotalIndirect());
        awardHierarchyNode.setAnticipatedTotalAmount(awardAmountInfo.getAnticipatedTotalAmount());
        awardHierarchyNode.setAnticipatedTotalDirect(awardAmountInfo.getAnticipatedTotalDirect());
        awardHierarchyNode.setAnticipatedTotalIndirect(awardAmountInfo.getAnticipatedTotalIndirect());
        awardHierarchyNode.setAntDistributableAmount(awardAmountInfo.getAntDistributableAmount());
        awardHierarchyNode.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        awardHierarchyNode.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        awardHierarchyNode.setProjectStartDate(award.getAwardEffectiveDate());
        awardHierarchyNode.setTitle(award.getTitle());
        awardHierarchyNode.setAwardId(award.getAwardId());
        awardHierarchyNode.setAwardDocumentNumber(award.getAwardDocument().getDocumentNumber());
        awardHierarchyNode.setHasChildren(!awardHierarchy.getChildren().isEmpty());
        awardHierarchyNode.setAwardDocumentFinalStatus(activeVersionHistory != null);
        return awardHierarchyNode;
    }

    @Override
    public String generateNextAwardNumberInSequence(AwardHierarchy awardHierarchy) {
        return this.generateNextAwardNumberInSequence(Stream.concat(Stream.of(awardHierarchy), this.legacyDataAdapter.findMatching(AwardHierarchy.class, Map.of("rootAwardNumber", awardHierarchy.getRootAwardNumber())).stream()).map(AwardHierarchy::getAwardNumber).collect(Collectors.toSet()));
    }

    String generateNextAwardNumberInSequence(Set<String> hierarchy) {
        String maximumAwardNumber = Collections.max(hierarchy);
        String[] parts = maximumAwardNumber.split("-");
        Integer nextVal = Integer.parseInt(parts[1]) + 1;
        return String.format("%s-%05d", parts[0], nextVal);
    }

    private Award getAwardFromDatabase(String awardNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("awardNumber", awardNumber);
        List awardList = this.legacyDataAdapter.findMatchingOrderBy(Award.class, map, "sequenceNumber", true);
        return (Award)awardList.get(awardList.size() - 1);
    }

    @Override
    public void populateAwardHierarchyNodesForTandMDoc(Map<String, AwardHierarchy> awardHierarchyItems, Map<String, AwardHierarchyNode> awardHierarchyNodes, String currentAwardNumber, String currentSequenceNumber, TimeAndMoneyDocument timeAndMoneyDocument) {
        Map<String, Award> activeAwardsInHierarchy = this.awardVersionService.getAllActiveAwardsForHierarchy(currentAwardNumber).stream().collect(Collectors.toMap(Award::getAwardNumber, award -> award));
        for (Map.Entry<String, AwardHierarchy> awardHierarchy : awardHierarchyItems.entrySet()) {
            String tmpAwardNumber = awardHierarchy.getValue().getAwardNumber();
            AwardHierarchyNode awardHierarchyNode = new AwardHierarchyNode();
            awardHierarchyNode.setAwardNumber(tmpAwardNumber);
            awardHierarchyNode.setParentAwardNumber(awardHierarchy.getValue().getParentAwardNumber());
            awardHierarchyNode.setRootAwardNumber(awardHierarchy.getValue().getRootAwardNumber());
            Award award2 = activeAwardsInHierarchy.get(tmpAwardNumber);
            if (award2 == null) {
                award2 = this.awardVersionService.getPendingAwardVersion(tmpAwardNumber);
            }
            AwardAmountInfo awardAmountInfo = this.awardAmountInfoService.fetchLastAwardAmountInfoForDocNum(award2, timeAndMoneyDocument.getDocumentNumber());
            awardHierarchyNode.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
            awardHierarchyNode.setLeadUnitName(award2.getUnitName());
            awardHierarchyNode.setPrincipalInvestigatorName(award2.getPrincipalInvestigatorName());
            awardHierarchyNode.setAccountNumber(award2.getAccountNumber());
            awardHierarchyNode.setAwardStatusCode(award2.getStatusCode());
            awardHierarchyNode.setObliDistributableAmount(awardAmountInfo.getObliDistributableAmount());
            awardHierarchyNode.setAntDistributableAmount(awardAmountInfo.getAntDistributableAmount());
            ScaleTwoDecimal obligatedTotal = awardAmountInfo.getAmountObligatedToDate();
            ScaleTwoDecimal obligatedTotalDirect = awardAmountInfo.getObligatedTotalDirect();
            ScaleTwoDecimal obligatedTotalIndirect = awardAmountInfo.getObligatedTotalIndirect();
            ScaleTwoDecimal anticipatedTotalAmount = awardAmountInfo.getAnticipatedTotalAmount();
            ScaleTwoDecimal anticipatedTotalDirect = awardAmountInfo.getAnticipatedTotalDirect();
            ScaleTwoDecimal anticipatedTotalIndirect = awardAmountInfo.getAnticipatedTotalIndirect();
            for (PendingTransaction pendingTransaction : timeAndMoneyDocument.getPendingTransactions()) {
                if (pendingTransaction.getProcessedFlag().booleanValue() || !pendingTransaction.isSingleNodeTransaction()) continue;
                obligatedTotal = (ScaleTwoDecimal)obligatedTotal.add((AbstractDecimal)pendingTransaction.getObligatedAmount());
                obligatedTotalDirect = (ScaleTwoDecimal)obligatedTotalDirect.add((AbstractDecimal)pendingTransaction.getObligatedDirectAmount());
                obligatedTotalIndirect = (ScaleTwoDecimal)obligatedTotalIndirect.add((AbstractDecimal)pendingTransaction.getObligatedIndirectAmount());
                anticipatedTotalAmount = (ScaleTwoDecimal)anticipatedTotalAmount.add((AbstractDecimal)pendingTransaction.getAnticipatedAmount());
                anticipatedTotalDirect = (ScaleTwoDecimal)anticipatedTotalDirect.add((AbstractDecimal)pendingTransaction.getAnticipatedDirectAmount());
                anticipatedTotalIndirect = (ScaleTwoDecimal)anticipatedTotalIndirect.add((AbstractDecimal)pendingTransaction.getAnticipatedIndirectAmount());
            }
            awardHierarchyNode.setAmountObligatedToDate(obligatedTotal);
            awardHierarchyNode.setObligatedTotalDirect(obligatedTotalDirect);
            awardHierarchyNode.setObligatedTotalIndirect(obligatedTotalIndirect);
            awardHierarchyNode.setAnticipatedTotalAmount(anticipatedTotalAmount);
            awardHierarchyNode.setAnticipatedTotalDirect(anticipatedTotalDirect);
            awardHierarchyNode.setAnticipatedTotalIndirect(anticipatedTotalIndirect);
            awardHierarchyNode.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
            awardHierarchyNode.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
            awardHierarchyNode.setProjectStartDate(award2.getAwardEffectiveDate());
            awardHierarchyNode.setTitle(award2.getTitle());
            awardHierarchyNode.setAwardId(award2.getAwardId());
            awardHierarchyNode.setAwardDocumentFinalStatus(VersionStatus.ACTIVE.toString().equals(award2.getAwardSequenceStatus()));
            awardHierarchyNodes.put(awardHierarchyNode.getAwardNumber(), awardHierarchyNode);
        }
    }

    public AwardVersionService getAwardVersionService() {
        this.awardVersionService = KcServiceLocator.getService(AwardVersionService.class);
        return this.awardVersionService;
    }

    @Override
    public void createNodeMapsOnFormForSummaryPanel(Map<String, AwardHierarchyNode> awardHierarchyNodes, Map<String, String> previousNodeMap, Map<String, String> nextNodeMap) {
        ArrayList<AwardHierarchy> sortedList = new ArrayList<AwardHierarchy>();
        AwardHierarchy rootNode = this.loadFullHierarchyFromAnyNode(this.getRootNode(awardHierarchyNodes).getAwardNumber());
        sortedList.add(rootNode);
        for (AwardHierarchy ah : rootNode.getChildren()) {
            sortedList.add(ah);
            this.addChildrenToSortedList(ah, sortedList);
        }
        nextNodeMap.clear();
        previousNodeMap.clear();
        previousNodeMap.put(rootNode.getAwardNumber(), "000000-00000");
        this.addSubNodesToPreviousNodeMap(sortedList, previousNodeMap);
        this.addNodesToNextNodeMap(sortedList, nextNodeMap);
    }

    private void addChildrenToSortedList(AwardHierarchy ah, List<AwardHierarchy> sortedList) {
        if (ah.hasChildren()) {
            for (AwardHierarchy awardHierarchy : ah.getChildren()) {
                sortedList.add(awardHierarchy);
                this.addChildrenToSortedList(awardHierarchy, sortedList);
            }
        }
    }

    private void addSubNodesToPreviousNodeMap(List<AwardHierarchy> sortedList, Map<String, String> previousNodeMap) {
        for (int index = 0; index < sortedList.size() - 1; ++index) {
            String previousNodeNumber = sortedList.get(index).getAwardNumber();
            String nextNodeNumber = sortedList.get(index + 1).getAwardNumber();
            previousNodeMap.put(nextNodeNumber, previousNodeNumber);
        }
    }

    private void addNodesToNextNodeMap(List<AwardHierarchy> sortedList, Map<String, String> nextNodeMap) {
        int index;
        for (index = 0; index < sortedList.size() - 1; ++index) {
            String previousNodeNumber = sortedList.get(index).getAwardNumber();
            String nextNodeNumber = sortedList.get(index + 1).getAwardNumber();
            nextNodeMap.put(previousNodeNumber, nextNodeNumber);
        }
        nextNodeMap.put(sortedList.get(index).getAwardNumber(), "lastNodeNextValue");
    }

    private AwardHierarchyNode getRootNode(Map<String, AwardHierarchyNode> awardHierarchyNodes) {
        AwardHierarchyNode returnValue = null;
        for (String awardNumber : awardHierarchyNodes.keySet()) {
            if (!awardNumber.endsWith("-00001")) continue;
            returnValue = awardHierarchyNodes.get(awardNumber);
        }
        return returnValue;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        return this.awardAmountInfoService;
    }

    public void setAwardAmountInfoService(AwardAmountInfoService awardAmountInfoService) {
        this.awardAmountInfoService = awardAmountInfoService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

