/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewNotificationRenderer;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.notification.AwardNoticeNotificationRenderer;
import org.kuali.kra.award.notification.AwardNotification;
import org.kuali.kra.award.notification.AwardNotificationContext;
import org.kuali.kra.award.notification.AwardNotificationRenderer;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;

public class AwardSpecialReviewAction
extends AwardAction {
    private static final String SAVE_SPECIAL_REVIEW_FIELD = "document.awardList[0].specialReviews";
    private static final String CONFIRM_DELETE_SPECIAL_REVIEW_KEY = "confirmDeleteSpecialReview";
    private static final String SPECIAL_REVIEW_INSERTED_CONTEXT_NAME = "Special Review Inserted";
    private static final String AWARD_IRB_INSERTED_ACTION_CODE = "552";
    private static final String AWARD_IRB_REMOVED_ACTION_CODE = "553";
    private static final String AWARD_EXPORT_CONTROL_ACTION_CODE = "557";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        awardForm.getSpecialReviewHelper().prepareView();
        return forward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        awardForm.getSpecialReviewHelper().getProtocolSaveLocationPrefix(request.getParameterMap()).ifPresent(prefix -> {
            AwardSpecialReview awardSpecialReview = null;
            if (StringUtils.startsWith((CharSequence)prefix, (CharSequence)"specialReviewHelper.newSpecialReview")) {
                awardSpecialReview = (AwardSpecialReview)awardForm.getSpecialReviewHelper().getNewSpecialReview();
            } else {
                int index = awardForm.getSpecialReviewHelper().getProtocolIndex((String)prefix);
                if (index != -1) {
                    awardSpecialReview = awardForm.getAwardDocument().getAward().getSpecialReviews().get(index);
                }
            }
            awardForm.getSpecialReviewHelper().prepareProtocolLinkViewFields(awardSpecialReview);
        });
        return forward;
    }

    public ActionForward addSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument document = awardForm.getAwardDocument();
        AwardSpecialReview specialReview = (AwardSpecialReview)awardForm.getSpecialReviewHelper().getNewSpecialReview();
        List<AwardSpecialReview> specialReviews = document.getAward().getSpecialReviews();
        boolean isProtocolLinkingEnabled = awardForm.getSpecialReviewHelper().getIsExportControlEnabled();
        awardForm.getSpecialReviewHelper().prepareProtocolLinkViewFields(specialReview);
        ActionForward forward = mapping.findForward("basic");
        if (this.applyRules((DocumentEvent)new AddSpecialReviewEvent<AwardSpecialReview>(document, specialReview, specialReviews, isProtocolLinkingEnabled))) {
            String specialReviewTypeCode;
            specialReview.setSpecialReviewNumber(document.getDocumentNextValue("SPECIAL_REVIEW_NUMBER"));
            document.getAward().getSpecialReviews().add(specialReview);
            awardForm.getSpecialReviewHelper().setNewSpecialReview(new AwardSpecialReview());
            if (specialReview.getSpecialReviewType() == null) {
                specialReview.refreshReferenceObject("specialReviewType");
            }
            if (StringUtils.equals((CharSequence)(specialReviewTypeCode = specialReview.getSpecialReviewType().getSpecialReviewTypeCode()), (CharSequence)"1")) {
                SpecialReviewNotificationRenderer renderer = new SpecialReviewNotificationRenderer(new AwardNotificationRenderer(document.getAward()), specialReview);
                AwardNotificationContext context = new AwardNotificationContext(document.getAward(), AWARD_IRB_INSERTED_ACTION_CODE, SPECIAL_REVIEW_INSERTED_CONTEXT_NAME, renderer, "specialReview");
                if (awardForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    awardForm.getNotificationHelper().initializeDefaultValues(context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotificationAndPersist(context, new AwardNotification(), document.getAward());
                }
            } else if (StringUtils.equals((CharSequence)specialReviewTypeCode, (CharSequence)"RESBOOT-1000")) {
                SpecialReviewNotificationRenderer renderer = new SpecialReviewNotificationRenderer(new AwardNoticeNotificationRenderer(0L, document.getAward()), specialReview);
                AwardNotificationContext context = new AwardNotificationContext(document.getAward(), AWARD_EXPORT_CONTROL_ACTION_CODE, SPECIAL_REVIEW_INSERTED_CONTEXT_NAME, renderer, "specialReview");
                if (awardForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    awardForm.getNotificationHelper().initializeDefaultValues(context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotificationAndPersist(context, new AwardNotification(), document.getAward());
                }
            }
        }
        return forward;
    }

    public ActionForward createProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        return new ActionForward(awardForm.getSpecialReviewHelper().getCreateUrl(award.getAwardNumber(), award.getTitle(), CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url") + "/awardSpecialReview.do?docId=" + awardForm.getAwardDocument().getDocumentNumber() + "&methodToCall=docHandler&command=displayDocSearchView&viewDocument=false"), true);
    }

    public ActionForward deleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "question.special.review.delete.confirmation", new String[0]), CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "");
    }

    public ActionForward confirmDeleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_SPECIAL_REVIEW_KEY.equals(question)) {
            AwardForm awardForm = (AwardForm)form;
            AwardDocument document = awardForm.getAwardDocument();
            AwardSpecialReview specialReview = document.getAward().getSpecialReviews().get(this.getLineToDelete(request));
            document.getAward().getSpecialReviews().remove(specialReview);
            if (specialReview.getSpecialReviewType() == null) {
                specialReview.refreshReferenceObject("specialReviewType");
            }
            if (StringUtils.equals((CharSequence)specialReview.getSpecialReviewType().getSpecialReviewTypeCode(), (CharSequence)"1")) {
                SpecialReviewNotificationRenderer renderer = new SpecialReviewNotificationRenderer(new AwardNotificationRenderer(document.getAward()), specialReview);
                AwardNotificationContext context = new AwardNotificationContext(document.getAward(), AWARD_IRB_REMOVED_ACTION_CODE, "Special Review Deleted", renderer, "specialReview");
                if (awardForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    awardForm.getNotificationHelper().initializeDefaultValues(context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotificationAndPersist(context, new AwardNotification(), document.getAward());
                }
            }
        }
        return forward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        AwardForm awardForm = (AwardForm)form;
        AwardDocument document = awardForm.getAwardDocument();
        Award award = document.getAward();
        List<AwardSpecialReview> specialReviews = award.getSpecialReviews();
        boolean isExconProtocolLinkingEnabled = awardForm.getSpecialReviewHelper().getIsExportControlEnabled();
        if (award.getSpecialReviews() == null || award.getSpecialReviews().isEmpty()) {
            award.setSpecialReviewIndicator("N");
        } else {
            award.setSpecialReviewIndicator("Y");
        }
        awardForm.getSpecialReviewHelper().syncProtocolLinkViews();
        if (this.applyRules((DocumentEvent)new SaveSpecialReviewEvent<AwardSpecialReview>(SAVE_SPECIAL_REVIEW_FIELD, document, specialReviews, isExconProtocolLinkingEnabled))) {
            List deletedReviews = award.getAwardId() != null ? this.getDeletedSpecialReviews(((Award)this.getBusinessObjectService().findBySinglePrimaryKey(Award.class, (Object)award.getAwardId())).getSpecialReviews(), award.getSpecialReviews()) : Collections.emptyList();
            forward = super.save(mapping, form, request, response);
            awardForm.getSpecialReviewHelper().syncProtocolReferences(specialReviews, award.getAwardNumber(), award.getTitle(), deletedReviews);
        }
        return forward;
    }

    private List<AwardSpecialReview> getDeletedSpecialReviews(List<AwardSpecialReview> previousReviews, List<AwardSpecialReview> currentReviews) {
        return previousReviews.stream().filter(psr -> !currentReviews.contains(psr)).collect(Collectors.toList());
    }

    public ActionForward viewSpecialReviewProtocolLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewProtocolUrl = "";
        AwardForm awardForm = (AwardForm)form;
        String lineNumber = request.getParameter("line");
        if (NumberUtils.isCreatable((String)lineNumber)) {
            int index = Integer.parseInt(lineNumber);
            AwardSpecialReview awardSpecialReview = awardForm.getAwardDocument().getAward().getSpecialReviews().get(index);
            viewProtocolUrl = awardForm.getSpecialReviewHelper().getForwardUrl(awardSpecialReview).orElse("");
        }
        return new ActionForward(viewProtocolUrl, true);
    }
}

