## ${resourceName} [${endpoint}]

### Get ${resourceName} by Key [GET ${endpoint}${sampleKey}]
	 
+ Request

    + Headers

            Authorization: Bearer {api-key}
            Content-Type: application/json

+ Response 200
    + Headers

            Content-Type: application/json;charset=UTF-8

    + Body
    
            ${sampleResource1}

### Get All ${resourceName} [GET ${endpoint}]

+ Parameters
    + _startIndex (optional) - The integer index to use for paging.  Zero based.  If not present, defaults to 0.  Cannot be less than 0. 
    + _limit (optional) - The integer number of records to fetch.  If not present, defaults to a system defined value.  Cannot be greater than the system defined value. 
	 
+ Request

    + Headers

            Authorization: Bearer {api-key}
            Content-Type: application/json

+ Response 200
    + Headers

            Content-Type: application/json;charset=UTF-8
            X-Kuali-Paging-Start-Index: startIndex - The integer index used for paging.
            X-Kuali-Paging-Limit: limit - The integer number of records used to fetch either imposed by the system or as requested
            X-Kuali-Paging-Total: total - The integer number of records in total
    + Body
    
            [
              ${sampleResource1},
              ${sampleResource2}
            ]

### Get All ${resourceName} with Filtering [GET ${endpoint}]
    
+ Parameters
    + _startIndex (optional) - The integer index to use for paging.  Zero based.  If not present, defaults to 0.  Cannot be less than 0. 
    + _limit (optional) - The integer number of records to fetch.  If not present, defaults to a system defined value.  Cannot be greater than the system defined value.
    ${sampleMatchCriteria}
            
+ Request

    + Headers

            Authorization: Bearer {api-key}
            Content-Type: application/json 

+ Response 200
    + Headers

            Content-Type: application/json;charset=UTF-8
                        X-Kuali-Paging-Start-Index: startIndex - The integer index used for paging.
                        X-Kuali-Paging-Limit: limit - The integer number of records used to fetch either imposed by the system or as requested
                        X-Kuali-Paging-Total: total - The integer number of records in total

    + Body
    
            [
              ${sampleResource1},
              ${sampleResource2}
            ]
			
### Get Schema for ${resourceName} [GET ${endpoint}]
	                                          
+ Parameters

      + _schema (required) - will instruct the endpoint to return a schema data structure for the resource
      
+ Request

    + Headers

            Authorization: Bearer {api-key}
            Content-Type: application/json

+ Response 200
    + Headers

            Content-Type: application/json;charset=UTF-8

    + Body
    
            ${sampleSchema}
		
### Get Blueprint API specification for ${resourceName} [GET ${endpoint}]
	 
+ Parameters

     + _blueprint (required) - will instruct the endpoint to return an api blueprint markdown file for the resource
                 
+ Request

    + Headers

            Authorization: Bearer {api-key}
            Content-Type: text/markdown

+ Response 200
    + Headers

            Content-Type: text/markdown;charset=UTF-8
            Content-Disposition:attachment; filename="${resourceName}.md"
            transfer-encoding:chunked
