/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleBase;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

@KcBusinessRule(value="activityTypeAuditRule")
public class ActivityTypeAuditRule
extends BudgetAuditRuleBase {
    @KcEventMethod
    public boolean processRunAuditBusinessRules(BudgetAuditEvent event) {
        boolean valid = true;
        Budget budget = event.getBudget();
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        if (this.isActivityTypeChanged(budget)) {
            if (budget.getBudgetParent().getDocument() instanceof AwardDocument) {
                auditErrors.add(new AuditError("document.developmentProposalList[0].activityTypeCode".replace("developmentProposalList", "awardList"), "warning.activityType.changed", "home.detailsDate"));
            } else {
                auditErrors.add(new AuditError("document.developmentProposalList[0].activityTypeCode", "warning.activityType.changed", "proposal.RequiredFieldsforSavingDocument"));
            }
            this.getGlobalVariableService().getAuditErrorMap().put("activityTypeAuditWarnings", new AuditCluster("Activity type changed", auditErrors, "Warnings"));
            valid = false;
        }
        return valid;
    }

    @KcEventMethod
    public boolean processRunAuditBusinessRules(BudgetAuditRuleEvent event) {
        Budget budget = event.getBudget();
        if (this.isActivityTypeChanged(budget)) {
            BudgetConstants.BudgetAuditRules budgetActivityRule = BudgetConstants.BudgetAuditRules.ACTIVITY_TYPE;
            List<AuditError> auditErrors = this.getAuditErrors(budgetActivityRule, false);
            auditErrors.add(new AuditError("document.developmentProposalList[0].activityTypeCode", "warning.activityType.changed", budgetActivityRule.getPageId()));
            return false;
        }
        return true;
    }

    private boolean isActivityTypeChanged(Budget budget) {
        BudgetParentDocument<? extends BudgetParent> parentDocument = budget.getBudgetParent().getDocument();
        boolean syncRate = false;
        Collection<BudgetRate> allBudgetRates = this.getBudgetRatesService().getSavedBudgetRates(budget);
        syncRate = this.getBudgetRatesService().checkActivityTypeChange(allBudgetRates, parentDocument.getBudgetParent().getActivityTypeCode());
        return syncRate;
    }

    private BudgetRatesService getBudgetRatesService() {
        return KcServiceLocator.getService(BudgetRatesService.class);
    }
}

