/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.pdf.forms;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.pdf.forms.PdfFormsService;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class PdfFormsFinder
extends FormViewAwareUifKeyValuesFinderBase {
    private transient PdfFormsService pdfFormsService;
    private String moduleCode;

    public List<KeyValue> getKeyValues() {
        if (StringUtils.isBlank((CharSequence)this.moduleCode)) {
            return Collections.emptyList();
        }
        return this.getPdfFormsService().activeByModuleCode(this.moduleCode).stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getMappingFileId())).filter(f -> StringUtils.isNotBlank((CharSequence)f.getPdfFormFileId())).map(s -> new ConcreteKeyValue(s.getId(), s.getDescription())).collect(Collectors.toList());
    }

    public String getModuleCode() {
        return this.moduleCode;
    }

    public void setModuleCode(String moduleCode) {
        this.moduleCode = moduleCode;
    }

    public PdfFormsService getPdfFormsService() {
        if (this.pdfFormsService == null) {
            this.pdfFormsService = KcServiceLocator.getService(PdfFormsService.class);
        }
        return this.pdfFormsService;
    }
}

