/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.controller;

import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.controller.KcCommonControllerService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.HistoryManager;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

@Component(value="kcCommonControllerService")
public class KcCommonControllerServiceImpl
implements KcCommonControllerService {
    public static final String APPLICATION_URL_CONFIG_PARAM = "application.url";
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="modelAndViewService")
    private ModelAndViewService modelAndViewService;
    private static final String CLOSE_DIALOG_JS_FN = "dismissDialog";

    @Override
    public UifFormBase initForm(UifFormBase requestForm, HttpServletRequest request, HttpServletResponse response) {
        String requestedFormKey;
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        if (uifFormManager == null) {
            uifFormManager = new UifFormManager();
            request.getSession().setAttribute("formManager", (Object)uifFormManager);
        }
        this.globalVariableService.setUifFormManager(uifFormManager);
        String formKeyParam = request.getParameter("formKey");
        if (StringUtils.isNotBlank((CharSequence)formKeyParam)) {
            uifFormManager.updateFormWithSession(requestForm, formKeyParam);
        }
        if (StringUtils.isNotBlank((CharSequence)(requestedFormKey = request.getParameter("requestedFormKey")))) {
            requestForm.setRequestedFormKey(requestedFormKey);
        } else {
            requestForm.setRequestedFormKey(formKeyParam);
        }
        String referer = request.getHeader("Referer");
        if (StringUtils.isBlank((CharSequence)referer) && StringUtils.isBlank((CharSequence)requestForm.getReturnLocation())) {
            requestForm.setReturnLocation("");
        } else if (StringUtils.isBlank((CharSequence)requestForm.getReturnLocation())) {
            requestForm.setReturnLocation(referer);
        }
        if (requestForm.getInitialRequestParameters() == null) {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            Enumeration names = request.getParameterNames();
            while (names != null && names.hasMoreElements()) {
                String name = KRADUtils.stripXSSPatterns((String)((String)names.nextElement()));
                String value = KRADUtils.stripXSSPatterns((String)request.getParameter(name));
                requestParams.put(name, value);
            }
            requestParams.remove("__login_user");
        }
        String requestUrl = KRADUtils.stripXSSPatterns((String)KRADUtils.getFullURL((HttpServletRequest)request));
        requestForm.setRequestUrl(requestUrl);
        Object historyManager = request.getSession().getAttribute("historyManager");
        String flowKey = request.getParameter("flow");
        if (requestForm != null && historyManager != null && historyManager instanceof HistoryManager) {
            requestForm.setHistoryManager((HistoryManager)historyManager);
            requestForm.setFlowKey(flowKey);
        }
        request.setAttribute("requestForm", (Object)requestForm);
        return requestForm;
    }

    @Override
    public ModelAndView closeDialog(String dialogId, UifFormBase form) {
        ModelAndView modelAndView = this.getModelAndViewService().getModelAndView(form);
        this.getModelAndViewService().prepareView(form.getRequest(), modelAndView);
        Object updateComponent = form.isAjaxRequest() ? form.getUpdateComponent() : form.getView();
        String onReadyScript = ScriptUtils.appendScript((String)updateComponent.getOnDocumentReadyScript(), (String)this.getCloseDialogScript(dialogId));
        updateComponent.setOnDocumentReadyScript(onReadyScript);
        form.getRequest().setAttribute("ViewLifecycleComplete", (Object)"true");
        return modelAndView;
    }

    protected String getCloseDialogScript(String dialogId) {
        StringBuilder closeDialogScript = new StringBuilder();
        closeDialogScript.append(CLOSE_DIALOG_JS_FN);
        closeDialogScript.append("('");
        closeDialogScript.append(dialogId);
        closeDialogScript.append("');");
        return closeDialogScript.toString();
    }

    @Override
    public ModelAndView returnHome(UifFormBase form) {
        String applicationUrl = this.getConfigurationService().getPropertyValueAsString(APPLICATION_URL_CONFIG_PARAM);
        return this.getModelAndViewService().performRedirect(form, applicationUrl);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }
}

