/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.krad;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.impl.custom.arg.ArgValueLookupValuesFinder;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionMultiChoice;
import org.kuali.coeus.org.kuali.rice.krad.uif.control.QuestionCheckboxControl;
import org.kuali.coeus.org.kuali.rice.krad.uif.control.QuestionRadioGroupControl;
import org.kuali.kra.web.krad.KcBindingInfo;
import org.kuali.rice.krad.datadictionary.validation.constraint.FloatingPointPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.NumericPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.control.TextControlBase;
import org.kuali.rice.krad.uif.field.InputFieldBase;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.UifKeyValue;

public class QuestionField
extends InputFieldBase {
    private static final long serialVersionUID = -940684402907403282L;
    private static final Integer DEFAULT_MAX_LENGTH = 4000;
    private Map<String, String> controlMappings = new HashMap<String, String>();
    private boolean useSuggest;

    public void performApplyModel(Object model, LifecycleElement parent) {
        Integer maxLength;
        Object myBo = ObjectPropertyUtils.getPropertyValue((Object)model, (String)KcBindingInfo.getParentBindingInfo(this.getBindingInfo()));
        Answer answer = (Answer)myBo;
        if (!answer.getQuestion().getQuestionTypeId().equals(100L)) {
            if (answer.getQuestion().getQuestionTypeId().equals(5L) && answer.getQuestion().getAnswerMaxLength() > 300) {
                this.setControl((Control)ComponentFactory.getNewComponentInstance((String)"Uif-TextAreaControl"));
            } else {
                this.setControl((Control)ComponentFactory.getNewComponentInstance((String)this.getControlMappings().get(answer.getQuestion().getQuestionTypeId().toString())));
            }
        } else {
            this.setupMultipleChoiceControl(answer);
        }
        this.getControl().getCssClasses().add("answer");
        Integer answerMaxLength = answer.getQuestion().getAnswerMaxLength();
        Integer n = maxLength = answerMaxLength == null || answerMaxLength == 0 ? DEFAULT_MAX_LENGTH : answerMaxLength;
        if (this.getControl() instanceof TextControlBase && !answer.getQuestion().getQuestionTypeId().equals(4L)) {
            ((TextControlBase)this.getControl()).setMaxLength(maxLength);
        }
        if (this.getControl() instanceof TextAreaControl) {
            ((TextAreaControl)this.getControl()).setMaxLength(maxLength);
        }
        if (answer.getQuestion().getQuestionTypeId().equals(3L)) {
            this.setValidCharactersConstraint((ValidCharactersConstraint)new NumericPatternConstraint());
        } else if (answer.getQuestion().getQuestionTypeId().equals(7L)) {
            FloatingPointPatternConstraint constraint = new FloatingPointPatternConstraint();
            constraint.setAllowNegative(true);
            constraint.setPatternTypeKey("validationPatternRegex.floatingPoint");
            constraint.setMessageKey("validation.floatingPoint");
            this.setValidCharactersConstraint((ValidCharactersConstraint)constraint);
        }
        if (answer.getQuestion().getQuestionTypeId().equals(6L) && answer.getQuestion().getLookupClass().equals(ArgValueLookup.class.getName())) {
            Control dropdownControl = (Control)ComponentFactory.getNewComponentInstance((String)"Uif-DropdownControl");
            dropdownControl.getCssClasses().add("answer");
            this.setControl(dropdownControl);
            ArgValueLookupValuesFinder valuesFinder = new ArgValueLookupValuesFinder();
            valuesFinder.setArgName(answer.getQuestion().getLookupReturn());
            valuesFinder.setAddBlankOption(false);
            valuesFinder.setCurrentValue(answer.getAnswer());
            this.setOptionsFinder((KeyValuesFinder)valuesFinder);
            this.getInquiry().setRender(true);
        } else if (StringUtils.isNotBlank((CharSequence)answer.getQuestion().getLookupClass())) {
            ((TextControlBase)this.getControl()).setMaxLength(null);
            this.getControl().getAdditionalCssClasses().add("questionnaire-widgetInputOnly");
            this.setOnDocumentReadyScript("Kc.Questionnaire.Answer.setWidgetInputOnly()");
            if (this.useSuggest) {
                this.getSuggest().setRender(true);
                this.getSuggest().setValuePropertyName(answer.getQuestion().getLookupReturn());
                this.getSuggest().getSuggestQuery().setDataObjectClassName(answer.getQuestion().getLookupClass());
            }
            this.getQuickfinder().setRender(true);
            this.getQuickfinder().setReturnByScript(true);
            this.getQuickfinder().setDataObjectClassName(answer.getQuestion().getLookupClass());
            this.getQuickfinder().getFieldConversions().put(answer.getQuestion().getLookupReturn(), this.getPropertyName());
            if (answer.getQuestion().getLookupClass().equals(Rolodex.class.getName())) {
                this.getQuickfinder().setViewName("Rolodex-LookupView-AddButton");
            }
        }
        super.performApplyModel(model, parent);
    }

    protected void setupMultipleChoiceControl(Answer answer) {
        if (answer.getQuestion().isRadioButton()) {
            this.setupRadioGroupControl(answer);
        } else {
            this.setupCheckboxControl(answer);
        }
    }

    private void setupCheckboxControl(Answer answer) {
        QuestionCheckboxControl checkboxControl = (QuestionCheckboxControl)ComponentFactory.getNewComponentInstance((String)"Uif-QuestionCheckboxControl");
        List<QuestionMultiChoice> multiChoices = answer.getQuestion().getQuestionMultiChoices();
        if (multiChoices != null && multiChoices.size() >= answer.getAnswerNumber()) {
            QuestionMultiChoice associatedChoice = multiChoices.get(answer.getAnswerNumber() - 1);
            String associatedPrompt = associatedChoice.getPrompt();
            boolean isChecked = StringUtils.equals((CharSequence)associatedPrompt, (CharSequence)answer.getAnswer());
            checkboxControl.setCheckboxLabel(associatedPrompt);
            checkboxControl.setValue(associatedPrompt);
            checkboxControl.setChecked(isChecked);
            String associatedDescription = associatedChoice.getDescription();
            if (StringUtils.isNotBlank((CharSequence)associatedDescription)) {
                checkboxControl.setDescription(associatedDescription);
            }
        }
        this.setControl((Control)checkboxControl);
    }

    private void setupRadioGroupControl(Answer answer) {
        QuestionRadioGroupControl radioControl = (QuestionRadioGroupControl)ComponentFactory.getNewComponentInstance((String)"Uif-QuestionRadioControl");
        ArrayList<UifKeyValue> radioOptions = new ArrayList<UifKeyValue>();
        ArrayList<String> radioDescriptions = new ArrayList<String>();
        for (int i = 0; i < answer.getQuestion().getQuestionMultiChoices().size(); ++i) {
            QuestionMultiChoice choice = answer.getQuestion().getQuestionMultiChoices().get(i);
            String mcPrompt = choice.getPrompt();
            radioOptions.add(new UifKeyValue(mcPrompt, mcPrompt));
            radioDescriptions.add(StringUtils.isBlank((CharSequence)choice.getDescription()) ? null : choice.getDescription());
        }
        radioControl.setOptions(radioOptions);
        radioControl.setOptionDescriptions(radioDescriptions);
        this.setControl((Control)radioControl);
    }

    public QuestionField copy() {
        QuestionField copy = (QuestionField)((Object)super.copy());
        copy.setControlMappings(new HashMap<String, String>(this.controlMappings));
        copy.setUseSuggest(this.useSuggest);
        return copy;
    }

    public Map<String, String> getControlMappings() {
        return this.controlMappings;
    }

    public void setControlMappings(Map<String, String> controlMappings) {
        this.controlMappings = controlMappings;
    }

    public boolean isUseSuggest() {
        return this.useSuggest;
    }

    public void setUseSuggest(boolean useSuggest) {
        this.useSuggest = useSuggest;
    }
}

