/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.rate;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.calculator.ValidCalcType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.And;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.query.operator.GreaterThan;
import org.kuali.coeus.common.budget.framework.query.operator.LesserThan;
import org.kuali.coeus.common.budget.framework.query.operator.Or;
import org.kuali.coeus.common.budget.framework.rate.AbstractBudgetRate;
import org.kuali.coeus.common.budget.framework.rate.AbstractInstituteRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetLaRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.rate.InstituteLaRate;
import org.kuali.coeus.common.budget.framework.rate.InstituteRate;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.common.budget.framework.rate.RateClassType;
import org.kuali.coeus.common.budget.impl.rate.UnitFormulatedCost;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.coeus.common.framework.type.ActivityType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BudgetRatesServiceImpl
implements BudgetRatesService {
    private static final String SPACE = " ";
    static final String UNIT_NUMBER_KEY = "unitNumber";
    static final String ACTIVITY_TYPE_CODE_KEY = "activityTypeCode";
    private static final String PERIOD_SEARCH_SEPARATOR = "|";
    private static final String PERIOD_DISPLAY_SEPARATOR = ",";
    private static final String RATE_CLASS_TYPE = "rateClassType";
    private static final String DEPENDENT_RATE_CLASS_TYPE = "dependentRateClassType";
    private static final Logger LOG = LogManager.getLogger(BudgetRatesServiceImpl.class);
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="fiscalYearMonthService")
    private FiscalYearMonthService fiscalYearMonthService;
    @Autowired
    @Qualifier(value="kcEntityManager")
    private EntityManager entityManager;

    @Override
    public void resetAllBudgetRates(Budget budget) {
        this.resetAbstractBudgetApplicableRatesToInstituteRates(budget.getBudgetRates());
        this.resetAbstractBudgetApplicableRatesToInstituteRates(budget.getBudgetLaRates());
    }

    @Override
    public void resetBudgetRatesForRateClassType(String rateClassType, Budget budget) {
        List<RateClass> rateClasses = budget.getRateClasses();
        this.resetBudgetRatesForRateClassType(rateClasses, rateClassType, budget.getBudgetRates());
        this.resetBudgetRatesForRateClassType(rateClasses, rateClassType, budget.getBudgetLaRates());
    }

    @Override
    public void syncAllBudgetRates(Budget budget) {
        ArrayList<InstituteRate> allInstituteRates = new ArrayList<InstituteRate>(this.getInstituteRates(budget));
        ArrayList<InstituteLaRate> allInstituteLaRates = new ArrayList<InstituteLaRate>(this.getInstituteLaRates(budget));
        if (this.isOutOfSync(budget)) {
            Map<String, AbstractInstituteRate> mapOfExistingBudgetProposalRates = this.mapRatesToKeys(budget.getBudgetRates());
            Map<String, AbstractInstituteRate> mapOfExistingBudgetProposalLaRates = this.mapRatesToKeys(budget.getBudgetLaRates());
            budget.getBudgetRates().clear();
            budget.getBudgetLaRates().clear();
            budget.getRateClasses().clear();
            budget.getBudgetUnrecoveredFandAs().clear();
            this.getBudgetRates(budget, allInstituteRates);
            this.getBudgetLaRates(budget, allInstituteLaRates);
            this.syncVersionNumber(mapOfExistingBudgetProposalRates, budget.getBudgetRates());
            this.syncVersionNumber(mapOfExistingBudgetProposalLaRates, budget.getBudgetLaRates());
        } else {
            this.syncBudgetRates(budget.getBudgetRates(), allInstituteRates);
            this.syncBudgetRates(budget.getBudgetLaRates(), allInstituteLaRates);
        }
    }

    protected void syncVersionNumber(Map<String, AbstractInstituteRate> oldRateMap, List rates) {
        List abstractBudgetRates = rates;
        for (AbstractBudgetRate budgetRate : abstractBudgetRates) {
            AbstractInstituteRate oldRate = oldRateMap.get(budgetRate.getRateKeyAsString());
            if (oldRate == null) continue;
            budgetRate.setVersionNumber(oldRate.getVersionNumber());
        }
    }

    @Override
    public void viewLocation(String viewLocation, Integer budgetPeriod, Budget budget) {
        this.viewLocation(viewLocation, budgetPeriod, budget.getBudgetRates());
        this.viewLocation(viewLocation, budgetPeriod, budget.getBudgetLaRates());
    }

    @Override
    public void syncParentDocumentRates(Budget budget) {
    }

    @Override
    public void syncBudgetRatesForRateClassType(String rateClassType, Budget budget) {
        this.populateInstituteRates(budget);
        Map<String, AbstractInstituteRate> mapOfExistingBudgetProposalRates = this.mapRatesToKeys(budget.getBudgetRates());
        Map<String, AbstractInstituteRate> mapOfExistingBudgetProposalLaRates = this.mapRatesToKeys(budget.getBudgetLaRates());
        this.replaceRateClassesForRateClassType(rateClassType, budget, budget.getInstituteRates());
        this.replaceRateClassesForRateClassType(rateClassType, budget, budget.getInstituteLaRates());
        this.replaceBudgetRatesForRateClassType(rateClassType, budget, budget.getBudgetRates(), budget.getInstituteRates());
        this.replaceBudgetRatesForRateClassType(rateClassType, budget, budget.getBudgetLaRates(), budget.getInstituteLaRates());
        this.syncVersionNumber(mapOfExistingBudgetProposalRates, budget.getBudgetRates());
        this.syncVersionNumber(mapOfExistingBudgetProposalLaRates, budget.getBudgetLaRates());
    }

    @Override
    public void getBudgetRates(List<RateClassType> rateClassTypes, Budget budget) {
        this.getBudgetRates(rateClassTypes, budget, this.getInstituteRates(budget));
    }

    protected void checkActivityPrefixForRateClassTypes(List<RateClassType> rateClassTypes, Budget budget) {
        String activityTypeDescription = this.getActivityTypeDescription(budget);
        List<BudgetRate> budgetRates = budget.getBudgetRates();
        List<BudgetLaRate> budgetLaRates = budget.getBudgetLaRates();
        for (RateClassType rateClassType : rateClassTypes) {
            if (!rateClassType.getPrefixActivityType().booleanValue()) continue;
            this.entityManager.detach((Object)rateClassType);
            String newRateClassTypeDescription = activityTypeDescription.concat(rateClassType.getDescription());
            rateClassType.setDescription(newRateClassTypeDescription);
            rateClassType.setPrefixActivityType(false);
            for (BudgetRate budgetRate : budgetRates) {
                RateClassType BPRateClassType = budgetRate.getRateClass().getRateClassType();
                if (!rateClassType.getCode().equalsIgnoreCase(BPRateClassType.getCode())) continue;
                BPRateClassType.setDescription(newRateClassTypeDescription);
            }
            for (BudgetLaRate budgetLaRate : budgetLaRates) {
                RateClassType BPLRateClassType = budgetLaRate.getRateClass().getRateClassType();
                if (!rateClassType.getCode().equalsIgnoreCase(BPLRateClassType.getCode())) continue;
                BPLRateClassType.setDescription(newRateClassTypeDescription);
            }
        }
    }

    protected String getActivityTypeDescription(Budget budget) {
        BudgetParent budgetParent = budget.getBudgetParent();
        if (budget.isRateSynced() || !this.checkActivityTypeChange(budget)) {
            if (budgetParent.getActivityType() != null) {
                return budgetParent.getActivityType().getDescription().concat(SPACE);
            }
            return "";
        }
        String activityTypeCode = null;
        if (CollectionUtils.isNotEmpty(budget.getBudgetRates())) {
            activityTypeCode = budget.getBudgetRates().get(0).getActivityTypeCode();
        }
        if (activityTypeCode != null) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("code", activityTypeCode);
            ActivityType activityType = (ActivityType)this.getBusinessObjectService().findByPrimaryKey(ActivityType.class, pkMap);
            if (activityType == null) {
                return "";
            }
            return activityType.getDescription().concat(SPACE);
        }
        return "";
    }

    protected void updateRatesForEachPeriod(Budget budget) {
        List<BudgetRate> budgetRates = budget.getBudgetRates();
        List<BudgetLaRate> budgetLaRates = budget.getBudgetLaRates();
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            String currBudgetPeriod;
            String formattedPeriod;
            String dispBudgetPeriod;
            for (BudgetRate budgetRate : budgetRates) {
                if (budgetRate.getStartDate().compareTo(budgetPeriod.getEndDate()) > 0) continue;
                dispBudgetPeriod = budgetPeriod.getBudgetPeriod().toString();
                formattedPeriod = dispBudgetPeriod.concat(PERIOD_SEARCH_SEPARATOR);
                currBudgetPeriod = budgetRate.getTrackAffectedPeriod();
                if (currBudgetPeriod == null) {
                    currBudgetPeriod = PERIOD_SEARCH_SEPARATOR.concat(formattedPeriod);
                    budgetRate.setTrackAffectedPeriod(currBudgetPeriod);
                } else if (!currBudgetPeriod.contains(formattedPeriod)) {
                    currBudgetPeriod = currBudgetPeriod.concat(formattedPeriod);
                    budgetRate.setTrackAffectedPeriod(currBudgetPeriod);
                }
                budgetRate.setAffectedBudgetPeriod(this.getFormattedAffectedBudgetPeriod(currBudgetPeriod));
            }
            for (BudgetLaRate budgetLaRate : budgetLaRates) {
                if (budgetLaRate.getStartDate().compareTo(budgetPeriod.getEndDate()) > 0) continue;
                dispBudgetPeriod = budgetPeriod.getBudgetPeriod().toString();
                formattedPeriod = dispBudgetPeriod.concat(PERIOD_SEARCH_SEPARATOR);
                currBudgetPeriod = budgetLaRate.getTrackAffectedPeriod();
                if (currBudgetPeriod == null) {
                    currBudgetPeriod = PERIOD_SEARCH_SEPARATOR.concat(formattedPeriod);
                    budgetLaRate.setTrackAffectedPeriod(currBudgetPeriod);
                } else if (!currBudgetPeriod.contains(formattedPeriod)) {
                    currBudgetPeriod = currBudgetPeriod.concat(formattedPeriod);
                    budgetLaRate.setTrackAffectedPeriod(currBudgetPeriod);
                }
                budgetLaRate.setAffectedBudgetPeriod(this.getFormattedAffectedBudgetPeriod(currBudgetPeriod));
            }
        }
    }

    protected Map<String, AbstractInstituteRate> mapRatesToKeys(Collection rates) {
        Collection abstractInstituteRates = rates;
        HashMap<String, AbstractInstituteRate> rateMap = new HashMap<String, AbstractInstituteRate>();
        for (AbstractInstituteRate abstractInstituteRate : abstractInstituteRates) {
            rateMap.put(abstractInstituteRate.getRateKeyAsString(), abstractInstituteRate);
        }
        return rateMap;
    }

    protected Collection<InstituteRate> getInstituteRates(Budget budget) {
        Unit firstUnit = this.findFirstUnitWithRates(budget.getBudgetParent().getUnit(), InstituteRate.class);
        if (firstUnit == null) {
            return new ArrayList<InstituteRate>();
        }
        Collection<AbstractInstituteRate> abstractRates = this.getActiveInstituteRates(InstituteRate.class, firstUnit, budget.getBudgetParent().getActivityTypeCode());
        return abstractRates;
    }

    protected Unit findFirstUnitWithRates(Unit leadUnit, Class rateType) {
        Unit currentUnit;
        HashMap<String, String> currentSearchMap = new HashMap<String, String>();
        for (currentUnit = leadUnit; currentUnit != null; currentUnit = currentUnit.getParentUnit()) {
            currentSearchMap.put(UNIT_NUMBER_KEY, currentUnit.getUnitNumber());
            Collection currentRates = this.filterForActiveRatesOnly(this.getBusinessObjectService().findMatching(rateType, currentSearchMap));
            if (currentRates != null && !currentRates.isEmpty()) break;
        }
        return currentUnit;
    }

    protected Collection<AbstractInstituteRate> getActiveInstituteRates(Class rateType, Unit unit, String activityTypeCode) {
        HashMap<String, String> searchMap = new HashMap<String, String>();
        searchMap.put(UNIT_NUMBER_KEY, unit.getUnitNumber());
        searchMap.put(ACTIVITY_TYPE_CODE_KEY, activityTypeCode);
        return this.filterForActiveRatesOnly(this.getBusinessObjectService().findMatching(rateType, searchMap));
    }

    protected Collection<InstituteLaRate> getInstituteLaRates(Budget budget) {
        Collection abstractInstituteRates = this.getFilteredInstituteLaRates(InstituteLaRate.class, this.getRateFilterMap(budget));
        abstractInstituteRates = abstractInstituteRates.size() > 0 ? abstractInstituteRates : new ArrayList();
        return abstractInstituteRates;
    }

    protected Map<String, String> getRateFilterMap(Budget budget) {
        BudgetParent budgetParent = budget.getBudgetParent();
        HashMap<String, String> rateFilterMap = new HashMap<String, String>();
        rateFilterMap.put(UNIT_NUMBER_KEY, budgetParent.getUnitNumber());
        return rateFilterMap;
    }

    protected Collection getFilteredInstituteLaRates(Class rateType, Map<String, String> rateFilterMap) {
        Collection abstractInstituteRates = this.filterForActiveRatesOnly(this.getBusinessObjectService().findMatching(rateType, rateFilterMap));
        return abstractInstituteRates;
    }

    protected Collection filterForActiveRatesOnly(Collection abstractInstituteRates) {
        ArrayList<AbstractInstituteRate> filteredList = new ArrayList<AbstractInstituteRate>();
        for (AbstractInstituteRate rate : abstractInstituteRates) {
            if (rate.isActive()) {
                filteredList.add(rate);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Filtering inactive rate: " + rate.getObjectId());
        }
        return filteredList;
    }

    protected Date getRateEffectiveStartDate(Budget budget, AbstractInstituteRate rate, Date personEffectiveDate) {
        java.util.Date effectiveDate = budget.getStartDate();
        if (rate.getRateClass().getRateClassTypeCode().equalsIgnoreCase("I") && personEffectiveDate != null && personEffectiveDate.compareTo(effectiveDate) < 0) {
            effectiveDate = personEffectiveDate;
        }
        return effectiveDate;
    }

    @Override
    public Date getBudgetPersonSalaryEffectiveDate(Budget budget) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("budgetId", budget.getBudgetId());
        List budgetPersons = this.getBusinessObjectService().findMatching(BudgetPerson.class, queryMap);
        Date effectiveDate = null;
        for (BudgetPerson budgetPerson : budgetPersons) {
            if (effectiveDate != null && budgetPerson.getEffectiveDate().compareTo(effectiveDate) >= 0) continue;
            effectiveDate = budgetPerson.getEffectiveDate();
        }
        return effectiveDate;
    }

    protected void filterInstituteRatesBasedOnSalaryEffectiveDate(Budget budget, Collection<AbstractInstituteRate> allRates, Collection<AbstractInstituteRate> filteredRates, Date personSalaryEffectiveDate) {
        ArrayList<String> addedList = new ArrayList<String>();
        QueryList<AbstractInstituteRate> instituteRates = new QueryList<AbstractInstituteRate>(allRates);
        for (AbstractInstituteRate instituteRate : allRates) {
            String hKey = this.generateThreePartKey(instituteRate);
            if (addedList.contains(hKey)) continue;
            addedList.add(hKey);
            Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)instituteRate.getRateClassCode()));
            Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)instituteRate.getRateTypeCode()));
            Equals eqCampusFlag = new Equals("onOffCampusFlag", instituteRate.getOnOffCampusFlag());
            And rateClassAndRateType = new And(eqRateClassCode, eqRateTypeCode);
            And rcRtCampus = new And(rateClassAndRateType, eqCampusFlag);
            QueryList<AbstractInstituteRate> tempFilteredRates = instituteRates.filter(rcRtCampus);
            Date effectiveStartDate = this.getRateEffectiveStartDate(budget, instituteRate, personSalaryEffectiveDate);
            Equals eqEndDate = new Equals("startDate", budget.getEndDate());
            LesserThan ltEndDate = new LesserThan("startDate", budget.getEndDate());
            Or ltEqEndDate = new Or(eqEndDate, ltEndDate);
            tempFilteredRates = tempFilteredRates.filter(ltEqEndDate);
            GreaterThan gtStartDate = new GreaterThan("startDate", effectiveStartDate);
            QueryList<AbstractInstituteRate> rateWithinProjectPeriod = tempFilteredRates.filter(gtStartDate);
            filteredRates.addAll(rateWithinProjectPeriod);
            tempFilteredRates.removeAll(rateWithinProjectPeriod);
            if (tempFilteredRates.isEmpty()) continue;
            tempFilteredRates.sort("startDate", false);
            filteredRates.add(tempFilteredRates.get(0));
        }
    }

    protected String generateThreePartKey(AbstractInstituteRate instituteRate) {
        return instituteRate.getRateClassCode() + instituteRate.getRateTypeCode() + this.getLocationFlagAsString(instituteRate.getOnOffCampusFlag());
    }

    protected void filterRates(Budget budget, Collection allAbstractInstituteRates, Collection filteredAbstractInstituteRates) {
        filteredAbstractInstituteRates.clear();
        Date personSalaryEffectiveDate = this.getBudgetPersonSalaryEffectiveDate(budget);
        this.filterInstituteRatesBasedOnSalaryEffectiveDate(budget, allAbstractInstituteRates, filteredAbstractInstituteRates, personSalaryEffectiveDate);
    }

    protected boolean isOutOfSync(Budget budget) {
        return this.isOutOfSync(budget.getInstituteRates(), budget.getBudgetRates()) || this.isOutOfSync(budget.getInstituteLaRates(), budget.getBudgetLaRates());
    }

    protected boolean isOutOfSync(List instituteRates, List budgetRates) {
        boolean outOfSync = this.areNumbersOfBudgetRatesOutOfSyncWithInstituteRates(instituteRates, budgetRates);
        if (!outOfSync) {
            outOfSync = this.areBudgetRatesOutOfSyncWithInsttituteRates(instituteRates, budgetRates);
        }
        return outOfSync;
    }

    protected boolean areNumbersOfBudgetRatesOutOfSyncWithInstituteRates(List instituteRates, List budgetRates) {
        return instituteRates.size() != budgetRates.size();
    }

    protected boolean areBudgetRatesOutOfSyncWithInsttituteRates(List instituteRates, List budgetRates) {
        Set<String> budgetRateKeys;
        Set<String> instituteRateKeys = this.storeAllKeys(instituteRates);
        return !instituteRateKeys.containsAll(budgetRateKeys = this.storeAllKeys(budgetRates));
    }

    protected Set<String> storeAllKeys(List<AbstractInstituteRate> rates) {
        HashSet<String> keys = new HashSet<String>(rates.size(), 1.0f);
        keys.addAll(rates.stream().map(AbstractInstituteRate::getRateKeyAsString).collect(Collectors.toList()));
        return keys;
    }

    protected void resetAbstractBudgetApplicableRatesToInstituteRates(List budgetRates) {
        List abstractBudgetRates = budgetRates;
        for (AbstractBudgetRate abstractBudgetRate : abstractBudgetRates) {
            abstractBudgetRate.setApplicableRate(abstractBudgetRate.getExternalApplicableRate());
        }
    }

    protected void resetBudgetRatesForRateClassType(List<RateClass> rateClasses, String rateClassType, List budgetRates) {
        List abstractBudgetRates = budgetRates;
        for (RateClass rateClass : rateClasses) {
            if (!rateClass.getRateClassTypeCode().equalsIgnoreCase(rateClassType)) continue;
            abstractBudgetRates.stream().filter(abstractBudgetRate -> abstractBudgetRate.getRateClassCode().equalsIgnoreCase(rateClass.getCode())).forEach(abstractBudgetRate -> abstractBudgetRate.setApplicableRate(abstractBudgetRate.getExternalApplicableRate()));
        }
    }

    protected void syncBudgetRates(List budgetRates, Collection abstractIntituteRates) {
        List abstractBudgetRates = budgetRates;
        Map<String, AbstractInstituteRate> instRateMap = this.mapRatesToKeys(abstractIntituteRates);
        for (AbstractBudgetRate abstractBudgetRate : abstractBudgetRates) {
            String hKey = abstractBudgetRate.getRateKeyAsString();
            AbstractInstituteRate abstractInstituteRate = instRateMap.get(hKey);
            abstractBudgetRate.setInstituteRate(abstractInstituteRate.getInstituteRate());
            abstractBudgetRate.setApplicableRate(abstractInstituteRate.getExternalApplicableRate());
        }
    }

    protected String getFormattedAffectedBudgetPeriod(String periodAffected) {
        String budgetPeriodAffected = periodAffected;
        if (budgetPeriodAffected != null) {
            budgetPeriodAffected = budgetPeriodAffected.trim();
            budgetPeriodAffected = budgetPeriodAffected.replace(PERIOD_SEARCH_SEPARATOR, PERIOD_DISPLAY_SEPARATOR);
            budgetPeriodAffected = budgetPeriodAffected.substring(1, budgetPeriodAffected.length() - 1);
        }
        return budgetPeriodAffected;
    }

    protected void viewLocation(String viewLocation, Integer budgetPeriod, List rates) {
        List budgetRates = rates;
        for (AbstractBudgetRate budgetRate : budgetRates) {
            boolean displayRate;
            String onOffCampusFlag = this.getLocationFlagAsString(budgetRate.getOnOffCampusFlag());
            boolean bl = displayRate = viewLocation == null || viewLocation.equalsIgnoreCase(onOffCampusFlag);
            if (displayRate && budgetPeriod != null) {
                String trackAffectedPeriod = budgetRate.getTrackAffectedPeriod();
                String formattedBudgetPeriod = this.getSeparatedBudgetPeriod(budgetPeriod);
                if (trackAffectedPeriod == null || !trackAffectedPeriod.contains(formattedBudgetPeriod)) {
                    displayRate = false;
                }
            }
            budgetRate.setDisplayLocation(displayRate);
        }
    }

    protected String getLocationFlagAsString(boolean onOffCampusFlag) {
        return onOffCampusFlag ? "N" : "F";
    }

    protected String getSeparatedBudgetPeriod(Integer budgetPeriod) {
        return PERIOD_SEARCH_SEPARATOR + budgetPeriod + PERIOD_SEARCH_SEPARATOR;
    }

    protected Map<String, RateClassType> populateExistingRateClassTypeMap(List<RateClassType> rateClassTypes) {
        HashMap<String, RateClassType> existingRateClassTypeMap = new HashMap<String, RateClassType>();
        for (RateClassType rateClassType : rateClassTypes) {
            existingRateClassTypeMap.put(rateClassType.getCode(), rateClassType);
        }
        return existingRateClassTypeMap;
    }

    protected void getBudgetRates(Budget budget, Collection<InstituteRate> allInstituteRates) {
        this.getBudgetRates(budget.getRateClassTypes(), budget, allInstituteRates);
    }

    protected void getBudgetRates(List<RateClassType> rateClassTypes, Budget budget, Collection<InstituteRate> allInstituteRates) {
        List<InstituteRate> instituteRates = budget.getInstituteRates();
        this.filterRates(budget, allInstituteRates, instituteRates);
        List<BudgetRate> budgetRates = budget.getBudgetRates();
        this.syncBudgetRateCollections(rateClassTypes, budget, instituteRates, budgetRates);
        this.getBudgetLaRates(rateClassTypes, budget);
        this.checkActivityPrefixForRateClassTypes(rateClassTypes, budget);
    }

    protected void getBudgetLaRates(Budget budget, List<InstituteLaRate> allInstituteLaRates) {
        this.getBudgetLaRates(budget.getRateClassTypes(), budget, allInstituteLaRates);
    }

    protected void getBudgetLaRates(List<RateClassType> rateClassTypes, Budget budget) {
        this.getBudgetLaRates(rateClassTypes, budget, new ArrayList<InstituteLaRate>(this.getInstituteLaRates(budget)));
    }

    protected void getBudgetLaRates(List<RateClassType> rateClassTypes, Budget budget, List<InstituteLaRate> allInstituteLaRates) {
        List<InstituteLaRate> instituteLaRates = budget.getInstituteLaRates();
        this.filterRates(budget, allInstituteLaRates, instituteLaRates);
        List<BudgetLaRate> budgetRates = budget.getBudgetLaRates();
        this.syncBudgetRateCollections(rateClassTypes, budget, instituteLaRates, budgetRates);
    }

    protected void syncBudgetRateCollections(List<RateClassType> rateClassTypes, Budget budget, List abstractInstituteRates, List budgetRates) {
        List abstractBudgetRates = budgetRates;
        List instituteRates = abstractInstituteRates;
        this.syncAllRateClasses(budget, instituteRates);
        this.syncAllRateClassTypes(rateClassTypes, instituteRates);
        if (budgetRates.size() == 0) {
            this.syncAllBudgetRatesForInstituteRateType(budget, abstractBudgetRates, instituteRates);
        }
    }

    @Override
    public void syncBudgetRateCollectionsToExistingRates(List<RateClassType> rateClassTypes, Budget budget) {
        this.syncAllRateClasses(budget, budget.getBudgetRates());
        this.syncAllRateClassTypes(rateClassTypes, budget.getBudgetRates());
        this.syncAllRateClasses(budget, budget.getBudgetLaRates());
        this.syncAllRateClassTypes(rateClassTypes, budget.getBudgetLaRates());
        this.checkActivityPrefixForRateClassTypes(rateClassTypes, budget);
    }

    protected void syncAllBudgetRatesForInstituteRateType(Budget budget, List<AbstractBudgetRate> budgetRates, List<AbstractInstituteRate> instituteRates) {
        budgetRates.addAll(instituteRates.stream().filter(abstractInstituteRate -> abstractInstituteRate.getRateClass() != null).map(abstractInstituteRate -> this.generateBudgetRate(budget, (AbstractInstituteRate)abstractInstituteRate)).collect(Collectors.toList()));
        this.updateRatesForEachPeriod(budget);
        Collections.sort(budgetRates);
    }

    protected void replaceRateClassesForRateClassType(String rateClassType, Budget budget, List rates) {
        List instituteRates = rates;
        List<RateClass> budgetRateClasses = budget.getRateClasses();
        this.removeAllPreviouslyRegisteredRateClassesForRateClassType(rateClassType, budgetRateClasses);
        this.addRateClassesForRateClassType(rateClassType, instituteRates);
    }

    protected void removeAllPreviouslyRegisteredRateClassesForRateClassType(String rateClassType, List<RateClass> budgetRateClasses) {
        Iterator<RateClass> iter = budgetRateClasses.iterator();
        while (iter.hasNext()) {
            RateClass rateClass = iter.next();
            if (!rateClassType.equals(rateClass.getRateClassTypeCode())) continue;
            iter.remove();
        }
    }

    protected void addRateClassesForRateClassType(String rateClassType, List<AbstractInstituteRate> instituteRates) {
        HashMap<String, RateClass> mapOfMatchingRateClasses = new HashMap<String, RateClass>();
        for (AbstractInstituteRate abstractInstituteRate : instituteRates) {
            if (abstractInstituteRate.getRateType() == null) continue;
            RateClass rateClass = abstractInstituteRate.getRateType().getRateClass();
            if (rateClass == null) {
                abstractInstituteRate.getRateType().refreshNonUpdateableReferences();
            }
            if (!(rateClass = abstractInstituteRate.getRateType().getRateClass()).getRateClassTypeCode().equals(rateClassType) || mapOfMatchingRateClasses.get(rateClass.getCode()) != null) continue;
            mapOfMatchingRateClasses.put(rateClass.getCode(), rateClass);
        }
    }

    protected void replaceBudgetRatesForRateClassType(String rateClassType, Budget budget, List existingBudgetRates, List rates) {
        List instituteRates = rates;
        List abstractBudgetRates = existingBudgetRates;
        Map<String, AbstractBudgetRate> existingBudgetRateMap = this.preservePersistedBudgetRatesForRateClassType(rateClassType, abstractBudgetRates);
        this.removeRegisteredBudgetRatesForRateClassType(rateClassType, abstractBudgetRates);
        Map<String, AbstractBudgetRate> newBudgetRateMap = this.generateNewAndUpdatedBudgetRates(rateClassType, budget, instituteRates, existingBudgetRateMap);
        this.registerNewAndUpdatedBudgetRates(abstractBudgetRates, newBudgetRateMap);
        this.updateRatesForEachPeriod(budget);
        Collections.sort(abstractBudgetRates);
    }

    protected void registerNewAndUpdatedBudgetRates(List<AbstractBudgetRate> abstractBudgetRates, Map<String, AbstractBudgetRate> newBudgetRateMap) {
        abstractBudgetRates.addAll(newBudgetRateMap.values());
    }

    protected Map<String, AbstractBudgetRate> generateNewAndUpdatedBudgetRates(String rateClassType, Budget budget, List<AbstractInstituteRate> instituteRates, Map<String, AbstractBudgetRate> existingBudgetRateMap) {
        HashMap<String, AbstractBudgetRate> newBudgetRateMap = new HashMap<String, AbstractBudgetRate>();
        instituteRates.stream().filter(abstractInstituteRate -> abstractInstituteRate.getRateType() != null).forEach(abstractInstituteRate -> {
            RateClass rateClass = abstractInstituteRate.getRateType().getRateClass();
            if (rateClassType.equals(rateClass.getRateClassTypeCode())) {
                AbstractBudgetRate newBudgetRate = this.generateBudgetRate(budget, (AbstractInstituteRate)abstractInstituteRate);
                String hKey = abstractInstituteRate.getRateKeyAsString();
                AbstractBudgetRate existingBudgetRate = (AbstractBudgetRate)existingBudgetRateMap.get(hKey);
                if (existingBudgetRate != null) {
                    newBudgetRate.setVersionNumber(existingBudgetRate.getVersionNumber());
                }
                newBudgetRateMap.put(hKey, newBudgetRate);
            }
        });
        return newBudgetRateMap;
    }

    protected void removeRegisteredBudgetRatesForRateClassType(String rateClassType, List<AbstractBudgetRate> abstractBudgetRates) {
        Iterator<AbstractBudgetRate> iter = abstractBudgetRates.iterator();
        while (iter.hasNext()) {
            AbstractBudgetRate budgetRate = iter.next();
            if (!rateClassType.equals(budgetRate.getRateClass().getRateClassTypeCode())) continue;
            iter.remove();
        }
    }

    protected Map<String, AbstractBudgetRate> preservePersistedBudgetRatesForRateClassType(String rateClassType, List<AbstractBudgetRate> abstractBudgetRates) {
        HashMap<String, AbstractBudgetRate> existingBudgetRateMap = new HashMap<String, AbstractBudgetRate>();
        abstractBudgetRates.stream().filter(abstractBudgetRate -> rateClassType.equals(abstractBudgetRate.getRateClass().getRateClassTypeCode())).forEach(abstractBudgetRate -> existingBudgetRateMap.put(abstractBudgetRate.getRateKeyAsString(), (AbstractBudgetRate)abstractBudgetRate));
        return existingBudgetRateMap;
    }

    protected void syncAllRateClasses(Budget budget, List<AbstractInstituteRate> instituteRates) {
        HashMap rateClassMap = new HashMap();
        instituteRates.stream().filter(abstractInstituteRate -> abstractInstituteRate.getRateClass() != null).forEach(abstractInstituteRate -> {
            String rateClassCode = abstractInstituteRate.getRateClassCode();
            if (rateClassMap.get(rateClassCode) == null) {
                rateClassMap.put(rateClassCode, abstractInstituteRate.getRateClass());
            }
        });
        budget.getRateClasses().addAll(rateClassMap.values());
    }

    protected void syncAllRateClassTypes(List<RateClassType> rateClassTypes, List<AbstractInstituteRate> instituteRates) {
        Map<String, RateClassType> existingRateClassTypeMap = this.populateExistingRateClassTypeMap(rateClassTypes);
        HashMap rateClassTypeMap = new HashMap();
        instituteRates.stream().filter(abstractInstituteRate -> abstractInstituteRate.getRateClass() != null).forEach(abstractInstituteRate -> {
            String rateClassType = abstractInstituteRate.getRateClass().getRateClassTypeCode();
            if (existingRateClassTypeMap.get(rateClassType) == null) {
                rateClassTypeMap.put(rateClassType, abstractInstituteRate.getRateClass().getRateClassType());
            }
        });
        rateClassTypes.addAll(rateClassTypeMap.values());
    }

    protected AbstractBudgetRate generateBudgetProposalRate(Budget budget, InstituteRate instituteRate) {
        BudgetParent budgetParent = budget.getBudgetParent();
        return new BudgetRate(budgetParent.getUnitNumber(), instituteRate);
    }

    protected AbstractBudgetRate generateBudgetProposalLaRate(Budget budget, InstituteLaRate instituteLaRate) {
        BudgetParent budgetParent = budget.getBudgetParent();
        return new BudgetLaRate(budgetParent.getUnitNumber(), instituteLaRate);
    }

    protected AbstractBudgetRate generateBudgetRate(Budget budget, AbstractInstituteRate abstractInstituteRate) {
        AbstractBudgetRate abstractBudgetRate = abstractInstituteRate instanceof InstituteRate ? this.generateBudgetProposalRate(budget, (InstituteRate)abstractInstituteRate) : this.generateBudgetProposalLaRate(budget, (InstituteLaRate)abstractInstituteRate);
        abstractBudgetRate.setBudgetId(budget.getBudgetId());
        abstractBudgetRate.setBudget(budget);
        return abstractBudgetRate;
    }

    @Override
    public Collection<RateClass> getBudgetRateClasses(String rateClassType) {
        return this.getDataObjectService().findMatching(RateClass.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("rateClassTypeCode", rateClassType)).build()).getResults();
    }

    @Override
    public Map<String, RateClass> getBudgetRateClassMap(String rateClassType) {
        HashMap<String, RateClass> retval = new HashMap<String, RateClass>();
        for (RateClass rateClass : this.getBudgetRateClasses(rateClassType)) {
            retval.put(rateClass.getCode(), rateClass);
        }
        return retval;
    }

    @Override
    public void populateInstituteRates(Budget budget) {
        List instituteRates = (List)this.getInstituteRates(budget);
        this.filterRates(budget, instituteRates, budget.getInstituteRates());
        List instituteLaRates = (List)this.getInstituteLaRates(budget);
        this.filterRates(budget, instituteLaRates, budget.getInstituteLaRates());
    }

    @Override
    public boolean performSyncFlag(Budget budget) {
        return false;
    }

    @Override
    public ScaleTwoDecimal getUnitFormulatedCost(String unitNumber, String formulatedTypeCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formulatedTypeCode", formulatedTypeCode);
        List unitFormulatedCosts = this.getBusinessObjectService().findMatchingOrderBy(UnitFormulatedCost.class, param, UNIT_NUMBER_KEY, true);
        List<Unit> unitHierarchy = this.unitService.getUnitHierarchyForUnit(unitNumber);
        for (Unit unit : unitHierarchy) {
            for (UnitFormulatedCost unitFormulatedCost : unitFormulatedCosts) {
                if (!unit.getUnitNumber().equals(unitFormulatedCost.getUnitNumber())) continue;
                return unitFormulatedCost.getUnitCost();
            }
        }
        return ScaleTwoDecimal.ZERO;
    }

    @Override
    public Collection<BudgetRate> getSavedBudgetRates(Budget budget) {
        HashMap<String, Long> qMap = new HashMap<String, Long>();
        qMap.put("budgetId", budget.getBudgetId());
        List rates = this.businessObjectService.findMatching(BudgetRate.class, qMap);
        for (BudgetRate rate : rates) {
            GregorianCalendar startDate = new GregorianCalendar();
            startDate.setTime(rate.getStartDate());
            Integer newFY = this.getFiscalYearMonthService().getFiscalYearFromDate(startDate);
            rate.setFiscalYear(newFY.toString());
        }
        return rates;
    }

    @Override
    public boolean checkActivityTypeChange(Budget budget) {
        return this.checkActivityTypeChange(this.getSavedBudgetRates(budget), budget.getBudgetParent().getActivityTypeCode());
    }

    @Override
    public boolean checkActivityTypeChange(Collection<BudgetRate> allPropRates, String activityTypeCode) {
        Equals equalsActivityType;
        QueryList<BudgetRate> matchActivityTypePropRates;
        return CollectionUtils.isNotEmpty(allPropRates) && (CollectionUtils.isEmpty(matchActivityTypePropRates = new QueryList<BudgetRate>(allPropRates).filter(equalsActivityType = new Equals(ACTIVITY_TYPE_CODE_KEY, (Comparable)((Object)activityTypeCode)))) || allPropRates.size() != matchActivityTypePropRates.size());
    }

    @Override
    public boolean isVacation(String rateClassTypeCode) {
        return StringUtils.equals((CharSequence)rateClassTypeCode, (CharSequence)org.kuali.coeus.common.budget.api.rate.RateClassType.VACATION.getRateClassType());
    }

    @Override
    public boolean isEmployeeBenefit(String rateClassTypeCode) {
        return StringUtils.equals((CharSequence)rateClassTypeCode, (CharSequence)org.kuali.coeus.common.budget.api.rate.RateClassType.EMPLOYEE_BENEFITS.getRateClassType());
    }

    @Override
    public boolean isLabAllocationSalary(String rateClassTypeCode) {
        return StringUtils.equals((CharSequence)rateClassTypeCode, (CharSequence)org.kuali.coeus.common.budget.api.rate.RateClassType.LA_SALARIES.getRateClassType());
    }

    @Override
    public boolean isOverhead(String rateClassTypeCode) {
        return StringUtils.equals((CharSequence)rateClassTypeCode, (CharSequence)org.kuali.coeus.common.budget.api.rate.RateClassType.OVERHEAD.getRateClassType());
    }

    @Override
    public boolean isVacationOnLabAllocation(String rateClassCode, String rateTypeCode) {
        ValidCalcType vacationOnLaValidCalcType = this.getDependentValidRateClassTypeForLA(org.kuali.coeus.common.budget.api.rate.RateClassType.VACATION.getRateClassType());
        return vacationOnLaValidCalcType != null && StringUtils.equals((CharSequence)rateClassCode, (CharSequence)vacationOnLaValidCalcType.getRateClassCode()) && StringUtils.equals((CharSequence)rateTypeCode, (CharSequence)vacationOnLaValidCalcType.getRateTypeCode());
    }

    @Override
    public boolean isEmployeeBenefitOnLabAllocation(String rateClassCode, String rateTypeCode) {
        ValidCalcType ebOnLaValidCalcType = this.getDependentValidRateClassTypeForLA(org.kuali.coeus.common.budget.api.rate.RateClassType.EMPLOYEE_BENEFITS.getRateClassType());
        return ebOnLaValidCalcType != null && StringUtils.equals((CharSequence)rateClassCode, (CharSequence)ebOnLaValidCalcType.getRateClassCode()) && StringUtils.equals((CharSequence)rateTypeCode, (CharSequence)ebOnLaValidCalcType.getRateTypeCode());
    }

    protected ValidCalcType getDependentValidRateClassTypeForLA(String rateClassType) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(RATE_CLASS_TYPE, rateClassType);
        param.put(DEPENDENT_RATE_CLASS_TYPE, org.kuali.coeus.common.budget.api.rate.RateClassType.LA_SALARIES.getRateClassType());
        List result = this.getBusinessObjectService().findMatching(ValidCalcType.class, param);
        return result.isEmpty() ? null : (ValidCalcType)result.get(0);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public FiscalYearMonthService getFiscalYearMonthService() {
        return this.fiscalYearMonthService;
    }

    public void setFiscalYearMonthService(FiscalYearMonthService fiscalYearMonthService) {
        this.fiscalYearMonthService = fiscalYearMonthService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

