/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.cache;

import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Component(value="requestLevelCacheResolver")
public class RequestLevelCacheResolver
extends SimpleCacheResolver {
    public RequestLevelCacheResolver(CacheManager requestLevelCacheManager) {
        super(requestLevelCacheManager);
    }

    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        RequestAttributes originalRequestAttributes = RequestContextHolder.getRequestAttributes();
        if (originalRequestAttributes == null) {
            return context.getOperation().getCacheNames().stream().map(ConcurrentMapCache::new).collect(Collectors.toSet());
        }
        return super.resolveCaches(context);
    }
}

