/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.cfda;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.impl.cfda.CfdaService;
import org.kuali.coeus.common.impl.cfda.CfdaUpdateResults;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.quartz.JobExecutionContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class CfdaBatchJob
extends QuartzJobBean {
    private static final String BREAK = "<BR>";
    private static final String CONTEXT_NAME = "CFDA Batch Job";
    private static final String SUBJECT = "CFDA batch job result";
    private static final Logger LOG = LogManager.getLogger(CfdaBatchJob.class);
    private String user;
    private CfdaService cfdaService;
    private ParameterService parameterService;
    private KcNotificationService kcNotificationService;

    protected void executeInternal(JobExecutionContext context) {
        StringBuilder builder = new StringBuilder();
        UserSession userSession = new UserSession(this.user);
        GlobalVariables.setUserSession((UserSession)userSession);
        CfdaUpdateResults updateResults = this.cfdaService.updateCfda();
        builder.append("Message: " + updateResults.getMessage() + BREAK);
        builder.append("NumberOfRecordsDeactivatedBecauseNoLongerOnWebSite: " + updateResults.getNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite() + BREAK);
        builder.append("NumberOfRecordsInKcDatabase: " + updateResults.getNumberOfRecordsInKcDatabase() + BREAK);
        builder.append("NumberOfRecordsNewlyAddedFromWebSite: " + updateResults.getNumberOfRecordsNewlyAddedFromWebSite() + BREAK);
        builder.append("NumberOfRecordsNotUpdatedBecauseManual: " + updateResults.getNumberOfRecordsNotUpdatedBecauseManual() + BREAK);
        builder.append("NumberOfRecordsNotUpdatedForHistoricalPurposes: " + updateResults.getNumberOfRecordsNotUpdatedForHistoricalPurposes() + BREAK);
        builder.append("NumberOfRecordsReActivated: " + updateResults.getNumberOfRecordsReActivated() + BREAK);
        builder.append("NumberOfRecordsRetrievedFromWebSite: " + updateResults.getNumberOfRecordsRetrievedFromWebSite() + BREAK);
        builder.append("NumberOfRecordsUpdatedBecauseAutomatic: " + updateResults.getNumberOfRecordsUpdatedBecauseAutomatic() + BREAK);
        String message = builder.toString();
        LOG.info(message);
        String recipient = this.getRecipient();
        if (StringUtils.isNotBlank((CharSequence)recipient)) {
            this.kcNotificationService.sendNotification(CONTEXT_NAME, SUBJECT, message, Collections.singletonList(recipient));
        }
    }

    protected String getRecipient() {
        return this.parameterService.getParameterValueAsString("KC-GEN", "All", "CFDA_BATCH_NOTIFICATION_RECIPIENT");
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setCfdaService(CfdaService cfdaService) {
        this.cfdaService = cfdaService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }
}

