/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.custom.arg;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class ArgValueLookupValuesFinder
extends UifKeyValuesFinderBase {
    private static final String ARGUMENT_NAME = "argumentName";
    private static final String ARG_VALUE_VALUES_FINDER_DEFAULT_CONFIG = "ARG_VALUE_VALUES_FINDER_DEFAULT_CONFIG";
    private static final String ARG_VALUE_VALUES_FINDER_ARG_CONFIG = "ARG_VALUE_VALUES_FINDER_ARG_CONFIG";
    private transient ParameterService parameterService;
    private transient BusinessObjectService businessObjectService;
    private static final String INACTIVE_IND = "(inactive)";
    private String argName;
    private String currentValue;
    private boolean excludeInactive = true;

    public List<KeyValue> getKeyValues() {
        List argValueLookups = this.getBusinessObjectService().findMatching(ArgValueLookup.class, Collections.singletonMap(ARGUMENT_NAME, this.argName));
        String defaultConfig = this.getParameterService().getParameterValueAsString("KC-GEN", "All", ARG_VALUE_VALUES_FINDER_DEFAULT_CONFIG);
        String argConfig = this.getParameterService().getSubParameterValueAsString("KC-GEN", "All", ARG_VALUE_VALUES_FINDER_ARG_CONFIG, this.argName);
        String cfg = StringUtils.isNotBlank((CharSequence)argConfig) ? argConfig : defaultConfig;
        return Stream.concat(Stream.of(ValuesFinderUtils.getSelectOption()), argValueLookups.stream().filter(argValue -> !this.isExcludeInactive() || argValue.isActive() || StringUtils.equals((CharSequence)this.currentValue, (CharSequence)argValue.getValue())).sorted(Comparator.comparing(argValue -> this.getKeyValueValue((ArgValueLookup)argValue, cfg)).thenComparing(ArgValueLookup::isActive)).map(argValueLookup -> new ConcreteKeyValue(argValueLookup.getValue(), this.getKeyValueValue((ArgValueLookup)argValueLookup, cfg)))).collect(Collectors.toList());
    }

    protected String getKeyValueValue(ArgValueLookup argValueLookup, String cfg) {
        Object value = argValueLookup.getValue();
        if (ArgValueConfig.VALUE.toString().equals(cfg)) {
            value = argValueLookup.getValue();
        } else if (ArgValueConfig.DESCRIPTION.toString().equals(cfg)) {
            value = argValueLookup.getDescription();
        } else if (ArgValueConfig.BOTH.toString().equals(cfg)) {
            value = argValueLookup.getValue() + (String)(StringUtils.isNotBlank((CharSequence)argValueLookup.getDescription()) ? " - " + argValueLookup.getDescription() : "");
        }
        return argValueLookup.isActive() ? value : (String)value + " (inactive)";
    }

    public String getArgName() {
        return this.argName;
    }

    public void setArgName(String argName) {
        this.argName = argName;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public boolean isExcludeInactive() {
        return this.excludeInactive;
    }

    public void setExcludeInactive(boolean excludeInactive) {
        this.excludeInactive = excludeInactive;
    }

    private static enum ArgValueConfig {
        VALUE,
        DESCRIPTION,
        BOTH;

    }
}

