/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.document;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.document.dto.ApproverDto;
import org.kuali.coeus.elasticsearch.ElasticsearchAccessControlService;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.coeus.sys.impl.workflow.DocumentType;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v1"})
@RestController(value="documentController")
public class DocumentController
extends org.kuali.coeus.sys.framework.controller.rest.RestController {
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="kewDocHeaderDao")
    private KewDocHeaderDao kewDocHeaderDao;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="groupService")
    private GroupService groupService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    private ElasticsearchAccessControlService elasticsearchAccessControlService;
    private ElasticsearchIndexService elasticsearchIndexService;
    private static final Logger LOG = LogManager.getLogger(DocumentController.class);

    @RequestMapping(method={RequestMethod.POST}, value={"/documents/{documentId}/approver"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ApproverDto assignApprover(@RequestBody ApproverDto approverDto, @PathVariable String documentId) throws Exception {
        Document document = this.documentService.getByDocumentHeaderId(documentId);
        this.checkDocAndPerms(document);
        Person approver = this.getPerson(approverDto.getApproverId());
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)document).getDevelopmentProposal();
        developmentProposal.setAssignerId(this.globalVariableService.getUserSession().getPrincipalId());
        developmentProposal.setApproverId(approverDto.getApproverId());
        this.dataObjectService.save((Object)developmentProposal, new PersistenceOption[0]);
        approverDto.setProposalNumber(developmentProposal.getProposalNumber());
        approverDto.setApproverName(approver.getName());
        this.getElasticsearchIndexService().indexPostCommit(documentId, this.kewDocHeaderDao.getAllNonActiveDocumentIds(documentId));
        return approverDto;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/documents/{documentId}/approver"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void deleteApprover(@PathVariable String documentId) throws Exception {
        Document document = this.documentService.getByDocumentHeaderId(documentId);
        this.checkDocAndPerms(document);
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)document).getDevelopmentProposal();
        developmentProposal.setApproverId(null);
        developmentProposal.setAssignerId(this.globalVariableService.getUserSession().getPrincipalId());
        this.dataObjectService.save((Object)developmentProposal, new PersistenceOption[0]);
        this.getElasticsearchIndexService().indexPostCommit(documentId, this.kewDocHeaderDao.getAllNonActiveDocumentIds(documentId));
    }

    @GetMapping(value={"/viewable-units"}, produces={"application/json"})
    public Map<String, Set<String>> getViewableUnits() throws Exception {
        String userId = this.globalVariableService.getUserSession().getPrincipalId();
        return this.getElasticsearchAccessControlService().getViewableUnitsForUser(userId);
    }

    @PostMapping(value={"/index-documents"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public String indexAllDocuments(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="skip", required=false) Integer skip, @RequestParam(value="newBulk", required=false) boolean newBulk, @RequestParam(value="docType", required=false) String docType) throws Exception {
        List<String> docIds;
        this.checkAuthorizedToIndexIntoElasticsearch();
        DocumentType documentType = DocumentType.fromAbbreviation(docType);
        List<String> list = docIds = documentType == null ? this.kewDocHeaderDao.getAllDocumentIds(limit, skip) : this.kewDocHeaderDao.getAllDocumentIdsByType(limit, skip, documentType);
        if (newBulk) {
            this.getElasticsearchIndexService().newBulkIndex(docIds);
        } else {
            this.getElasticsearchIndexService().bulkIndex(docIds);
        }
        return String.format("Started indexing %s documents", docIds.size());
    }

    @PostMapping(value={"/index-documents/{documentId}"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public String indexDocument(@PathVariable String documentId) throws Exception {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            throw new IllegalArgumentException("Must provide a document ID.");
        }
        this.checkAuthorizedToIndexIntoElasticsearch();
        if (!this.getElasticsearchIndexService().index(documentId, this.kewDocHeaderDao.getAllNonActiveDocumentIds(documentId)).get().booleanValue()) {
            return String.format("Failed to index document %s", documentId);
        }
        return String.format("Indexed document %s into Elasticsearch", documentId);
    }

    protected void checkAuthorizedToIndexIntoElasticsearch() {
        String userId = this.globalVariableService.getUserSession().getPrincipalId();
        if (!this.permissionService.hasPermission(userId, "KC-SYS", "Index Elasticsearch Documents")) {
            String username = this.globalVariableService.getUserSession().getPrincipalName();
            throw new UnauthorizedAccessException("User " + username + " is not authorized to index documents into Elasticsearch");
        }
        if (!this.configurationService.getPropertyValueAsBoolean("elasticsearch.enabled")) {
            throw new UnsupportedOperationException("Elasticsearch indexing is disabled");
        }
    }

    protected void checkDocAndPerms(Document document) {
        this.checkIfPersonHasPerms("KC-PD", "Assign Proposal Development Workload Approver");
        if (Objects.isNull(document) || !document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName().equalsIgnoreCase("ProposalDevelopmentDocument")) {
            throw new NotImplementedException("Approvers can only be assigned to Proposal Development Documents.");
        }
    }

    protected void checkIfPersonHasPerms(String namespaceCode, String permissionName) {
        this.checkIfPersonHasPerms(namespaceCode, permissionName, this.globalVariableService.getUserSession().getPerson());
    }

    protected void checkIfPersonHasPerms(String namespaceCode, String permissionName, Person currentUser) {
        if (!this.permissionService.hasPermission(currentUser.getPrincipalId(), namespaceCode, permissionName)) {
            throw new UnauthorizedAccessException("User " + currentUser.getPrincipalName() + " is not authorized to assign approvers");
        }
    }

    private Person getPerson(String user) {
        Person person = this.personService.getPerson(user);
        if (person == null) {
            throw new UnprocessableEntityException("Person with id " + user + " not found.");
        }
        return person;
    }

    public ElasticsearchIndexService getElasticsearchIndexService() {
        if (this.elasticsearchIndexService == null) {
            this.elasticsearchIndexService = KcServiceLocator.getService(ElasticsearchIndexService.class);
        }
        return this.elasticsearchIndexService;
    }

    public ElasticsearchAccessControlService getElasticsearchAccessControlService() {
        if (this.elasticsearchAccessControlService == null) {
            this.elasticsearchAccessControlService = KcServiceLocator.getService(ElasticsearchAccessControlService.class);
        }
        return this.elasticsearchAccessControlService;
    }
}

