/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.citi;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.citi.CitiDataLoadingService;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecord;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecordError;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecordStatus;
import org.kuali.coeus.common.impl.person.citi.CitiConstants;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="citiDataLoadingService")
public class CitiDataLoadingServiceImpl
implements CitiDataLoadingService {
    private static final Logger LOG = LogManager.getLogger(CitiDataLoadingServiceImpl.class);
    private static final Pattern COMMA_REGEX = Pattern.compile(",");
    private static final String CITI_ENDPOINTS = "citi.endpoints";
    private static final String CITI_BASE_URL = "citi.baseUrl";
    private static final String CITI_REPORT_OWNER_ID = "citi.reportOwnerId";
    private static final String CITI_REPORT_IDS = "citi.reportIds";
    private static final String CITI_SHARED_KEY = "citi.sharedKey";
    private static final String CITI_DELIMETER = "citi.delimiter";
    private static final String CITI_HEADER_LABEL_PREFIX = "citi.header.label.";
    private static final String QUERY_PARAM_REPORT_OWNER_ID = "ID";
    private static final String QUERY_PARAM_REPORT_ID = "durlid";
    private static final String QUERY_PARAM_REQUEST_TIMESTAMP = "requestdatetime";
    private static final String QUERY_PARAM_START_TIMESTAMP = "startdatetime";
    private static final String QUERY_PARAM_END_TIMESTAMP = "enddatetime";
    private static final String QUERY_PARAM_CHECKSUM = "hash";
    private static final ZoneId EASTERN_TIMEZONE = ZoneId.of("America/New_York");
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public void loadRecords(LocalDateTime startDate, LocalDateTime endDate) {
        Set<URI> citiEndpoints = this.getEndpoints(startDate, endDate);
        if (!citiEndpoints.isEmpty()) {
            LOG.info("Loading citi data from " + citiEndpoints.stream().map(URI::toString).collect(Collectors.joining(",")));
            this.getBusinessObjectService().deleteMatching(PersonTrainingCitiRecordError.class, Collections.emptyMap());
            this.getBusinessObjectService().deleteMatching(PersonTrainingCitiRecord.class, Collections.emptyMap());
            char citiDelimiter = this.getConfigurationService().getPropertyValueAsString(CITI_DELIMETER).charAt(0);
            Map<String, String> headerMap = startDate == null ? this.getConfiguredHeaders() : CitiConstants.CITI_V2_HEADERS;
            citiEndpoints.stream().map(endpoint -> (String)this.getRestOperations().getForObject(endpoint, String.class)).forEach(records -> {
                try (StringReader reader = new StringReader((String)records);){
                    CSVParser parser = CSVFormat.DEFAULT.withDelimiter(citiDelimiter).withFirstRecordAsHeader().withAllowMissingColumnNames(true).withIgnoreEmptyLines(true).withIgnoreHeaderCase(true).withIgnoreSurroundingSpaces(true).withTrim(true).withQuote(null).parse((Reader)reader);
                    this.processRecords(headerMap, parser.iterator());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private Map<String, String> getConfiguredHeaders() {
        return this.getConfigurationService().getAllProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CITI_HEADER_LABEL_PREFIX)).collect(CollectionUtils.entriesToMap());
    }

    private Set<URI> getEndpoints(LocalDateTime startDate, LocalDateTime endDate) {
        LocalDateTime endDateTime = Optional.ofNullable(endDate).orElse(LocalDateTime.now());
        if (startDate == null) {
            String endpoints = this.getConfigurationService().getPropertyValueAsString(CITI_ENDPOINTS);
            if (StringUtils.isNotBlank((CharSequence)endpoints)) {
                return COMMA_REGEX.splitAsStream(endpoints).map(String::trim).filter(StringUtils::isNotBlank).map(endpoint -> UriComponentsBuilder.fromUriString((String)endpoint).build(true).toUri()).collect(Collectors.toSet());
            }
        } else {
            String reportIds = this.getConfigurationService().getPropertyValueAsString(CITI_REPORT_IDS);
            String baseUrl = this.getConfigurationService().getPropertyValueAsString(CITI_BASE_URL);
            String reportOwnerId = this.getConfigurationService().getPropertyValueAsString(CITI_REPORT_OWNER_ID);
            String sharedKey = this.getConfigurationService().getPropertyValueAsString(CITI_SHARED_KEY);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reportIds, baseUrl, reportOwnerId, sharedKey})) {
                return COMMA_REGEX.splitAsStream(reportIds).map(String::trim).filter(StringUtils::isNotBlank).map(reportId -> {
                    String now = this.eastCoastTime(LocalDateTime.now());
                    String checksum = DigestUtils.md5Hex((String)(reportOwnerId + reportId + now + sharedKey));
                    return UriComponentsBuilder.fromUriString((String)baseUrl).queryParam(QUERY_PARAM_REPORT_OWNER_ID, new Object[]{reportOwnerId}).queryParam(QUERY_PARAM_REPORT_ID, new Object[]{reportId}).queryParam(QUERY_PARAM_REQUEST_TIMESTAMP, new Object[]{now}).queryParam(QUERY_PARAM_START_TIMESTAMP, new Object[]{this.eastCoastTime(startDate)}).queryParam(QUERY_PARAM_END_TIMESTAMP, new Object[]{this.eastCoastTime(endDateTime)}).queryParam(QUERY_PARAM_CHECKSUM, new Object[]{checksum}).build().toUri();
                }).collect(Collectors.toSet());
            }
        }
        return Collections.emptySet();
    }

    private String eastCoastTime(LocalDateTime dateTime) {
        return dateTime.atZone(ZoneId.systemDefault()).withZoneSameInstant(EASTERN_TIMEZONE).truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    protected void processRecords(Map<String, String> headerMap, Iterator<CSVRecord> records) {
        StreamSupport.stream(((Iterable)() -> records).spliterator(), false).map(record -> {
            PersonTrainingCitiRecord sr = new PersonTrainingCitiRecord();
            sr.setStatusCode(PersonTrainingCitiRecordStatus.STAGED.getCode());
            try {
                BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)sr);
                wrapper.registerCustomEditor(Timestamp.class, (PropertyEditor)new CitiTimestampEditor());
                headerMap.entrySet().stream().filter(e -> record.isMapped((String)e.getValue())).forEach(arg_0 -> CitiDataLoadingServiceImpl.lambda$processRecords$7((BeanWrapper)wrapper, record, arg_0));
            }
            catch (RuntimeException e2) {
                sr.addError(new PersonTrainingCitiRecordError(e2.getMessage()));
                LOG.error(record.toString() + " has an error", (Throwable)e2);
            }
            sr.setRawRecord(record.toString());
            return sr;
        }).forEach(sr -> {
            try {
                this.getBusinessObjectService().save((PersistableBusinessObject)sr);
            }
            catch (Exception ex) {
                this.recordErrors((PersonTrainingCitiRecord)sr, ex.getMessage());
                LOG.error(sr.toString() + " has an error", (Throwable)ex);
            }
        });
        if (LOG.isInfoEnabled()) {
            int recordCount = this.getBusinessObjectService().countMatching(PersonTrainingCitiRecord.class, Collections.emptyMap());
            LOG.info("Loaded " + recordCount + " citi records for processing");
        }
    }

    protected void recordErrors(PersonTrainingCitiRecord currentPersonTrainingCitiRecord, String errorMessage) {
        int firstNameMaxLength = 40;
        int lastNameMaxLength = 80;
        PersonTrainingCitiRecord newPersonTrainingCitiRecord = new PersonTrainingCitiRecord();
        newPersonTrainingCitiRecord.setStatusCode(PersonTrainingCitiRecordStatus.ERRORED.getCode());
        newPersonTrainingCitiRecord.setFirstName(StringUtils.substring((String)currentPersonTrainingCitiRecord.getFirstName(), (int)firstNameMaxLength));
        newPersonTrainingCitiRecord.setLastName(StringUtils.substring((String)currentPersonTrainingCitiRecord.getLastName(), (int)lastNameMaxLength));
        newPersonTrainingCitiRecord.addError(new PersonTrainingCitiRecordError(errorMessage));
        try {
            this.getBusinessObjectService().save((PersistableBusinessObject)newPersonTrainingCitiRecord);
        }
        catch (Exception ex) {
            LOG.error(newPersonTrainingCitiRecord.toString() + " has an error", (Throwable)ex);
        }
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private static /* synthetic */ void lambda$processRecords$7(BeanWrapper wrapper, CSVRecord record, Map.Entry e) {
        wrapper.setPropertyValue(((String)e.getKey()).replace(CITI_HEADER_LABEL_PREFIX, ""), (Object)record.get((String)e.getValue()));
    }

    private static class CitiTimestampEditor
    extends PropertyEditorSupport {
        private static final String TIMESTAMP_FORMAT1 = "MM/d/yyyy h:m:s a";
        private static final String TIMESTAMP_FORMAT2 = "MM/dd/yy";

        private CitiTimestampEditor() {
        }

        @Override
        public void setAsText(String value) {
            this.setValue(value);
        }

        @Override
        public Object getValue() {
            Date date;
            if (super.getValue() == null || StringUtils.isBlank((CharSequence)super.getValue().toString())) {
                return null;
            }
            SimpleDateFormat format1 = new SimpleDateFormat(TIMESTAMP_FORMAT1);
            try {
                date = format1.parse(super.getValue().toString());
            }
            catch (ParseException e) {
                SimpleDateFormat format2 = new SimpleDateFormat(TIMESTAMP_FORMAT2);
                try {
                    date = format2.parse(super.getValue().toString());
                }
                catch (ParseException e1) {
                    throw new RuntimeException(e);
                }
            }
            return new Timestamp(date.getTime());
        }
    }
}

