/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.hr.impl;

import java.util.LinkedList;
import java.util.List;
import org.kuali.coeus.hr.impl.ImportError;

public class ImportStatus {
    private static final String ABORTED_MESSAGE = "Import aborted";
    private static final String ABNORMAL_MESSAGE = "Import terminated abnormally";
    private static final String COMPLETE_MESSAGE = "Import completed normally";
    private static final String PROCESSING_MESSAGE = "Import is processing";
    protected String id;
    protected Status status = Status.PROCESSING;
    protected int processed = 0;
    protected int total;
    protected List<ImportError> importErrors = new LinkedList<ImportError>();
    protected long startTime;
    protected long endTime = Long.MIN_VALUE;
    protected String detail = null;

    public ImportStatus(String importId, int totalRecords) {
        if (importId == null || importId.length() < 1) {
            throw new IllegalArgumentException("import id is required for ImportStatus");
        }
        this.id = importId;
        if (totalRecords < 0) {
            throw new IllegalArgumentException("Import status cannot have a negative number of records");
        }
        this.total = totalRecords;
        this.startTime = System.currentTimeMillis();
    }

    public synchronized String getImportId() {
        return this.id;
    }

    public synchronized void setStatus(Status status) {
        this.status = status;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public synchronized void recordProcessed() {
        this.recordProcessed(null);
    }

    public synchronized void recordProcessed(ImportError error) {
        if (!Status.PROCESSING.equals((Object)this.status)) {
            throw new IllegalStateException("Records cannot be processed when Import status is in " + this.status.toString() + " state");
        }
        if (error != null) {
            this.importErrors.add(error);
        }
        if (++this.processed == this.total) {
            this.endTime = System.currentTimeMillis();
            this.setStatus(Status.COMPLETE);
        }
    }

    public synchronized int getProcessedRecordCount() {
        return this.processed;
    }

    public synchronized int getErrorCount() {
        return this.importErrors.size();
    }

    public synchronized int getRecordTotal() {
        return this.total;
    }

    public synchronized long getStartTimeInMillis() {
        return this.startTime;
    }

    public synchronized long getEndTimeInMillis() {
        return this.endTime;
    }

    public synchronized void setMessageDetail(String detail) {
        this.detail = detail;
    }

    public synchronized String getMessage() {
        StringBuilder message = new StringBuilder();
        switch (this.status.ordinal()) {
            case 0: {
                message.append(PROCESSING_MESSAGE);
                break;
            }
            case 1: {
                message.append(COMPLETE_MESSAGE);
                break;
            }
            case 2: {
                message.append(ABORTED_MESSAGE);
                break;
            }
            case 3: {
                message.append(ABNORMAL_MESSAGE);
            }
        }
        if (this.detail != null) {
            message.append(':').append(this.detail);
        }
        return message.toString();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        long ending = Status.PROCESSING.equals((Object)this.status) ? System.currentTimeMillis() : this.endTime;
        sb.append("Import ").append(this.id).append(" status: ").append(this.status.toString()).append(" [ processed: ").append(this.processed).append("/").append(this.total).append(", errors: ").append(this.importErrors.size()).append(", time: ").append((float)(ending - this.startTime) / 1000.0f).append(" ]");
        return sb.toString();
    }

    public synchronized void setStartTimeInMillis(long time) {
        this.startTime = time;
    }

    public synchronized void setEndTimeInMillis(long time) {
        this.endTime = time;
    }

    public synchronized void setProcessed(int num) {
        this.processed = num;
    }

    public void setErrors(List<ImportError> errors) {
        this.importErrors = errors;
    }

    public List<ImportError> getErrors() {
        return this.importErrors;
    }

    public static enum Status {
        PROCESSING,
        COMPLETE,
        ABORTED,
        ABNORMAL_TERMINATION;

    }
}

