/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.compliance.core.ProtocolsFundedByService;
import org.kuali.coeus.common.framework.compliance.core.SaveDocumentSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewRule;
import org.kuali.coeus.common.framework.compliance.exemption.ExemptionType;
import org.kuali.coeus.common.framework.custom.CustomDataUtils;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocValue;
import org.kuali.coeus.common.framework.keyword.ScienceKeyword;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.workflow.SaveDocumentAdhocRoutingEvent;
import org.kuali.coeus.common.notification.impl.bo.KcNotification;
import org.kuali.coeus.common.notification.impl.bo.NotificationType;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.propdev.api.s2s.S2sFormConfigurationContract;
import org.kuali.coeus.propdev.api.s2s.S2sFormConfigurationService;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.auth.perm.ProposalDevelopmentPermissionsService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.propdev.impl.docperm.ProposalRoleTemplateService;
import org.kuali.coeus.propdev.impl.docperm.ProposalUserRoles;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.keyword.PropScienceKeyword;
import org.kuali.coeus.propdev.impl.lock.ProposalLockService;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotification;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationRenderer;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiographyService;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.s2s.S2sMultiProjectComponent;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunityCfda;
import org.kuali.coeus.propdev.impl.s2s.S2sSubmissionService;
import org.kuali.coeus.propdev.impl.s2s.connect.OpportunitySchemaParserService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewAttachment;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewExemption;
import org.kuali.coeus.propdev.impl.sponsor.AddProposalSponsorAndProgramInformationEvent;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.coeus.sys.framework.controller.KcCommonControllerService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.coeus.sys.impl.validation.DataValidationItem;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.document.TransactionalDocumentControllerService;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentAdHocService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.NavigationControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.ModelAndView;

public abstract class ProposalDevelopmentControllerBase {
    protected static final String PROPDEV_DEFAULT_VIEW_ID = "PropDev-DefaultView";
    public static final String ERROR_CERTIFICATION_PERSON_ALREADY_ANSWERED = "error.certification.person.alreadyAnswered";
    public static final String ERROR_CERTIFICATION_ALREADY_ANSWERED = "error.certification.alreadyAnswered";
    public static final String DEVELOPMENT_PROPOSAL_NUMBER = "developmentProposal.proposalNumber";
    @Autowired
    @Qualifier(value="krmsRulesExecutionService")
    private KrmsRulesExecutionService krmsRulesExecutionService;
    @Autowired
    @Qualifier(value="kcCommonControllerService")
    private KcCommonControllerService kcCommonControllerService;
    @Autowired
    @Qualifier(value="modelAndViewService")
    private ModelAndViewService modelAndViewService;
    @Autowired
    @Qualifier(value="navigationControllerService")
    private NavigationControllerService navigationControllerService;
    @Autowired
    @Qualifier(value="transactionalDocumentControllerService")
    private TransactionalDocumentControllerService transactionalDocumentControllerService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kraAuthorizationService;
    @Autowired
    @Qualifier(value="proposalDevelopmentService")
    private ProposalDevelopmentService proposalDevelopmentService;
    @Autowired
    @Qualifier(value="proposalDevelopmentPermissionsService")
    private ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService;
    @Autowired
    @Qualifier(value="legacyDataAdapter")
    private LegacyDataAdapter legacyDataAdapter;
    @Autowired
    @Qualifier(value="proposalRoleTemplateService")
    private ProposalRoleTemplateService proposalRoleTemplateService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="proposalPersonBiographyService")
    private ProposalPersonBiographyService proposalPersonBiographyService;
    @Autowired
    @Qualifier(value="documentAdHocService")
    private DocumentAdHocService documentAdHocService;
    @Autowired
    @Qualifier(value="auditHelper")
    private AuditHelper auditHelper;
    @Autowired
    @Qualifier(value="proposalLockService")
    private ProposalLockService proposalLockService;
    @Autowired
    @Qualifier(value="kcNotificationService")
    private KcNotificationService kcNotificationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="propDevProjectRetrievalService")
    private ProjectRetrievalService propDevProjectRetrievalService;
    @Autowired
    @Qualifier(value="proposalTypeService")
    private ProposalTypeService proposalTypeService;
    @Autowired
    @Qualifier(value="kualiRuleService")
    private KualiRuleService kualiRuleService;
    @Autowired
    @Qualifier(value="keyPersonnelService")
    private KeyPersonnelService keyPersonnelService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="s2sFormConfigurationService")
    private S2sFormConfigurationService s2sFormConfigurationService;
    @Autowired
    @Qualifier(value="s2sSubmissionService")
    private S2sSubmissionService s2sSubmissionService;
    @Autowired
    @Qualifier(value="projectPublisher")
    private ProjectPublisher projectPublisher;
    @Autowired
    @Qualifier(value="proposalHierarchyService")
    protected ProposalHierarchyService proposalHierarchyService;
    @Autowired
    @Qualifier(value="opportunitySchemaParserService")
    protected OpportunitySchemaParserService opportunitySchemaParserService;
    @Autowired
    @Qualifier(value="protocolsFundedByService")
    private ProtocolsFundedByService protocolsFundedByService;

    protected DocumentFormBase createInitialForm(HttpServletRequest request) {
        return new ProposalDevelopmentDocumentForm();
    }

    @ModelAttribute(value="KualiForm")
    public UifFormBase initForm(HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)this.getKcCommonControllerService().initForm((UifFormBase)this.createInitialForm(request), request, response);
        if (form.getProposalDevelopmentDocument() != null && form.getProposalDevelopmentDocument().getCustomDataList() != null) {
            for (CustomAttributeDocValue customData : form.getProposalDevelopmentDocument().getCustomDataList()) {
                customData.setDeserializedListValue(null);
            }
        }
        return form;
    }

    protected void initializeProposalUsers(ProposalDevelopmentDocument doc) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        if (!this.getKraAuthorizationService().hasDocumentLevelRole(userId, "Aggregator", doc)) {
            this.getKraAuthorizationService().addDocumentLevelRole(userId, "Aggregator", doc);
        }
        this.getProposalRoleTemplateService().addUsers(doc);
    }

    protected void initialSave(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.preSave(proposalDevelopmentDocument);
        this.proposalDevelopmentService.initializeUnitOrganizationLocation(proposalDevelopmentDocument);
        this.proposalDevelopmentService.initializeProposalSiteNumbers(proposalDevelopmentDocument);
    }

    protected void preSave(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        if (proposalDevelopmentDocument.isDefaultDocumentDescription()) {
            proposalDevelopmentDocument.setDefaultDocumentDescription();
        }
        proposalDevelopmentDocument.setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
        proposalDevelopmentDocument.setUpdateUser(this.getGlobalVariableService().getUserSession().getPrincipalName());
    }

    public ModelAndView save(ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.save(form);
    }

    public ModelAndView save(ProposalDevelopmentDocumentForm form) {
        ModelAndView view;
        String instProposalId;
        Object continuedFrom;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)form.getDocument();
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        this.syncS2sMultiProjectOpportunity(proposalDevelopmentDocument);
        if (StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-SupplementalPage")) {
            CustomDataUtils.processCustomDataBeforeSave(form.getProposalDevelopmentDocument().getCustomDataList());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-PermissionsPage")) {
            this.saveDocumentPermissions(form);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-CompliancePage")) {
            new SaveSpecialReviewRule<ProposalSpecialReview>().processRules(new SaveSpecialReviewEvent<ProposalSpecialReview>("document.developmentProposal.propSpecialReviews", proposalDevelopmentDocument, form.getDevelopmentProposal().getPropSpecialReviews(), form.getSpecialReviewHelper().getIsExportControlEnabled()));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-AttachmentsPage")) {
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateAttachmentReferences(form.getDevelopmentProposal());
        }
        if (StringUtils.isEmpty((CharSequence)form.getActionParamaterValue("navigateToPageId")) && StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-SponsorProgramInfoPage")) {
            this.kualiRuleService.applyRules((DocumentEvent)new AddProposalSponsorAndProgramInformationEvent("", proposalDevelopmentDocument));
        }
        if (this.getGlobalVariableService().getMessageMap().getErrorCount() == 0 && form.getEditableCollectionLines() != null) {
            form.getEditableCollectionLines().clear();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-DetailsPage")) {
            this.handleProposalTypeChange(developmentProposal);
            this.handleSponsorChange(proposalDevelopmentDocument);
            if (developmentProposal.getS2sOpportunity() != null) {
                this.handleProposalTypeChangeForOpp(developmentProposal);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)form.getDevelopmentProposal().getContinuedFrom()) && StringUtils.isEmpty((CharSequence)form.getDevelopmentProposal().getPrevGrantsGovTrackingID()) && form.getDevelopmentProposal().getS2sOpportunity() != null && "3".equals(form.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode()) && (continuedFrom = this.getContinuedFromDevelopmentProposal(instProposalId = this.getInstitutionalProposalId(form.getDevelopmentProposal().getContinuedFrom()))) != null && CollectionUtils.isNotEmpty(((DevelopmentProposal)continuedFrom).getS2sAppSubmission())) {
            String ggTrackingId = ((DevelopmentProposal)continuedFrom).getS2sAppSubmission().get(((DevelopmentProposal)continuedFrom).getS2sAppSubmission().size() - 1).getGgTrackingId();
            form.getDevelopmentProposal().setPrevGrantsGovTrackingID(ggTrackingId);
        }
        List<ProposalSpecialReview> deletedReviews = this.getDeletedSpecialReviews(Optional.ofNullable(developmentProposal.getProposalNumber()).map(proposalNumber -> (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, proposalNumber)).map(DevelopmentProposal::getPropSpecialReviews).orElse(Collections.emptyList()), developmentProposal.getPropSpecialReviews());
        this.preSave(proposalDevelopmentDocument);
        developmentProposal.getPropSpecialReviews().stream().filter(proposalSpecialReview -> proposalSpecialReview.getSpecialReviewAttachment() != null).forEach(this::prepareSpecialReviewAttachmentForSave);
        this.proposalDevelopmentService.initializeUnitOrganizationLocation(proposalDevelopmentDocument);
        this.proposalDevelopmentService.initializeProposalSiteNumbers(proposalDevelopmentDocument);
        for (ProposalPersonBiography biography : form.getDevelopmentProposal().getPropPersonBios()) {
            this.getProposalPersonBiographyService().prepareProposalPersonBiographyForSave(form.getDevelopmentProposal(), biography);
        }
        ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).setOrdinalPosition(form.getDevelopmentProposal().getProposalPersons());
        this.saveAnswerHeaderIfNotLocked(form);
        if (form.getDevelopmentProposal().getProposalNumber() == null) {
            this.createFromOpportunitySave(form);
        } else {
            this.getTransactionalDocumentControllerService().save((DocumentFormBase)form, (SaveDocumentEvent)new SaveDocumentAdhocRoutingEvent(proposalDevelopmentDocument, form.getPageId()));
        }
        DevelopmentProposal finalDevelopmentProposal = form.getDevelopmentProposal();
        if (form.isAuditActivated()) {
            this.getAuditHelper().auditConditionally(form);
        }
        this.populateAdHocRecipients(proposalDevelopmentDocument);
        this.prepareNarratives(form);
        if (StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-CreditAllocationPage")) {
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateCreditSplits(form);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-QuestionnairePage")) {
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateQuestionnaires(form);
        }
        if (StringUtils.isNotBlank((CharSequence)form.getActionParamaterValue("navigateToPageId")) && this.getGlobalVariableService().getMessageMap().hasNoErrors()) {
            form.setDirtyForm(false);
            view = this.getModelAndViewService().getModelAndView((UifFormBase)form, form.getActionParamaterValue("navigateToPageId"));
        } else {
            view = this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        if (form.getSpecialReviewHelper().getIsExportControlEnabled()) {
            form.getSpecialReviewHelper().syncProtocolReferences(finalDevelopmentProposal.getPropSpecialReviews(), finalDevelopmentProposal.getProposalNumber(), finalDevelopmentProposal.getTitle(), deletedReviews);
            if (finalDevelopmentProposal.getPropSpecialReviews() != null) {
                finalDevelopmentProposal.getPropSpecialReviews().stream().filter(specialReview -> !specialReview.isLinkedToProtocol()).forEach(specialReview -> form.getSpecialReviewHelper().prepareProtocolLinkViewFields(specialReview));
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)form.getPageId(), (CharSequence)"PropDev-QuestionnairePage")) {
            this.onProposalAnswersSaved(finalDevelopmentProposal);
        }
        this.sendKrmsOnSaveKcNotifications(finalDevelopmentProposal.getProposalDocument());
        Project project = this.getPropDevProjectRetrievalService().retrieveProject(finalDevelopmentProposal.getProposalNumber());
        if (project != null) {
            this.getProjectPublisher().publishProject(project);
        }
        return view;
    }

    private void sendKrmsOnSaveKcNotifications(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        boolean sendKrmsOnSaveKcNotifications = this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "SEND_KRMS_ON_SAVE_KC_NOTIFICATIONS");
        if (sendKrmsOnSaveKcNotifications) {
            DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
            Set<String> notifications = this.getKrmsRulesExecutionService().processUnitKcNotifications(developmentProposal.getAllUnitNumbers(), proposalDevelopmentDocument);
            notifications.stream().map(notificationId -> (NotificationType)this.getBusinessObjectService().findBySinglePrimaryKey(NotificationType.class, notificationId)).forEach(notificationType -> {
                ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(developmentProposal, notificationType.getActionCode(), notificationType.getSubject());
                context.getRenderer().setDevelopmentProposal(developmentProposal);
                this.getKcNotificationService().sendUniqueNotificationAndPersist(context, new ProposalDevelopmentNotification(), developmentProposal);
            });
        }
    }

    protected void prepareNarratives(ProposalDevelopmentDocumentForm form) {
        DevelopmentProposal developmentProposal = form.getProposalDevelopmentDocument().getDevelopmentProposal();
        OptionalInt minModuleSequenceNumber = developmentProposal.getNarrativesMinModuleSequenceNumber();
        OptionalInt maxModuleSequenceNumber = developmentProposal.getNarrativesMaxModuleSequenceNumber();
        List<Narrative> narratives = form.getProposalDevelopmentDocument().getDevelopmentProposal().getNarratives();
        for (Narrative narrative : narratives) {
            narrative.setMoveUpAllowed(maxModuleSequenceNumber.isPresent() && narrative.getModuleSequenceNumber() < maxModuleSequenceNumber.getAsInt());
            narrative.setMoveDownAllowed(minModuleSequenceNumber.isPresent() && narrative.getModuleSequenceNumber() > minModuleSequenceNumber.getAsInt());
        }
    }

    private List<ProposalSpecialReview> getDeletedSpecialReviews(List<ProposalSpecialReview> previousReviews, List<ProposalSpecialReview> currentReviews) {
        return previousReviews.stream().filter(psr -> !currentReviews.contains(psr)).collect(Collectors.toList());
    }

    protected void setPersonnelLockWarnings(ProposalDevelopmentDocumentForm form) {
        List<PessimisticLock> personnelLocks = this.getPersonnelLocks(form);
        form.getDevelopmentProposal().getProposalPersons().forEach(person -> personnelLocks.stream().filter(personnelLock -> ProposalLockService.isLockForPerson(personnelLock, person)).findFirst().ifPresent(personnelLock -> {
            KcPerson lockOwner = this.getKcPersonService().getKcPersonByPersonId(personnelLock.getOwnedByPrincipalIdentifier());
            this.getGlobalVariableService().getMessageMap().putWarningForSectionId("GLOBAL_ERRORS", "kc.warning.transactional.locked.personnel", new String[]{person.getFullName(), lockOwner.getFullName()});
        }));
    }

    protected String getInstitutionalProposalId(String instProposalNumber) {
        List institutionalProposals = this.getLegacyDataAdapter().findMatching(InstitutionalProposal.class, Collections.singletonMap("proposalNumber", instProposalNumber));
        if (CollectionUtils.isNotEmpty((Collection)institutionalProposals)) {
            return String.valueOf(((InstitutionalProposal)institutionalProposals.get(0)).getProposalId());
        }
        return "";
    }

    protected DevelopmentProposal getContinuedFromDevelopmentProposal(String instProposalId) {
        List details = this.getLegacyDataAdapter().findMatching(ProposalAdminDetails.class, Collections.singletonMap("instProposalId", instProposalId));
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            return (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)((ProposalAdminDetails)details.get(0)).getDevProposalNumber());
        }
        return null;
    }

    protected void createFromOpportunitySave(ProposalDevelopmentDocumentForm form) {
        List<ProposalCfda> proposalCfdas;
        List<Object> s2sOpportunityCfdas;
        if (form.getDevelopmentProposal().hasS2sOpportunity() && form.getDevelopmentProposal().getS2sOpportunity().getS2sOpportunityCfdas() != null) {
            s2sOpportunityCfdas = form.getDevelopmentProposal().getS2sOpportunity().getS2sOpportunityCfdas();
            form.getDevelopmentProposal().getS2sOpportunity().setS2sOpportunityCfdas(new ArrayList<S2sOpportunityCfda>());
        } else {
            s2sOpportunityCfdas = new ArrayList();
        }
        if (form.getDevelopmentProposal().getProposalCfdas() != null) {
            proposalCfdas = form.getDevelopmentProposal().getProposalCfdas();
            form.getDevelopmentProposal().setProposalCfdas(new ArrayList<ProposalCfda>());
        } else {
            proposalCfdas = new ArrayList<ProposalCfda>();
        }
        this.getTransactionalDocumentControllerService().save((DocumentFormBase)form);
        if (form.getDevelopmentProposal().hasS2sOpportunity()) {
            s2sOpportunityCfdas.forEach(cfda -> cfda.setProposalNumber(form.getDevelopmentProposal().getProposalNumber()));
            form.getDevelopmentProposal().getS2sOpportunity().setS2sOpportunityCfdas(s2sOpportunityCfdas);
        }
        proposalCfdas.forEach(cfda -> cfda.setProposalNumber(form.getDevelopmentProposal().getProposalNumber()));
        form.getDevelopmentProposal().setProposalCfdas(proposalCfdas);
        this.getTransactionalDocumentControllerService().save((DocumentFormBase)form);
    }

    protected void prepareSpecialReviewAttachmentForSave(ProposalSpecialReview specialReview) {
        ProposalSpecialReviewAttachment specialReviewAttachment = specialReview.getSpecialReviewAttachment();
        if (specialReviewAttachment.getMultipartFile() != null) {
            try {
                specialReviewAttachment.init(specialReviewAttachment.getMultipartFile());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (specialReviewAttachment.getId() != null && !"1".equals(specialReview.getSpecialReviewTypeCode())) {
            specialReview.setSpecialReviewAttachment(null);
        }
    }

    public void saveAnswerHeaderIfNotLocked(ProposalDevelopmentDocumentForm form) {
        String pageId = form.getPageId();
        String navigateToPageId = form.getActionParamaterValue("navigateToPageId");
        if (StringUtils.equalsIgnoreCase((CharSequence)pageId, (CharSequence)"PropDev-PersonnelPage") || StringUtils.equalsIgnoreCase((CharSequence)pageId, (CharSequence)"PropDev-CertificationView-Page")) {
            this.saveUpdatePersonAnswerHeaders(form, pageId);
            if (StringUtils.equalsIgnoreCase((CharSequence)pageId, (CharSequence)"PropDev-PersonnelPage") && (StringUtils.isBlank((CharSequence)navigateToPageId) || navigateToPageId.equals(pageId))) {
                this.setPersonnelLockWarnings(form);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)pageId, (CharSequence)"PropDev-QuestionnairePage")) {
            this.saveUpdateQuestionnaireAnswerHeaders(form.getQuestionnaireHelper(), pageId);
            this.saveUpdateQuestionnaireAnswerHeaders(form.getS2sQuestionnaireHelper(), pageId);
        }
    }

    void syncS2sMultiProjectOpportunity(ProposalDevelopmentDocument developmentProposalDocument) {
        DevelopmentProposal parent;
        DevelopmentProposal developmentProposal = developmentProposalDocument.getDevelopmentProposal();
        if (developmentProposal.isChild() && (parent = developmentProposal.getParent()).isMultiProjectParent()) {
            this.updateChildOpportunityFromParent(developmentProposal.getParent(), developmentProposal, null);
        }
    }

    protected List<PessimisticLock> getPersonnelLocks(ProposalDevelopmentDocumentForm form) {
        return this.getProposalLockService().getPersonnelLocks(form.getProposalDevelopmentDocument().getDocumentNumber());
    }

    protected void releaseLocksForLoggedInUser(ProposalDevelopmentDocumentForm form) {
        if (form.getProposalDevelopmentDocument().getPessimisticLocks() != null) {
            this.getProposalLockService().releaseAllLocksForUser(form.getProposalDevelopmentDocument().getPessimisticLocks(), this.getGlobalVariableService().getUserSession().getPerson());
        }
    }

    private void handleProposalTypeChange(DevelopmentProposal developmentProposal) {
        String newType = this.getProposalTypeService().getNewProposalTypeCode();
        if (newType.equals(developmentProposal.getProposalTypeCode())) {
            developmentProposal.setCurrentAwardNumber(null);
            developmentProposal.setContinuedFrom(null);
        }
    }

    private void handleProposalTypeChangeForOpp(DevelopmentProposal developmentProposal) {
        if (developmentProposal.hasS2sOpportunity()) {
            String defaultS2sSubmissionTypeCode = this.getProposalTypeService().getDefaultSubmissionTypeCode(developmentProposal.getProposalTypeCode());
            developmentProposal.getS2sOpportunity().setS2sSubmissionTypeCode(defaultS2sSubmissionTypeCode);
            this.getDataObjectService().wrap((Object)developmentProposal.getS2sOpportunity()).fetchRelationship("s2sSubmissionType");
        }
    }

    public ModelAndView save(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response, Class<? extends DocumentEventBase> eventClazz) {
        Project project;
        ModelAndView view;
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)pdForm.getDocument();
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        List<ProposalSpecialReview> deletedReviews = this.getDeletedSpecialReviews(Optional.ofNullable((DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)developmentProposal.getProposalNumber())).map(DevelopmentProposal::getPropSpecialReviews).orElse(Collections.emptyList()), developmentProposal.getPropSpecialReviews());
        this.proposalDevelopmentService.initializeUnitOrganizationLocation(proposalDevelopmentDocument);
        this.proposalDevelopmentService.initializeProposalSiteNumbers(proposalDevelopmentDocument);
        if (eventClazz == null) {
            this.getTransactionalDocumentControllerService().save(form);
        } else {
            this.performCustomSave((DocumentBase)proposalDevelopmentDocument, SaveDocumentSpecialReviewEvent.class);
        }
        this.populateAdHocRecipients(pdForm.getProposalDevelopmentDocument());
        String pageId = form.getActionParamaterValue("navigateToPageId");
        if (StringUtils.isNotBlank((CharSequence)pageId) && this.getGlobalVariableService().getMessageMap().hasNoErrors()) {
            form.setDirtyForm(false);
            view = this.getModelAndViewService().getModelAndView((UifFormBase)form, pageId);
        } else {
            view = this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        if (pdForm.getSpecialReviewHelper().getIsExportControlEnabled()) {
            pdForm.getSpecialReviewHelper().syncProtocolReferences(developmentProposal.getPropSpecialReviews(), developmentProposal.getProposalNumber(), developmentProposal.getTitle(), deletedReviews);
            if (developmentProposal.getPropSpecialReviews() != null) {
                developmentProposal.getPropSpecialReviews().stream().filter(specialReview -> !specialReview.isLinkedToProtocol()).forEach(specialReview -> pdForm.getSpecialReviewHelper().prepareProtocolLinkViewFields(specialReview));
            }
        }
        if ((project = this.getPropDevProjectRetrievalService().retrieveProject(pdForm.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalNumber())) != null) {
            this.getProjectPublisher().publishProject(project);
        }
        return view;
    }

    protected void performCustomSave(DocumentBase document, Class<? extends DocumentEventBase> eventClazz) {
        try {
            this.getDocumentService().saveDocument((Document)document, eventClazz);
            GlobalVariables.getMessageMap().putInfo("GlobalMessages", "message.saved", new String[0]);
        }
        catch (ValidationException e) {
            if (GlobalVariables.getMessageMap().hasNoErrors()) {
                throw new RiceRuntimeException("Validation Exception with no error message.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RiceRuntimeException("Exception trying to save document: " + document.getDocumentNumber(), (Throwable)e);
        }
    }

    protected ModelAndView navigate(ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        DevelopmentProposal developmentProposal = form.getDevelopmentProposal();
        if (developmentProposal.hasS2sOpportunity() && !this.getProposalDevelopmentService().isGrantsGovEnabledForProposal(developmentProposal)) {
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).clearOpportunity(developmentProposal);
        }
        this.populateAdHocRecipients(form.getProposalDevelopmentDocument());
        String navigateToPageId = form.getActionParamaterValue("navigateToPageId");
        if (this.isNavigateToDeliveryInfoPage(navigateToPageId) && developmentProposal.hasS2sOpportunity()) {
            this.getGlobalVariableService().getMessageMap().putInfo("PropDev-DeliveryInfoPage", "message.proposalDevelopment.delivery.info.not.needed", new String[0]);
        }
        if (developmentProposal.getPropSpecialReviews() != null) {
            developmentProposal.getPropSpecialReviews().stream().filter(specialReview -> !specialReview.isLinkedToProtocol()).forEach(specialReview -> form.getSpecialReviewHelper().prepareProtocolLinkViewFields(specialReview));
        }
        if (this.isNavigateToCompliancePage(navigateToPageId)) {
            form.setProtocolsFundedBy(this.getProtocolsFundedByService().getProtocolsFundedByProject("ProposalDevelopment", form.getDevelopmentProposal().getProposalNumber()));
        }
        this.prepareNarratives(form);
        boolean pageIsDirty = Boolean.parseBoolean(form.getActionParamaterValue("pageIsDirty"));
        if ((form.isCanEditView().booleanValue() || ((Boolean)form.getEditModes().get("canSaveCertification")).booleanValue() || ((Boolean)form.getEditModes().get("modifyS2s")).booleanValue() || ((Boolean)form.getEditModes().get("overridePDComplianceEntry")).booleanValue()) && (!this.documentIsInRoute(form) && !this.documentIsFinal(form) || this.documentIsInRoute(form) && pageIsDirty)) {
            return this.save(form);
        }
        return this.getNavigationControllerService().navigate((UifFormBase)form);
    }

    protected boolean documentIsInRoute(ProposalDevelopmentDocumentForm form) {
        return form.getDocument().getDocumentHeader().getWorkflowDocument().isEnroute();
    }

    protected boolean documentIsFinal(ProposalDevelopmentDocumentForm form) {
        return form.getDocument().getDocumentHeader().getWorkflowDocument().isFinal();
    }

    protected boolean isNavigateToDeliveryInfoPage(String navigateToPageId) {
        return StringUtils.equals((CharSequence)navigateToPageId, (CharSequence)"PropDev-DeliveryInfoPage");
    }

    protected boolean isNavigateToCompliancePage(String navigateToPageId) {
        return StringUtils.equals((CharSequence)navigateToPageId, (CharSequence)"PropDev-CompliancePage");
    }

    public void addEditableCollectionLine(ProposalDevelopmentDocumentForm form, String selectedCollectionPath) {
        if (form.getEditableCollectionLines().containsKey(selectedCollectionPath)) {
            this.updateEditableCollectionLines(form, selectedCollectionPath);
        } else {
            ArrayList<String> newKeyList = new ArrayList<String>();
            newKeyList.add("0");
            form.getEditableCollectionLines().put(selectedCollectionPath, newKeyList);
        }
    }

    public void updateEditableCollectionLines(ProposalDevelopmentDocumentForm form, String selectedCollectionPath) {
        ArrayList<String> indexes = new ArrayList<String>();
        indexes.add("0");
        for (String index : form.getEditableCollectionLines().get(selectedCollectionPath)) {
            int newIndex = Integer.parseInt(index) + 1;
            indexes.add(Integer.toString(newIndex));
        }
        form.getEditableCollectionLines().get(selectedCollectionPath).clear();
        form.getEditableCollectionLines().get(selectedCollectionPath).addAll(indexes);
    }

    protected KcAuthorizationService getKraAuthorizationService() {
        return this.kraAuthorizationService;
    }

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected ProposalDevelopmentService getProposalDevelopmentService() {
        return this.proposalDevelopmentService;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }

    protected TransactionalDocumentControllerService getTransactionalDocumentControllerService() {
        return this.transactionalDocumentControllerService;
    }

    public void setTransactionalDocumentControllerService(TransactionalDocumentControllerService transactionalDocumentControllerService) {
        this.transactionalDocumentControllerService = transactionalDocumentControllerService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    protected ProposalRoleTemplateService getProposalRoleTemplateService() {
        return this.proposalRoleTemplateService;
    }

    public void setProposalRoleTemplateService(ProposalRoleTemplateService proposalRoleTemplateService) {
        this.proposalRoleTemplateService = proposalRoleTemplateService;
    }

    protected DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected void saveUpdatePersonAnswerHeaders(ProposalDevelopmentDocumentForm form, String pageId) {
        DevelopmentProposal developmentProposal = form.getProposalDevelopmentDocument().getDevelopmentProposal();
        boolean allCertificationsWereComplete = true;
        boolean allCertificationAreNowComplete = true;
        List<PessimisticLock> personnelLocks = this.getProposalLockService().getPersonnelLocks(developmentProposal.getProposalDocument().getDocumentNumber());
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            boolean isPersonLocked = personnelLocks.stream().anyMatch(lock -> ProposalLockService.isLockForPerson(lock, person));
            if (person.getQuestionnaireHelper() == null || person.getQuestionnaireHelper().getAnswerHeaders() == null || person.getQuestionnaireHelper().getAnswerHeaders().isEmpty() || !person.needsCertification() || isPersonLocked) continue;
            boolean requiresUpdate = false;
            for (AnswerHeader answerHeader : person.getQuestionnaireHelper().getAnswerHeaders()) {
                boolean wasComplete = answerHeader.isCompleted();
                allCertificationsWereComplete &= wasComplete;
                AnswerHeader currentAnswerHeader = this.retrieveCurrentAnswerHeader(answerHeader.getId());
                if (currentAnswerHeader != null && currentAnswerHeader.getVersionNumber() > answerHeader.getVersionNumber()) {
                    this.getGlobalVariableService().getMessageMap().putError(pageId, ERROR_CERTIFICATION_PERSON_ALREADY_ANSWERED, new String[]{answerHeader.getQuestionnaire().getName(), person.getFullName()});
                    this.updatePersonCertificationInfo(person, developmentProposal.getProposalNumber());
                    requiresUpdate = true;
                    continue;
                }
                boolean sameAnswers = this.isCertificationReadOnly(form, person) || this.answersIncompleteOrUnchanged(answerHeader, currentAnswerHeader);
                this.getLegacyDataAdapter().save((Object)answerHeader);
                person.getQuestionnaireHelper().populateAnswers();
                boolean isComplete = person.getQuestionnaireHelper().getAnswerHeaders().get(0).isCompleted();
                allCertificationAreNowComplete &= isComplete;
                if (isComplete && !wasComplete || !sameAnswers) {
                    this.keyPersonnelService.saveCertDetails(person, this.getGlobalVariableService().getUserSession().getPrincipalId(), this.getDateTimeService().getCurrentTimestamp());
                } else if (wasComplete && !isComplete) {
                    this.keyPersonnelService.saveCertDetails(person, null, null);
                }
                this.onProposalPersonCertAnswersSaved(developmentProposal, person);
                this.checkForCertifiedByProxy(developmentProposal, person, isComplete && !wasComplete);
            }
            if (!requiresUpdate) continue;
            person.getQuestionnaireHelper().populateAnswers();
        }
        developmentProposal.setProposalPersons(developmentProposal.getProposalPersons().stream().map(arg_0 -> ProposalDevelopmentControllerBase.lambda$saveUpdatePersonAnswerHeaders$17(this.getDataObjectService(), arg_0)).collect(Collectors.toList()));
        if (!allCertificationsWereComplete && allCertificationAreNowComplete) {
            this.sendAllCertificationCompleteNotificationIfEnabled(developmentProposal);
        }
    }

    protected boolean isCertificationReadOnly(ProposalDevelopmentDocumentForm form, ProposalPerson person) {
        return ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).isCertificationReadOnly(person);
    }

    protected void onProposalAnswersSaved(DevelopmentProposal developmentProposal) {
        List<ProposalPerson> proposalPersons = developmentProposal.getProposalPersons();
        this.getProposalDevelopmentService().updateCanPersonsPassivelyDiscloseCois(developmentProposal, proposalPersons);
        developmentProposal.setProposalPersons(proposalPersons.stream().map(p -> (ProposalPerson)this.getDataObjectService().save(p, new PersistenceOption[]{PersistenceOption.FLUSH})).collect(Collectors.toList()));
    }

    protected void onProposalPersonCertAnswersSaved(DevelopmentProposal developmentProposal, ProposalPerson person) {
        this.getProposalDevelopmentService().updateCanPersonsPassivelyDiscloseCois(developmentProposal, Collections.singletonList(person));
    }

    protected void sendAllCertificationCompleteNotificationIfEnabled(DevelopmentProposal developmentProposal) {
        boolean allowsSendCertificationCompleteNotification = this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "notifyAggregatorWhenAllCertificationsComplete");
        if (allowsSendCertificationCompleteNotification) {
            ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(developmentProposal, "105", "All Proposal Persons Certification Completed");
            context.getRenderer().setDevelopmentProposal(developmentProposal);
            this.getKcNotificationService().sendNotificationAndPersist(context, new ProposalDevelopmentNotification(), developmentProposal);
        }
    }

    protected boolean answersIncompleteOrUnchanged(AnswerHeader newAnswerHeader, AnswerHeader currentAnswerHeader) {
        if (newAnswerHeader == null || currentAnswerHeader == null || newAnswerHeader.getAnswers() == null && currentAnswerHeader.getAnswers() == null) {
            return Boolean.TRUE;
        }
        if (newAnswerHeader.isCompleted()) {
            if (currentAnswerHeader.getAnswers() == null || newAnswerHeader.getAnswers() == null) {
                return Boolean.FALSE;
            }
            for (Answer answer : newAnswerHeader.getAnswers()) {
                Optional foundAnswer;
                Optional<Object> optional = foundAnswer = answer != null ? currentAnswerHeader.getAnswers().stream().filter(a -> Objects.equals(answer.getId(), a.getId())).findFirst() : Optional.empty();
                if (foundAnswer.isPresent()) {
                    if (!this.answerIsDifferent((Answer)foundAnswer.get(), answer)) continue;
                    return Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    protected boolean answerIsDifferent(Answer currentAnswer, Answer newAnswer) {
        if (currentAnswer == null && newAnswer == null) {
            return Boolean.FALSE;
        }
        if (currentAnswer == null || newAnswer == null) {
            return Boolean.TRUE;
        }
        if (currentAnswer.getAnswer() == null && newAnswer.getAnswer() == null) {
            return Boolean.FALSE;
        }
        return currentAnswer.getAnswer() == null || newAnswer.getAnswer() == null || currentAnswer.getQuestionId().equals(newAnswer.getQuestionId()) && !newAnswer.getAnswer().equalsIgnoreCase(currentAnswer.getAnswer());
    }

    protected List<NotificationTypeRecipient> createRecipientFromPerson(ProposalPerson person) {
        ArrayList<NotificationTypeRecipient> notificationRecipients = new ArrayList<NotificationTypeRecipient>();
        NotificationTypeRecipient recipient = new NotificationTypeRecipient();
        recipient.setPersonId(person.getPersonId());
        recipient.setFullName(person.getFullName());
        notificationRecipients.add(recipient);
        return notificationRecipients;
    }

    private void saveUpdateQuestionnaireAnswerHeaders(ProposalDevelopmentQuestionnaireHelper questionnaireHelper, String pageId) {
        boolean requiresUpdate = false;
        for (AnswerHeader answerHeader : questionnaireHelper.getAnswerHeaders()) {
            AnswerHeader currentAnswerHeader = this.retrieveCurrentAnswerHeader(answerHeader.getId());
            if (currentAnswerHeader != null && currentAnswerHeader.getVersionNumber() > answerHeader.getVersionNumber()) {
                this.getGlobalVariableService().getMessageMap().putError(pageId, ERROR_CERTIFICATION_ALREADY_ANSWERED, new String[]{answerHeader.getQuestionnaire().getName()});
                requiresUpdate = true;
                continue;
            }
            this.getLegacyDataAdapter().save((Object)answerHeader);
        }
        if (requiresUpdate) {
            questionnaireHelper.populateAnswers();
        }
    }

    protected AnswerHeader retrieveCurrentAnswerHeader(Long id) {
        if (id != null) {
            return (AnswerHeader)this.getBusinessObjectService().findByPrimaryKey(AnswerHeader.class, Collections.singletonMap("id", id));
        }
        return null;
    }

    private void updatePersonCertificationInfo(ProposalPerson person, String proposalNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(DEVELOPMENT_PROPOSAL_NUMBER, proposalNumber);
        QueryResults currentPersons = this.getDataObjectService().findMatching(ProposalPerson.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        for (ProposalPerson currentPerson : currentPersons.getResults()) {
            if (!currentPerson.getUniqueId().equals(person.getUniqueId())) continue;
            this.keyPersonnelService.saveCertDetails(person, currentPerson.getCertificationDetails().getCertifiedBy(), currentPerson.getCertificationDetails().getCertifiedTime());
            break;
        }
    }

    public void checkForCertifiedByProxy(DevelopmentProposal developmentProposal, ProposalPerson person, boolean recentlyCompleted) {
        if (this.selfCertifyOnly().booleanValue()) {
            String proxyId = this.getGlobalVariableService().getUserSession().getPrincipalId();
            if (!StringUtils.equals((CharSequence)person.getPersonId(), (CharSequence)proxyId) && recentlyCompleted) {
                ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(developmentProposal, "106", "Proposal Person Certification Completed");
                if (this.getKcNotificationService().isNotificationTypeActive(context)) {
                    context.getRenderer().setDevelopmentProposal(developmentProposal);
                    context.getRenderer().setProposalPerson(person);
                    KcNotification notification = this.getKcNotificationService().createNotificationObject(context);
                    NotificationTypeRecipient recipient = new NotificationTypeRecipient();
                    recipient.setPersonId(person.getPersonId());
                    this.getKcNotificationService().sendNotificationAndPersist(context, new ProposalDevelopmentNotification(notification), Collections.singletonList(recipient), developmentProposal);
                }
            }
        }
    }

    public Boolean selfCertifyOnly() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "KEY_PERSON_CERTIFICATION_SELF_CERTIFY_ONLY");
    }

    public void saveDocumentPermissions(ProposalDevelopmentDocumentForm pdForm) {
        List<String> editableLines = pdForm.getEditableCollectionLines().get("permissionsHelper.workingUserRoles");
        if (editableLines != null && !editableLines.isEmpty()) {
            this.getGlobalVariableService().getMessageMap().putErrorForSectionId("PropDev-PermissionsPage-UserTable", "error.unsaved.permissions", new String[0]);
        } else if (this.arePermissionsValid(pdForm.getProposalDevelopmentDocument(), pdForm.getWorkingUserRoles())) {
            this.getProposalDevelopmentPermissionsService().savePermissions(pdForm.getProposalDevelopmentDocument(), this.getProposalDevelopmentPermissionsService().getPermissions(pdForm.getProposalDevelopmentDocument()), pdForm.getWorkingUserRoles());
        }
    }

    protected boolean arePermissionsValid(ProposalDevelopmentDocument document, List<ProposalUserRoles> proposalUsers) {
        boolean retVal = true;
        for (ProposalUserRoles proposalUser : proposalUsers) {
            retVal &= this.getProposalDevelopmentPermissionsService().validateUpdatePermissions(document, proposalUsers, proposalUser);
        }
        return retVal;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(List.class, "document.developmentProposal.propScienceKeywords", (PropertyEditor)((Object)new PropScienceKeywordEditor()));
        binder.registerCustomEditor(List.class, "document.developmentProposal.propSpecialReviews.specialReviewExemptions", (PropertyEditor)((Object)new PropSpecialReviewExemptionTypeEditor()));
        binder.registerCustomEditor(List.class, "newCollectionLines.specialReviewExemptions", (PropertyEditor)((Object)new PropSpecialReviewExemptionTypeEditor()));
    }

    protected NotificationTypeRecipient createRecipientFromPerson(String personId) {
        NotificationTypeRecipient recipient = new NotificationTypeRecipient();
        recipient.setPersonId(personId);
        return recipient;
    }

    protected void handleNotification(ProposalDevelopmentDocumentForm form, String notificationS2sSubmitActionCode, String notificationS2sSubmitContextName) {
        ProposalDevelopmentNotificationRenderer renderer = KcServiceLocator.getService(ProposalDevelopmentNotificationRenderer.class);
        renderer.setDevelopmentProposal(form.getDevelopmentProposal());
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        ProposalDevelopmentNotificationContext notificationContext = new ProposalDevelopmentNotificationContext(proposalDevelopmentDocument.getDevelopmentProposal(), notificationS2sSubmitActionCode, notificationS2sSubmitContextName, renderer);
        form.getNotificationHelper().setNotificationContext(notificationContext);
        form.getNotificationHelper().initializeDefaultValues(notificationContext);
        String step = form.getNotificationHelper().getNotificationRecipients().isEmpty() ? "0" : "2";
        form.getActionParameters().put("Kc-SendNotification-Wizard.step", step);
        form.getNotificationHelper().setNotificationStep(Integer.parseInt(step));
    }

    protected void setAndValidateMandatoryForms(DevelopmentProposal proposal) {
        S2sOpportunity s2sOpportunity = proposal.getS2sOpportunity();
        try {
            if (s2sOpportunity != null && s2sOpportunity.getSchemaUrl() != null) {
                boolean multiProjectEnabled = this.parameterService.getParameterValueAsBoolean("KC-S2S", "All", "Enable_Multi_Project_Support");
                if (s2sOpportunity.isMultiProject() && !multiProjectEnabled) {
                    throw new S2sCommunicationException("error.grantsgov.no.form.element", "", "");
                }
                if (s2sOpportunity.isMultiProject() && !proposal.isParent()) {
                    throw new S2sCommunicationException("error.grantsgov.multiproject.parent.required", "");
                }
                if (s2sOpportunity.isMultiProject()) {
                    this.setMultiProjectForms(proposal, s2sOpportunity);
                } else {
                    this.getS2sSubmissionService().setMandatoryForms(proposal, s2sOpportunity);
                }
            }
        }
        catch (S2sCommunicationException ex) {
            if (ex.getErrorKey().equals("error.grantsgov.no.form.element")) {
                ex.setMessage(s2sOpportunity.getOpportunityId());
            }
            this.getGlobalVariableService().getMessageMap().putError("noField", ex.getErrorKey(), ex.getMessageWithParams());
            if (proposal.isMultiProjectParent()) {
                this.clearMultiProjectChildOpportunities(proposal);
            }
            proposal.setS2sOpportunity(new S2sOpportunity());
        }
    }

    protected List<? extends S2sFormConfigurationContract> getS2sFormConfigurations(List<String> forms, Optional<List<? extends S2sFormConfigurationContract>> allConfigs) {
        List configs = allConfigs.orElseGet(() -> this.getS2sFormConfigurationService().findAllS2sFormConfigurations());
        return configs.stream().filter(missingMandatoryCfg -> forms.contains(missingMandatoryCfg.getFormName())).filter(missingMandatoryCfg -> StringUtils.isNotBlank((CharSequence)missingMandatoryCfg.getInactiveMessage())).collect(Collectors.toList());
    }

    private void clearMultiProjectChildOpportunities(DevelopmentProposal developmentProposal) {
        this.proposalHierarchyService.getHierarchyChildren(developmentProposal.getProposalNumber()).forEach(child -> child.setS2sOpportunity(null));
    }

    private List<String> setMultiProjectForms(DevelopmentProposal developmentProposal, S2sOpportunity s2sOpportunity) {
        List<S2sMultiProjectComponent> componentTypes = this.getOpportunitySchemaParserService().parseMultiProjectSchemas(s2sOpportunity.getSchemaUrl(), s2sOpportunity.getOpportunity());
        S2sMultiProjectComponent overallComponent = componentTypes.stream().filter(componentType -> "Overall".equalsIgnoreCase(componentType.getComponentType())).findFirst().orElseThrow(() -> new S2sCommunicationException("error.grantsgov.form.parsing", "Unable to find Overall Package", s2sOpportunity.getSchemaUrl()));
        s2sOpportunity.setComponentType(overallComponent.getComponentType());
        s2sOpportunity.setOverallSchemaUrl(overallComponent.getSchemaUrl());
        s2sOpportunity.setOverallSchema(overallComponent.getSchema());
        List<String> missingMandatoryForms = this.getS2sSubmissionService().setMandatoryForms(developmentProposal, s2sOpportunity);
        this.proposalHierarchyService.getHierarchyChildren(developmentProposal.getProposalNumber()).forEach(child -> missingMandatoryForms.addAll(this.updateChildOpportunityFromParent(developmentProposal, (DevelopmentProposal)child, componentTypes)));
        return missingMandatoryForms;
    }

    protected List<String> updateChildOpportunityFromParent(DevelopmentProposal parent, DevelopmentProposal child, List<S2sMultiProjectComponent> componentTypes) {
        if (parent.isMultiProjectParent()) {
            S2sOpportunity parentOpportunity = parent.getS2sOpportunity();
            List availableComponentTypes = Optional.ofNullable(componentTypes).orElseGet(() -> this.getOpportunitySchemaParserService().parseMultiProjectSchemas(parentOpportunity.getSchemaUrl(), parentOpportunity.getOpportunity()));
            S2sOpportunity childOpportunity = child.getS2sOpportunity();
            if (childOpportunity == null) {
                childOpportunity = new S2sOpportunity();
            }
            if (StringUtils.isEmpty((CharSequence)childOpportunity.getComponentType())) {
                childOpportunity.setComponentType("Project");
            }
            String childComponentType = childOpportunity.getComponentType();
            S2sMultiProjectComponent childComponent = availableComponentTypes.stream().filter(component -> childComponentType.equalsIgnoreCase(component.getComponentType())).findFirst().orElseThrow(() -> new S2sCommunicationException("error.grantsgov.form.parsing", "Unable to find " + childComponentType + " Package", parentOpportunity.getSchemaUrl()));
            childOpportunity.setDevelopmentProposal(child);
            child.setS2sOpportunity(childOpportunity);
            this.updateChildOpportunityFromParent(parentOpportunity, childOpportunity, childComponent);
            child.updateFromS2sOpportunity(childOpportunity);
            return this.getS2sSubmissionService().setMandatoryForms(child, child.getS2sOpportunity());
        }
        return Collections.emptyList();
    }

    private void updateChildOpportunityFromParent(S2sOpportunity parent, S2sOpportunity child, S2sMultiProjectComponent opportunityType) {
        child.setS2sOppForms(null);
        child.setOpportunity(opportunityType.getSchema());
        child.setSchemaUrl(opportunityType.getSchemaUrl());
        child.setComponentType(opportunityType.getComponentType());
        child.setOpportunityId(parent.getOpportunityId());
        child.setOpportunityTitle(parent.getOpportunityTitle());
        child.setProviderCode(parent.getProviderCode());
        child.setOpeningDate(parent.getOpeningDate());
        child.setClosingDate(parent.getClosingDate());
        child.setCompetitionId(parent.getCompetitionId());
        child.setCompetitionTitle(parent.getCompetitionTitle());
        child.setS2sSubmissionTypeCode(parent.getS2sSubmissionTypeCode());
        child.setS2sSubmissionType(parent.getS2sSubmissionType());
        child.setInstructionUrl(parent.getInstructionUrl());
        child.setPackageId(parent.getPackageId());
        child.setS2sRevisionType(parent.getS2sRevisionType());
        child.setRevisionCode(parent.getRevisionCode());
        child.setRevisionOtherDescription(parent.getRevisionOtherDescription());
        child.setAgencyContactInfo(parent.getAgencyContactInfo());
        child.setOfferingAgency(parent.getOfferingAgency());
        child.setFundingOpportunityNumber(parent.getFundingOpportunityNumber());
        child.setMultiProject(parent.isMultiProject());
        child.setS2sProvider(parent.getS2sProvider());
        child.setS2sOpportunityCfdas(parent.getS2sOpportunityCfdas().stream().map(cfda -> {
            S2sOpportunityCfda copy = new S2sOpportunityCfda();
            copy.setProposalNumber(child.getProposalNumber());
            copy.setCfdaNumber(cfda.getCfdaNumber());
            copy.setCfdaDescription(cfda.getCfdaDescription());
            return copy;
        }).collect(Collectors.toList()));
    }

    protected ExemptionType getExemptionType(Object element) {
        return (ExemptionType)this.getDataObjectService().findUnique(ExemptionType.class, QueryByCriteria.Builder.forAttribute((String)"code", (Object)element).build());
    }

    public AuditHelper.ValidationState getValidationState(ProposalDevelopmentDocumentForm form) {
        AuditHelper.ValidationState severityLevel = AuditHelper.ValidationState.OK;
        form.setAuditActivated(true);
        List<DataValidationItem> dataValidationItems = ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateDataValidation(form);
        if (dataValidationItems != null && !dataValidationItems.isEmpty()) {
            for (DataValidationItem validationItem : dataValidationItems) {
                if (StringUtils.endsWith((CharSequence)validationItem.getSeverity(), (CharSequence)"Error")) {
                    severityLevel = AuditHelper.ValidationState.ERROR;
                    break;
                }
                if (!StringUtils.equals((CharSequence)validationItem.getSeverity(), (CharSequence)"Warnings")) continue;
                severityLevel = AuditHelper.ValidationState.WARNING;
            }
            form.setDataValidationItems(dataValidationItems);
        }
        this.getGlobalVariableService().getMessageMap().clearErrorMessages();
        return severityLevel;
    }

    public void populateAdHocRecipients(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        if (StringUtils.isEmpty((CharSequence)proposalDevelopmentDocument.getDocumentNumber()) && proposalDevelopmentDocument.getDocumentHeader() != null && StringUtils.isNotEmpty((CharSequence)proposalDevelopmentDocument.getDocumentHeader().getDocumentNumber())) {
            proposalDevelopmentDocument.setDocumentNumber(proposalDevelopmentDocument.getDocumentHeader().getDocumentNumber());
        }
        if (StringUtils.isNotEmpty((CharSequence)proposalDevelopmentDocument.getDocumentNumber())) {
            this.getDocumentAdHocService().addAdHocs((Document)proposalDevelopmentDocument);
        }
    }

    public void handleSponsorChange(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        for (int i = 0; i < proposalDevelopmentDocument.getDevelopmentProposal().getProposalPersons().size(); ++i) {
            ProposalPerson person = proposalDevelopmentDocument.getDevelopmentProposal().getProposalPersons().get(i);
            if (person.getRole() != null) continue;
            person.setProposalPersonRoleId("COI");
            String propertyName = "document.developmentProposal.proposalPersons";
            this.getGlobalVariableService().getMessageMap().putInfo(propertyName + "[" + i + "].proposalPersonRoleId", "info.personnel.invalid.role", new String[]{person.getDevelopmentProposal().getSponsorCode(), person.getFullName()});
        }
    }

    protected ScienceKeyword getScienceKeyword(Object element) {
        return (ScienceKeyword)this.getDataObjectService().findUnique(ScienceKeyword.class, QueryByCriteria.Builder.forAttribute((String)"code", (Object)element).build());
    }

    public KcCommonControllerService getKcCommonControllerService() {
        return this.kcCommonControllerService;
    }

    public void setKcCommonControllerService(KcCommonControllerService kcCommonControllerService) {
        this.kcCommonControllerService = kcCommonControllerService;
    }

    public ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }

    public NavigationControllerService getNavigationControllerService() {
        return this.navigationControllerService;
    }

    public void setNavigationControllerService(NavigationControllerService navigationControllerService) {
        this.navigationControllerService = navigationControllerService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    protected ProposalDevelopmentPermissionsService getProposalDevelopmentPermissionsService() {
        return this.proposalDevelopmentPermissionsService;
    }

    public void setProposalDevelopmentPermissionsService(ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService) {
        this.proposalDevelopmentPermissionsService = proposalDevelopmentPermissionsService;
    }

    public ProposalPersonBiographyService getProposalPersonBiographyService() {
        return this.proposalPersonBiographyService;
    }

    public void setProposalPersonBiographyService(ProposalPersonBiographyService proposalPersonBiographyService) {
        this.proposalPersonBiographyService = proposalPersonBiographyService;
    }

    public DocumentAdHocService getDocumentAdHocService() {
        return this.documentAdHocService;
    }

    public void setDocumentAdHocService(DocumentAdHocService documentAdHocService) {
        this.documentAdHocService = documentAdHocService;
    }

    public AuditHelper getAuditHelper() {
        return this.auditHelper;
    }

    public void setAuditHelper(AuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }

    public KcNotificationService getKcNotificationService() {
        return this.kcNotificationService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ProposalLockService getProposalLockService() {
        return this.proposalLockService;
    }

    public void setProposalLockService(ProposalLockService proposalLockService) {
        this.proposalLockService = proposalLockService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ProjectRetrievalService getPropDevProjectRetrievalService() {
        return this.propDevProjectRetrievalService;
    }

    public void setPropDevProjectRetrievalService(ProjectRetrievalService propDevProjectRetrievalService) {
        this.propDevProjectRetrievalService = propDevProjectRetrievalService;
    }

    public ProposalTypeService getProposalTypeService() {
        return this.proposalTypeService;
    }

    public void setProposalTypeService(ProposalTypeService proposalTypeService) {
        this.proposalTypeService = proposalTypeService;
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public KeyPersonnelService getKeyPersonnelService() {
        return this.keyPersonnelService;
    }

    public void setKeyPersonnelService(KeyPersonnelService keyPersonnelService) {
        this.keyPersonnelService = keyPersonnelService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public S2sFormConfigurationService getS2sFormConfigurationService() {
        return this.s2sFormConfigurationService;
    }

    public void setS2sFormConfigurationService(S2sFormConfigurationService s2sFormConfigurationService) {
        this.s2sFormConfigurationService = s2sFormConfigurationService;
    }

    public S2sSubmissionService getS2sSubmissionService() {
        return this.s2sSubmissionService;
    }

    public void setS2sSubmissionService(S2sSubmissionService s2sSubmissionService) {
        this.s2sSubmissionService = s2sSubmissionService;
    }

    public OpportunitySchemaParserService getOpportunitySchemaParserService() {
        return this.opportunitySchemaParserService;
    }

    public void setOpportunitySchemaParserService(OpportunitySchemaParserService opportunitySchemaParserService) {
        this.opportunitySchemaParserService = opportunitySchemaParserService;
    }

    public ProjectPublisher getProjectPublisher() {
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    public ProtocolsFundedByService getProtocolsFundedByService() {
        return this.protocolsFundedByService;
    }

    public void setProtocolsFundedByService(ProtocolsFundedByService protocolsFundedByService) {
        this.protocolsFundedByService = protocolsFundedByService;
    }

    public KrmsRulesExecutionService getKrmsRulesExecutionService() {
        return this.krmsRulesExecutionService;
    }

    public void setKrmsRulesExecutionService(KrmsRulesExecutionService krmsRulesExecutionService) {
        this.krmsRulesExecutionService = krmsRulesExecutionService;
    }

    private static /* synthetic */ ProposalPerson lambda$saveUpdatePersonAnswerHeaders$17(DataObjectService rec$, Object x$0) {
        return (ProposalPerson)rec$.save(x$0, new PersistenceOption[0]);
    }

    protected class PropScienceKeywordEditor
    extends CustomCollectionEditor {
        public PropScienceKeywordEditor() {
            super(List.class, true);
        }

        protected Object convertElement(Object element) {
            if (element instanceof String) {
                return new PropScienceKeyword(null, ProposalDevelopmentControllerBase.this.getScienceKeyword(element));
            }
            return element;
        }

        public String getAsText() {
            if (this.getValue() != null) {
                Collection keywords = (Collection)this.getValue();
                StringBuilder result = new StringBuilder();
                for (PropScienceKeyword keyword : keywords) {
                    result.append(keyword.getScienceKeyword().getCode());
                    result.append(",");
                }
                if (!result.isEmpty()) {
                    return result.substring(0, result.length() - 1);
                }
                return "";
            }
            return null;
        }
    }

    protected class PropSpecialReviewExemptionTypeEditor
    extends CustomCollectionEditor {
        public PropSpecialReviewExemptionTypeEditor() {
            super(List.class, true);
        }

        protected Object convertElement(Object element) {
            if (element instanceof String) {
                return new ProposalSpecialReviewExemption(null, ProposalDevelopmentControllerBase.this.getExemptionType(element));
            }
            return element;
        }

        public String getAsText() {
            if (this.getValue() != null) {
                Collection exemptions = (Collection)this.getValue();
                StringBuilder result = new StringBuilder();
                for (ProposalSpecialReviewExemption exemption : exemptions) {
                    result.append(exemption.getExemptionTypeCode());
                    result.append(",");
                }
                if (!result.isEmpty()) {
                    return result.substring(0, result.length() - 1);
                }
            }
            return null;
        }
    }
}

