/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.commitments.FandaRateType;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.keyvalues.PersistableBusinessObjectValuesFinder;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardFandARateAuditRule
implements DocumentAuditRule {
    private static final String FANDA_AUDIT_ERRORS = "fandaAuditErrors";
    private List<AuditError> auditErrors;
    private KeyValuesFinder finder;
    private ParameterService parameterService;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = true;
        AwardDocument awardDocument = (AwardDocument)document;
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getParameterService().getParameterValueAsString(AwardDocument.class, "enable.award.FnA.validation"), (CharSequence)"1")) {
            retval = this.isFandaRateInputInPairs(awardDocument.getAward().getAwardFandaRate());
        }
        return retval;
    }

    protected boolean isFandaRateInputInPairs(List<AwardFandaRate> awardFandaRateList) {
        HashMap<String, String> a1 = new HashMap<String, String>();
        HashMap<String, String> b1 = new HashMap<String, String>();
        this.createHashMapsForRuleEvaluation(awardFandaRateList, a1, b1);
        boolean valid = this.evaluateRule(awardFandaRateList, a1, b1);
        if (!valid) {
            this.reportAndCreateAuditCluster();
        }
        return valid;
    }

    protected void createHashMapsForRuleEvaluation(List<AwardFandaRate> awardFandaRateList, HashMap<String, String> a1, HashMap<String, String> b1) {
        for (AwardFandaRate awardFandaRate : awardFandaRateList) {
            if (StringUtils.equalsIgnoreCase((CharSequence)awardFandaRate.getOnCampusFlag(), (CharSequence)"N")) {
                a1.put(awardFandaRate.getFandaRateTypeCode(), awardFandaRate.getOnCampusFlag());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)awardFandaRate.getOnCampusFlag(), (CharSequence)"F")) continue;
            b1.put(awardFandaRate.getFandaRateTypeCode(), awardFandaRate.getOnCampusFlag());
        }
    }

    protected boolean evaluateRule(List<AwardFandaRate> awardFandaRateList, HashMap<String, String> a1, HashMap<String, String> b1) {
        boolean valid = true;
        for (AwardFandaRate awardFandaRate : awardFandaRateList) {
            if ((!a1.containsKey(awardFandaRate.getFandaRateTypeCode()) || b1.containsKey(awardFandaRate.getFandaRateTypeCode())) && (!b1.containsKey(awardFandaRate.getFandaRateTypeCode()) || a1.containsKey(awardFandaRate.getFandaRateTypeCode()))) continue;
            valid = false;
            this.addAuditError(this.createAuditError(this.getFinder().getKeyLabel(awardFandaRate.getFandaRateTypeCode())));
        }
        return valid;
    }

    private void addAuditError(AuditError auditError) {
        if (this.auditErrors == null) {
            this.auditErrors = new ArrayList<AuditError>();
        }
        this.auditErrors.add(auditError);
    }

    private AuditError createAuditError(String rateType) {
        return new AuditError("document.reportTermsAuditRules", "indirectCostRate.not.in.pair", this.createPageContext(), new String[]{rateType});
    }

    private String createPageContext() {
        StringBuilder sb = new StringBuilder();
        sb.append("commitments");
        sb.append(".");
        sb.append("Rates");
        return sb.toString();
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(FANDA_AUDIT_ERRORS, new AuditCluster("Rates", this.auditErrors, "Error"));
        }
    }

    KeyValuesFinder getFinder() {
        if (this.finder == null) {
            PersistableBusinessObjectValuesFinder extendedFinder = new PersistableBusinessObjectValuesFinder();
            extendedFinder.setBusinessObjectClass(FandaRateType.class);
            extendedFinder.setKeyAttributeName("fandaRateTypeCode");
            extendedFinder.setLabelAttributeName("description");
            this.finder = extendedFinder;
        }
        return this.finder;
    }

    void setFinder(KeyValuesFinder mockFinder) {
        this.finder = mockFinder;
    }
}

