/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.standalone;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.standalone.BudgetDto;
import org.kuali.coeus.common.budget.api.standalone.BudgetSummaryDto;
import org.kuali.coeus.common.budget.api.standalone.StandaloneBudgetCommunicationException;
import org.kuali.coeus.common.budget.api.standalone.StandaloneBudgetImportService;
import org.kuali.coeus.common.budget.impl.standalone.StandaloneBudgetResponse;
import org.kuali.coeus.common.budget.impl.standalone.StandaloneBudgetsResponse;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetNavigationService;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.coeus.sys.framework.graphql.GraphqlRequest;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.UnknownContentTypeException;

@Service(value="standaloneBudgetImportService")
public class StandaloneBudgetImportServiceImpl
implements StandaloneBudgetImportService {
    private static final Logger LOG = LogManager.getLogger(StandaloneBudgetImportServiceImpl.class);
    private static final String HPC_CODE_ID_PARAMETER = "BUDGET_HPC_CODE_ID";
    private static final String STANDALONE_BUDGET_GRAPHQL_ENDPOINT = "/api";
    private static final String DETAILED_BUDGET_TOTALS_FRAGMENT = "totals {\n  directCosts { total }\n  indirectCosts { total }\n  costs { total }\n  feesAppliedToTotal { total }\n  grandTotal { coSponsor, costShare, total }\n  projectIncome { total }\n}\n";
    private static final String DETAILED_BUDGET_FRAGMENT = String.format("id\nproposalId\ndescription\ntype\nstartDate\nendDate\nstatus\ncoSponsorRatio\nindirectRate: cells { stats { indirect: rate(code: \"1\") { description, rate } } }\nhpcCode: cells(objectCodeId: [$hpcCodeId]) {\n  stats { quantity { coSponsor } }\n}\n%s\nperiods {\n  personnel: cells(budgetCategoryType: [\"P\"]) {\n    stats {\n      salary: rate(code: \"0\") { total }\n      fringe: rate(code: \"5\") { total }\n      total { total }\n    }\n  }\n  nonPersonnel: cells(budgetCategoryTypeIsNot: [\"P\"]) {\n    stats { total { total } }\n  }\n  number\n  startDate\n  endDate\n  costShareAllocations {\n    code\n    sourceAccount\n    unit { id }\n    total\n  }\n  %s\n}\n", "totals {\n  directCosts { total }\n  indirectCosts { total }\n  costs { total }\n  feesAppliedToTotal { total }\n  grandTotal { coSponsor, costShare, total }\n  projectIncome { total }\n}\n", "totals {\n  directCosts { total }\n  indirectCosts { total }\n  costs { total }\n  feesAppliedToTotal { total }\n  grandTotal { coSponsor, costShare, total }\n  projectIncome { total }\n}\n");
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="proposalBudgetNavigationService")
    private ProposalBudgetNavigationService proposalBudgetNavigationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;

    @Override
    public boolean isEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-B", "All", "Standalone_Budget_Enabled", Boolean.valueOf(false));
    }

    @Override
    public List<BudgetSummaryDto> listBudgets(String proposalId) {
        return this.doListBudgets(proposalId);
    }

    private List<BudgetSummaryDto> doListBudgets(String proposalId) {
        GraphqlRequest graphqlQuery = new GraphqlRequest.Builder().query("query SP_ListBudgets($proposalId: String!) {\n  budgets(proposalId: $proposalId) {\n    id\n    proposalId\n    description\n    type\n    stats {\n      grandTotal\n      directCosts\n      indirectCosts\n    }\n    startDate\n    endDate\n    status\n  }\n}\n").variable("proposalId", proposalId).operationName("SP_ListBudgets").build();
        try {
            ResponseEntity budgetResponse = this.restOperations.exchange(this.getBudgetGraphqlUrl(), HttpMethod.POST, new HttpEntity((Object)graphqlQuery, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), StandaloneBudgetsResponse.class, new Object[0]);
            return this.mapBudgetsResponseToDto((StandaloneBudgetsResponse)budgetResponse.getBody());
        }
        catch (RestClientResponseException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to retrieve budgets for proposal id %s response %s", proposalId, e.getResponseBodyAsString()), e);
        }
        catch (UnknownContentTypeException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to retrieve budgets for proposal id %s response %s", proposalId, e.getResponseBodyAsString()), e);
        }
        catch (RestClientException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to retrieve budgets for proposal id %s", proposalId), e);
        }
    }

    protected List<BudgetSummaryDto> mapBudgetsResponseToDto(StandaloneBudgetsResponse response) {
        return Optional.of(response).map(StandaloneBudgetsResponse::getBudgets).orElse(Collections.emptyList());
    }

    @Override
    public BudgetDto getBudget(String budgetId) {
        return this.doGetBudget(budgetId);
    }

    private BudgetDto doGetBudget(String budgetId) {
        GraphqlRequest graphqlQuery = new GraphqlRequest.Builder().query(GetBudgetGraphql.QUERY).variable("budgetId", budgetId).variable("hpcCodeId", "--").operationName("SP_GetBudget").build();
        try {
            ResponseEntity budgetResponse = this.restOperations.exchange(this.getBudgetGraphqlUrl(), HttpMethod.POST, new HttpEntity((Object)graphqlQuery, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), StandaloneBudgetResponse.class, new Object[0]);
            return this.mapBudgetResponseToDto((StandaloneBudgetResponse)budgetResponse.getBody());
        }
        catch (RestClientResponseException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to retrieve budgets for budget id %s response %s", budgetId, e.getResponseBodyAsString()), e);
        }
        catch (UnknownContentTypeException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to retrieve budgets for budget id %s response %s", budgetId, e.getResponseBodyAsString()), e);
        }
        catch (RestClientException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to retrieve budgets for budget id %s", budgetId), e);
        }
    }

    private String getBudgetGraphqlUrl() {
        String budgetBaseUrl = this.getProposalBudgetNavigationService().getStandaloneBudgetBaseUrl();
        return budgetBaseUrl + STANDALONE_BUDGET_GRAPHQL_ENDPOINT;
    }

    @Override
    public BudgetDto getFinalBudget(String proposalId) {
        String hpcCodeId = this.getParameterService().getParameterValueAsString("KC-IP", "Document", HPC_CODE_ID_PARAMETER);
        return this.doGetFinalBudget(proposalId, StringUtils.isNotBlank((String)hpcCodeId) ? hpcCodeId : "--");
    }

    private BudgetDto doGetFinalBudget(String proposalId, String hpcCodeId) {
        GraphqlRequest graphqlQuery = new GraphqlRequest.Builder().query(GetFinalBudgetGraphql.QUERY).variable("proposalId", proposalId).variable("hpcCodeId", hpcCodeId).operationName("SP_GetFinalBudget").build();
        try {
            ResponseEntity budgetResponse = this.restOperations.exchange(this.getBudgetGraphqlUrl(), HttpMethod.POST, new HttpEntity((Object)graphqlQuery, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), StandaloneBudgetResponse.class, new Object[0]);
            return this.mapBudgetResponseToDto((StandaloneBudgetResponse)budgetResponse.getBody());
        }
        catch (RestClientResponseException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to retrieve budgets for proposalId id %s hpc code id %s response %s", proposalId, hpcCodeId, e.getResponseBodyAsString()), e);
        }
        catch (UnknownContentTypeException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to retrieve budgets for proposalId id %s hpc code id %s response %s", proposalId, hpcCodeId, e.getResponseBodyAsString()), e);
        }
        catch (RestClientException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to retrieve budgets for proposal id %s hpc code id %s", proposalId, hpcCodeId), e);
        }
    }

    protected BudgetDto mapBudgetResponseToDto(StandaloneBudgetResponse response) {
        return Optional.of(response).map(StandaloneBudgetResponse::getBudget).orElse(null);
    }

    @Override
    public boolean copyAllBudgets(String proposalId, String newProposalId) {
        GraphqlRequest graphqlQuery = new GraphqlRequest.Builder().query("mutation SP_DuplicateProposal($proposalId: String!, $newProposalId: String!) {\n  duplicateProposal(id: $proposalId, newProposalId: $newProposalId)\n}\n").variable("proposalId", proposalId).variable("newProposalId", newProposalId).operationName("SP_DuplicateProposal").build();
        try {
            ResponseEntity budgetResponse = this.restOperations.exchange(this.getBudgetGraphqlUrl(), HttpMethod.POST, new HttpEntity((Object)graphqlQuery, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), CopyResponse.class, new Object[0]);
            CopyResponse body = (CopyResponse)budgetResponse.getBody();
            return body != null && body.success();
        }
        catch (RestClientResponseException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to copy all budgets for proposalId id %s new proposalId %s response %s", proposalId, newProposalId, e.getResponseBodyAsString()), e);
        }
        catch (UnknownContentTypeException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to copy all budgets for proposalId id %s new proposalId %s response %s", proposalId, newProposalId, e.getResponseBodyAsString()), e);
        }
        catch (RestClientException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to copy all budgets for proposal id %s new proposalId %s", proposalId, newProposalId), e);
        }
    }

    @Override
    public boolean copyBudgets(String proposalId, String newProposalId, List<String> budgetIds) {
        GraphqlRequest graphqlQuery = new GraphqlRequest.Builder().query("mutation SP_DuplicateProposal($proposalId: String!, $newProposalId: String!, $budgetIds: [String]!) {\n  duplicateProposal(id: $proposalId, newProposalId: $newProposalId, budgetIds: $budgetIds)\n}\n").variable("proposalId", proposalId).variable("newProposalId", newProposalId).variable("budgetIds", budgetIds).operationName("SP_DuplicateProposal").build();
        try {
            ResponseEntity budgetResponse = this.restOperations.exchange(this.getBudgetGraphqlUrl(), HttpMethod.POST, new HttpEntity((Object)graphqlQuery, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), CopyResponse.class, new Object[0]);
            CopyResponse body = (CopyResponse)budgetResponse.getBody();
            return body != null && body.success();
        }
        catch (RestClientResponseException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to copy budgets for proposalId id %s new proposalId %s budget ids %sresponse %s", proposalId, newProposalId, budgetIds, e.getResponseBodyAsString()), e);
        }
        catch (UnknownContentTypeException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to copy budgets for proposalId id %s new proposalId %s budget ids %sresponse %s", proposalId, newProposalId, budgetIds, e.getResponseBodyAsString()), e);
        }
        catch (RestClientException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to copy budgets for proposal id %s new proposalId %s budget ids %s", proposalId, newProposalId, budgetIds), e);
        }
    }

    @Override
    public boolean proposalUpdated(String proposalId) {
        GraphqlRequest graphqlQuery = new GraphqlRequest.Builder().query("mutation SP_ProposalUpdated($proposalId: String!) {\n  proposalUpdated(id: $proposalId)\n}\n").variable("proposalId", proposalId).operationName("SP_ProposalUpdated").build();
        try {
            ResponseEntity budgetResponse;
            ProposalUpdatedResponse body;
            if (LOG.isWarnEnabled()) {
                boolean userExists = !this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser().isEmpty();
                boolean s2sExists = !this.getService2ServiceHeaders().isEmpty();
                LOG.warn("auth tokens: userExists: {} s2sExists: {}", (Object)userExists, (Object)s2sExists, (Object)new Throwable());
            }
            return (body = (ProposalUpdatedResponse)(budgetResponse = this.restOperations.exchange(this.getBudgetGraphqlUrl(), HttpMethod.POST, new HttpEntity((Object)graphqlQuery, (MultiValueMap)this.getService2ServiceHeaders()), ProposalUpdatedResponse.class, new Object[0])).getBody()) != null && body.success();
        }
        catch (RestClientResponseException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to update proposal for proposalId id %s response %s", proposalId, e.getResponseBodyAsString()), e);
        }
        catch (UnknownContentTypeException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to update proposal for proposalId id %s response %s", proposalId, e.getResponseBodyAsString()), e);
        }
        catch (RestClientException e) {
            throw new StandaloneBudgetCommunicationException(String.format("Failed to update proposal for proposal id %s", proposalId), e);
        }
    }

    private HttpHeaders getService2ServiceHeaders() {
        HttpHeaders headerParams = new HttpHeaders();
        headerParams.setBearerAuth(this.jwtService.createToken());
        return headerParams;
    }

    public ProposalBudgetNavigationService getProposalBudgetNavigationService() {
        return this.proposalBudgetNavigationService;
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public void setProposalBudgetNavigationService(ProposalBudgetNavigationService proposalBudgetNavigationService) {
        this.proposalBudgetNavigationService = proposalBudgetNavigationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    private static class ListBudgetsGraphql {
        private static final String OPERATION_NAME = "SP_ListBudgets";
        private static final String QUERY = "query SP_ListBudgets($proposalId: String!) {\n  budgets(proposalId: $proposalId) {\n    id\n    proposalId\n    description\n    type\n    stats {\n      grandTotal\n      directCosts\n      indirectCosts\n    }\n    startDate\n    endDate\n    status\n  }\n}\n";
        private static final String PROPOSAL_ID = "proposalId";

        private ListBudgetsGraphql() {
        }
    }

    private static class GetBudgetGraphql {
        private static final String OPERATION_NAME = "SP_GetBudget";
        private static final String QUERY = String.format("query SP_GetBudget($budgetId: ID!, $hpcCodeId: String!) {\n  budget(id: $budgetId) {\n    %s\n  }\n}\n", DETAILED_BUDGET_FRAGMENT);
        private static final String BUDGET_ID = "budgetId";
        private static final String HPC_CODE_ID = "hpcCodeId";

        private GetBudgetGraphql() {
        }
    }

    private static class GetFinalBudgetGraphql {
        private static final String OPERATION_NAME = "SP_GetFinalBudget";
        private static final String QUERY = String.format("query SP_GetFinalBudget($proposalId: String!, $hpcCodeId: String!) {\n  budget: finalBudget(proposalId: $proposalId) {\n    %s\n  }\n}\n", DETAILED_BUDGET_FRAGMENT);
        private static final String PROPOSAL_ID = "proposalId";
        private static final String HPC_CODE_ID = "hpcCodeId";

        private GetFinalBudgetGraphql() {
        }
    }

    private static class CopyAllBudgetsGraphql {
        private static final String OPERATION_NAME = "SP_DuplicateProposal";
        private static final String MUTATION = "mutation SP_DuplicateProposal($proposalId: String!, $newProposalId: String!) {\n  duplicateProposal(id: $proposalId, newProposalId: $newProposalId)\n}\n";
        private static final String PROPOSAL_ID = "proposalId";
        private static final String NEW_PROPOSAL_ID = "newProposalId";

        private CopyAllBudgetsGraphql() {
        }
    }

    private static final class CopyResponse {
        private Map<String, String> data;

        private CopyResponse() {
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public void setData(Map<String, String> data) {
            this.data = data;
        }

        public boolean success() {
            return this.data != null && this.data.containsKey("duplicateProposal") && "ok".equals(this.data.get("duplicateProposal"));
        }
    }

    private static class CopyBudgetsGraphql {
        private static final String OPERATION_NAME = "SP_DuplicateProposal";
        private static final String MUTATION = "mutation SP_DuplicateProposal($proposalId: String!, $newProposalId: String!, $budgetIds: [String]!) {\n  duplicateProposal(id: $proposalId, newProposalId: $newProposalId, budgetIds: $budgetIds)\n}\n";
        private static final String PROPOSAL_ID = "proposalId";
        private static final String NEW_PROPOSAL_ID = "newProposalId";
        private static final String BUDGET_IDS = "budgetIds";

        private CopyBudgetsGraphql() {
        }
    }

    private static class ProposalUpdatedGraphql {
        private static final String OPERATION_NAME = "SP_ProposalUpdated";
        private static final String MUTATION = "mutation SP_ProposalUpdated($proposalId: String!) {\n  proposalUpdated(id: $proposalId)\n}\n";
        private static final String PROPOSAL_ID = "proposalId";

        private ProposalUpdatedGraphql() {
        }
    }

    private static final class ProposalUpdatedResponse {
        private Map<String, String> data;

        private ProposalUpdatedResponse() {
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public void setData(Map<String, String> data) {
            this.data = data;
        }

        public boolean success() {
            return this.data != null && this.data.containsKey("proposalUpdated") && "ok".equals(this.data.get("proposalUpdated"));
        }
    }
}

