/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.pdf.forms;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.pdf.forms.PdfForms;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Section;

public class PdfFormsMaintainable
extends KraMaintainableImpl {
    private static final String ACTIVE = "active";

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        if (document.isEdit() && ((PdfForms)document.getOldMaintainableObject().getBusinessObject()).isSystemDefault()) {
            sections.forEach(section -> section.getRows().forEach(row -> row.getFields().forEach(field -> field.setReadOnly(!ACTIVE.equals(field.getPropertyName())))));
        }
        return sections;
    }

    public void saveBusinessObject() {
        if (StringUtils.isBlank((CharSequence)((PdfForms)this.businessObject).getMappingFile().getFileName())) {
            ((PdfForms)this.businessObject).setMappingFile(null);
        }
        if (StringUtils.isBlank((CharSequence)((PdfForms)this.businessObject).getPdfFormFile().getFileName())) {
            ((PdfForms)this.businessObject).setPdfFormFile(null);
        }
        super.saveBusinessObject();
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        PdfForms pdfForms = (PdfForms)document.getNewMaintainableObject().getPersistableBusinessObject();
        pdfForms.setMappingFileId(null);
        if (pdfForms.getMappingFile() != null) {
            pdfForms.getMappingFile().setId(null);
        }
        pdfForms.setPdfFormFileId(null);
        if (pdfForms.getPdfFormFile() != null) {
            pdfForms.getPdfFormFile().setId(null);
        }
    }
}

