/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.commitments.AddAwardFandaRateEvent;
import org.kuali.kra.award.commitments.AddFandaRateRule;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.commitments.AwardFandaRateSaveEvent;
import org.kuali.kra.award.commitments.FandaRateType;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.ValidRates;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardFandaRateRule
extends KcTransactionalDocumentRuleBase
implements AddFandaRateRule {
    private static final int FISCAL_YEAR_LENGTH = 4;
    private static final String FISCAL_YEAR_STRING = ".fiscalYear";
    private static final String NEW_AWARD_FANDA_RATE = "newAwardFandaRate";
    private static final String AWARD_FANDA_RATES_ARRAY = "document.awardList[0].awardFandaRate";
    private static final ScaleTwoDecimal ScaleTwoDecimal_THOUSAND = new ScaleTwoDecimal(1000);
    private static final String FANDA_RATES = "awardFandaRate";
    private static final String ON_CAMPUS = "On";
    private static final String OFF_CAMPUS = "Off";
    private static final String ON_CAMPUS_RATE = "onCampusRate";
    private static final String OFF_CAMPUS_RATE = "offCampusRate";
    private static final String FANDA_RATE_CLASS_TYPE = "O";
    private static final String RATE_CLASS_TYPE = "rateClassType";
    private static final String RATE_CLASS_TYPE_CODE = "fandaRateTypeCode";
    private ParameterService parameterService;
    BusinessObjectService businessObjectService;
    private boolean isPairChecked = false;

    @Override
    public boolean processAddFandaRateBusinessRules(AddAwardFandaRateEvent addAwardFandaRateEvent) {
        AwardFandaRate awardFandaRate = addAwardFandaRateEvent.getAwardFandaRate();
        boolean rulePassed = true;
        rulePassed &= this.evaluateRuleForApplicableFandaRate(awardFandaRate, NEW_AWARD_FANDA_RATE);
        rulePassed &= this.evaluateRuleForFandaRateTypeCode(awardFandaRate, NEW_AWARD_FANDA_RATE);
        rulePassed &= this.evaluateRuleForFiscalYear(awardFandaRate, NEW_AWARD_FANDA_RATE);
        rulePassed &= this.evaluateRuleForStartAndEndDates(awardFandaRate, NEW_AWARD_FANDA_RATE);
        return rulePassed &= this.checkValidFandARate(awardFandaRate, NEW_AWARD_FANDA_RATE);
    }

    public boolean processSaveFandaRateBusinessRules(AwardFandaRateSaveEvent awardFandaRateSaveEvent) {
        AwardFandaRate awardFandaRate = awardFandaRateSaveEvent.getAwardFandaRate();
        boolean rulePassed = true;
        AwardDocument awardDocument = (AwardDocument)awardFandaRateSaveEvent.getDocument();
        String propertyPrefix = "document.awardList[0].awardFandaRate[" + awardFandaRateSaveEvent.getFandaRateIndex() + "]";
        rulePassed &= this.evaluateRuleForApplicableFandaRate(awardFandaRate, propertyPrefix);
        rulePassed &= this.evaluateRuleForFandaRateTypeCode(awardFandaRate, propertyPrefix);
        rulePassed &= this.evaluateRuleForFiscalYear(awardFandaRate, propertyPrefix);
        rulePassed &= this.evaluateRuleForStartAndEndDates(awardFandaRate, propertyPrefix);
        if (rulePassed &= this.checkValidFandARate(awardFandaRate, propertyPrefix)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "enable.award.FnA.validation"), (CharSequence)"1")) {
                if (!this.isPairChecked) {
                    rulePassed = this.isFandaRateInputInPairs(awardDocument.getAward().getAwardFandaRate());
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "enable.award.FnA.validation"), (CharSequence)"2")) {
                rulePassed = this.checkValidFandARate(awardFandaRate, propertyPrefix);
            }
        }
        return rulePassed;
    }

    protected boolean evaluateRuleForApplicableFandaRate(AwardFandaRate awardFandaRate, String propertyPrefix) {
        String brokenRule = null;
        if (awardFandaRate.getApplicableFandaRate() == null || StringUtils.isBlank((CharSequence)awardFandaRate.getApplicableFandaRate().toString())) {
            brokenRule = "error.required.applicable.indirect.cost.rate";
        } else if (awardFandaRate.getApplicableFandaRate().isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            brokenRule = "error.applicable.indirect.cost.rate.can.not.be.negative";
        } else if (awardFandaRate.getApplicableFandaRate().isGreaterEqual((AbstractDecimal)ScaleTwoDecimal_THOUSAND)) {
            brokenRule = "error.applicable.indirect.cost.rate.out.of.range";
        }
        if (brokenRule != null) {
            this.reportError(propertyPrefix + ".applicableFandaRate", brokenRule, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean evaluateRuleForFandaRateTypeCode(AwardFandaRate awardFandaRate, String propertyPrefix) {
        boolean rulePassed;
        boolean bl = rulePassed = awardFandaRate.getFandaRateTypeCode() != null && !StringUtils.isBlank((CharSequence)awardFandaRate.getFandaRateTypeCode().toString());
        if (!rulePassed) {
            this.reportError(propertyPrefix + ".fandaRateTypeCode", "error.required.indirect.rate.type.code", new String[0]);
        }
        return rulePassed;
    }

    protected boolean evaluateRuleForFiscalYear(AwardFandaRate awardFandaRate, String propertyPrefix) {
        boolean rulePassed = true;
        if (awardFandaRate.getFiscalYear() == null || StringUtils.isBlank((CharSequence)awardFandaRate.getFiscalYear())) {
            rulePassed = false;
            this.reportError(propertyPrefix + FISCAL_YEAR_STRING, "error.required.fiscal.year", new String[0]);
        } else if (awardFandaRate.getFiscalYear().length() != 4) {
            rulePassed = false;
            this.reportError(propertyPrefix + FISCAL_YEAR_STRING, "error.fiscalYear.IncorrectFormat", "Fiscal Year");
        } else {
            try {
                Integer.parseInt(awardFandaRate.getFiscalYear());
            }
            catch (NumberFormatException e) {
                rulePassed = false;
                this.reportError(propertyPrefix + FISCAL_YEAR_STRING, "error.fiscalYear.IncorrectFormat", new String[0]);
            }
        }
        return rulePassed;
    }

    protected boolean evaluateRuleForStartAndEndDates(AwardFandaRate awardFandaRate, String propertyPrefix) {
        boolean rule2Passed;
        boolean rule1Passed = awardFandaRate.getStartDate() != null && !StringUtils.isBlank((CharSequence)awardFandaRate.getStartDate().toString());
        String[] DATE_PARAMS = new String[]{"Start Date", "End Date"};
        if (!rule1Passed) {
            this.reportError(propertyPrefix + ".startDate", "error.required.start.date", new String[0]);
        }
        boolean bl = rule2Passed = awardFandaRate.getEndDate() == null || awardFandaRate.getStartDate() == null || !awardFandaRate.getEndDate().before(awardFandaRate.getStartDate());
        if (!rule2Passed) {
            this.reportError(propertyPrefix + ".endDate", "error.endDate.before.startDate.for.valid.indirectCostRate", DATE_PARAMS);
        }
        return rule1Passed && rule2Passed;
    }

    public boolean checkValidFandARate(AwardFandaRate awardFandaRate, String propertyPrefix) {
        boolean valid = true;
        String enableFandAValidation = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "enable.award.FnA.validation");
        if (StringUtils.equalsIgnoreCase((CharSequence)enableFandAValidation, (CharSequence)"1") || StringUtils.equalsIgnoreCase((CharSequence)enableFandAValidation, (CharSequence)"2")) {
            Collection<ValidRates> validRates = null;
            String onOFFCampusRate = null;
            if (awardFandaRate.getOnCampusFlag().equalsIgnoreCase("N")) {
                onOFFCampusRate = ON_CAMPUS;
                validRates = this.getValidRatesForFandA(ON_CAMPUS_RATE, awardFandaRate.getApplicableFandaRate());
            } else {
                validRates = this.getValidRatesForFandA(OFF_CAMPUS_RATE, awardFandaRate.getApplicableFandaRate());
                onOFFCampusRate = OFF_CAMPUS;
            }
            if (validRates.size() == 0) {
                valid = false;
                ScaleTwoDecimal kdApplicableFandaRate = awardFandaRate.getApplicableFandaRate();
                String strApplicableFandaRate = kdApplicableFandaRate != null ? awardFandaRate.getApplicableFandaRate().toString() : "0";
                if (StringUtils.equalsIgnoreCase((CharSequence)this.getParameterService().getParameterValueAsString(AwardDocument.class, "option.warning.error.award.FnA.validation"), (CharSequence)"E")) {
                    this.reportError(propertyPrefix + ".applicableFandaRate", "error.awardDirectFandADistribution.invalid.rate.for.single.rate", strApplicableFandaRate, onOFFCampusRate);
                } else {
                    valid = true;
                    this.reportWarning(propertyPrefix + ".applicableFandaRate", "error.awardDirectFandADistribution.invalid.rate.for.single.rate", awardFandaRate.getApplicableFandaRate().toString(), onOFFCampusRate);
                }
            }
        }
        return valid;
    }

    private Collection<ValidRates> getValidRatesForFandA(String rateTypeOnOrOff, ScaleTwoDecimal rate) {
        HashMap<String, Object> rateValues = new HashMap<String, Object>();
        rateValues.put(rateTypeOnOrOff, rate);
        rateValues.put(RATE_CLASS_TYPE, FANDA_RATE_CLASS_TYPE);
        return this.getKraBusinessObjectService().findMatching(ValidRates.class, rateValues);
    }

    BusinessObjectService getKraBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KcServiceLocator.getService("businessObjectService");
        }
        return this.businessObjectService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected boolean isFandaRateInputInPairs(List<AwardFandaRate> awardFandaRateList) {
        HashMap<String, String> a1 = new HashMap<String, String>();
        HashMap<String, String> b1 = new HashMap<String, String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        this.createHashMapsForRuleEvaluation(awardFandaRateList, a1, b1);
        boolean valid = this.evaluateRule(awardFandaRateList, a1, b1);
        if (!valid) {
            GlobalVariables.getMessageMap().putError(FANDA_RATES, "indirectCostRate.not.in.pair", new String[0]);
        }
        this.isPairChecked = true;
        if (valid) {
            int i = 0;
            for (AwardFandaRate awardFandaRate1 : awardFandaRateList) {
                if (StringUtils.equalsIgnoreCase((CharSequence)awardFandaRate1.getOnCampusFlag(), (CharSequence)"N")) {
                    int j = 0;
                    if (this.getValidRatesForFandA(ON_CAMPUS_RATE, awardFandaRate1.getApplicableFandaRate()).size() > 0) {
                        for (AwardFandaRate awardFandaRate2 : awardFandaRateList) {
                            if (StringUtils.equalsIgnoreCase((CharSequence)awardFandaRate2.getOnCampusFlag(), (CharSequence)"F") && awardFandaRate1.getFandaRateTypeCode().equals(awardFandaRate2.getFandaRateTypeCode()) && this.getValidRates(awardFandaRate1.getApplicableFandaRate(), awardFandaRate2.getApplicableFandaRate()).size() == 0) {
                                valid = false;
                                this.reportError("document.awardList[0].awardFandaRate[" + j + "].applicableFandaRate", "error.awardDirectFandADistribution.invalid.rate", this.getFandACodeTypeDescription(awardFandaRate2.getFandaRateTypeCode()), awardFandaRate2.getFiscalYear(), dateFormat.format(awardFandaRate2.getStartDate()));
                            }
                            ++j;
                        }
                    } else {
                        valid = false;
                        this.reportError("document.awardList[0].awardFandaRate[" + i + "].applicableFandaRate", "error.awardDirectFandADistribution.invalid.rate", this.getFandACodeTypeDescription(awardFandaRate1.getFandaRateTypeCode()), awardFandaRate1.getFiscalYear(), dateFormat.format(awardFandaRate1.getStartDate()));
                    }
                }
                ++i;
            }
        }
        return valid;
    }

    protected void createHashMapsForRuleEvaluation(List<AwardFandaRate> awardFandaRateList, HashMap<String, String> a1, HashMap<String, String> b1) {
        for (AwardFandaRate awardFandaRate : awardFandaRateList) {
            if (StringUtils.equalsIgnoreCase((CharSequence)awardFandaRate.getOnCampusFlag(), (CharSequence)"N")) {
                a1.put(awardFandaRate.getFandaRateTypeCode(), awardFandaRate.getOnCampusFlag());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)awardFandaRate.getOnCampusFlag(), (CharSequence)"F")) continue;
            b1.put(awardFandaRate.getFandaRateTypeCode(), awardFandaRate.getOnCampusFlag());
        }
    }

    protected boolean evaluateRule(List<AwardFandaRate> awardFandaRateList, HashMap<String, String> a1, HashMap<String, String> b1) {
        boolean valid = true;
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        for (AwardFandaRate awardFandaRate : awardFandaRateList) {
            if ((!a1.containsKey(awardFandaRate.getFandaRateTypeCode()) || b1.containsKey(awardFandaRate.getFandaRateTypeCode())) && (!b1.containsKey(awardFandaRate.getFandaRateTypeCode()) || a1.containsKey(awardFandaRate.getFandaRateTypeCode()))) continue;
            valid = false;
        }
        return valid;
    }

    private String getFandACodeTypeDescription(String rateTypeCode) {
        String description = "";
        if (rateTypeCode != null) {
            HashMap<String, String> rateValues = new HashMap<String, String>();
            rateValues.put(RATE_CLASS_TYPE_CODE, rateTypeCode.toString());
            List fandaRteTypes = this.getKraBusinessObjectService().findMatching(FandaRateType.class, rateValues);
            if (fandaRteTypes != null && fandaRteTypes.size() > 0) {
                for (FandaRateType fandaRateType : fandaRteTypes) {
                    if (fandaRateType.getDescription() == null) continue;
                    description = fandaRateType.getDescription();
                }
            }
        }
        return description;
    }

    Collection<ValidRates> getValidRates(ScaleTwoDecimal specialEbRateOnCampus, ScaleTwoDecimal specialEbRateOffCampus) {
        HashMap<String, Object> rateValues = new HashMap<String, Object>();
        rateValues.put(ON_CAMPUS_RATE, specialEbRateOnCampus);
        rateValues.put(OFF_CAMPUS_RATE, specialEbRateOffCampus);
        rateValues.put(RATE_CLASS_TYPE, FANDA_RATE_CLASS_TYPE);
        return this.getKraBusinessObjectService().findMatching(ValidRates.class, rateValues);
    }
}

