/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.excon.project.ExconProjectType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectTypeCodeValuesFinder
extends UifKeyValuesFinderBase {
    private static final long serialVersionUID = 82345259246485395L;
    private transient BusinessObjectService businessObjectService;
    private transient PermissionService permissionService;

    public List<KeyValue> getKeyValues() {
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        List<KeyValue> result = this.getBusinessObjectService().findAll(ExconProjectType.class).stream().filter(type -> this.getPermissionService().isAuthorized(principalId, "KC-EXCON", "Create Project Document", Map.of("projectTypeCode", type.getProjectTypeCode()))).map(type -> new ConcreteKeyValue(type.getProjectTypeCode(), type.getDescription())).sorted(Comparator.comparing(KeyValue::getValue)).collect(Collectors.toList());
        if (this.isAddBlankOption()) {
            result.add(0, ValuesFinderUtils.getSelectOption());
        }
        return result;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

