/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.finance.dao.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.ListUtils;
import org.kuali.coeus.award.finance.AwardAccount;
import org.kuali.coeus.award.finance.AwardPosts;
import org.kuali.coeus.award.finance.dao.AccountDao;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="accountDao")
public class AccountDaoJpa
implements AccountDao {
    public static final String ACCOUNT_NUMBER = "accountNumber";
    public static final String AWARD_ID = "awardId";
    public static final String ALL_ACCOUNTS_QUERY = "select a from AwardAccount a ORDER BY a.id ASC";
    public static final String ACTIVE = "active";
    public static final String UPDATE_TIMESTAMP = "updateTimestamp";
    public static final String AWARD_FAMILY = "awardFamily";
    private static final String AWARD_NUMBER = "awardNumber";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="awardDao")
    private AwardDao awardDao;
    @Autowired
    @Qualifier(value="kcEntityManager")
    private EntityManager entityManager;

    @Override
    public List<AwardAccount> getAccounts(Integer startIndex, Integer size) {
        TypedQuery query = this.getEntityManager().createQuery(ALL_ACCOUNTS_QUERY, AwardAccount.class);
        if (startIndex != null && size != null) {
            query.setFirstResult(startIndex.intValue());
            query.setMaxResults(size.intValue());
        }
        List accounts = query.getResultList();
        return ListUtils.emptyIfNull((List)accounts);
    }

    @Override
    public AwardAccount getAccount(String accountNumber) {
        AwardAccount account = (AwardAccount)this.getDataObjectService().findUnique(AwardAccount.class, QueryByCriteria.Builder.forAttribute((String)ACCOUNT_NUMBER, (Object)accountNumber).build());
        return account;
    }

    @Override
    public AwardAccount saveAccount(AwardAccount account) {
        account = (AwardAccount)this.getDataObjectService().save((Object)account, new PersistenceOption[0]);
        return account;
    }

    @Override
    public List<AwardPosts> getActiveAwardPosts(String accountNumber) {
        HashMap<String, Object> keys = new HashMap<String, Object>();
        if (accountNumber != null) {
            keys.put(ACCOUNT_NUMBER, accountNumber);
        }
        keys.put(ACTIVE, Boolean.TRUE);
        return this.getDataObjectService().findMatching(AwardPosts.class, QueryByCriteria.Builder.andAttributes(keys).build()).getResults();
    }

    @Override
    public List<AwardPosts> getAllAwardPostsInHierarchy(String awardNumber) {
        String awardFamily = AwardService.getAwardFamily(awardNumber);
        Map<String, String> keys = Map.of(AWARD_FAMILY, awardFamily);
        ArrayList<OrderByField> orderByFields = new ArrayList<OrderByField>();
        orderByFields.add(OrderByField.Builder.create((String)UPDATE_TIMESTAMP, (OrderDirection)OrderDirection.DESCENDING).build());
        return this.getDataObjectService().findMatching(AwardPosts.class, QueryByCriteria.Builder.andAttributes(keys).setOrderByFields(orderByFields).build()).getResults();
    }

    @Override
    public List<AwardPosts> getAllPostsForAwardNumber(String awardNumber) {
        Map<String, Object> keys = Map.of(AWARD_NUMBER, awardNumber);
        List awardIds = this.awardDao.retrieveAwardsByCriteria(keys).stream().map(Award::getAwardId).collect(Collectors.toList());
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.in((String)AWARD_ID, awardIds)});
        ArrayList<OrderByField> orderByFields = new ArrayList<OrderByField>();
        orderByFields.add(OrderByField.Builder.create((String)UPDATE_TIMESTAMP, (OrderDirection)OrderDirection.DESCENDING).build());
        List posts = this.getDataObjectService().findMatching(AwardPosts.class, builder.setOrderByFields(orderByFields).build()).getResults();
        return posts;
    }

    @Override
    public AwardPosts getAwardPostsById(Long postId) {
        return (AwardPosts)this.getDataObjectService().find(AwardPosts.class, (Object)postId);
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

