/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.attachment;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLogger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerFactory;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api/v1/file-data"})
@Controller(value="fileDataController")
public class FileDataController
extends RestController {
    private static final String FILE_DATA = "FileData";
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kcAttachmentDataDao")
    private KcAttachmentDataDao kcAttachmentDataDao;
    @Autowired
    @Qualifier(value="restAuditLoggerFactory")
    private RestAuditLoggerFactory restAuditLoggerFactory;

    @RequestMapping(method={RequestMethod.GET}, value={"/{fileDataId}"}, produces={"application/octet-stream"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public byte[] getFileData(@PathVariable String fileDataId) {
        this.assertUserHasReadAccess();
        byte[] data = this.kcAttachmentDataDao.getData(fileDataId);
        if (ArrayUtils.isEmpty((byte[])data)) {
            throw new ResourceNotFoundException("File Data with fileDataId " + fileDataId + " not found.");
        }
        return data;
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/octet-stream"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public String add(@RequestBody byte[] data) throws IOException {
        this.assertUserHasWriteAccess();
        String fileDataId = this.getKcAttachmentDataDao().saveData(data, null);
        RestAuditLogger logger = this.getAuditLogger();
        logger.addNewItem(new FileData(fileDataId, data));
        logger.saveAuditLog();
        return fileDataId;
    }

    @RequestMapping(value={"/{fileDataId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable String fileDataId) {
        this.assertUserHasWriteAccess();
        if (StringUtils.isNotBlank((CharSequence)fileDataId)) {
            byte[] existingData = this.getKcAttachmentDataDao().getData(fileDataId);
            RestAuditLogger logger = this.getAuditLogger();
            logger.addDeletedItem(new FileData(fileDataId, existingData));
            this.getKcAttachmentDataDao().removeData(fileDataId);
            logger.saveAuditLog();
        }
    }

    protected void assertUserHasReadAccess() {
        if (this.getGlobalVariableService().getUserSession() == null || !this.getPermissionService().hasPermissionByTemplate(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", FILE_DATA))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.getGlobalVariableService().getUserSession() == null || !this.getPermissionService().hasPermissionByTemplate(this.getGlobalVariableService().getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", FILE_DATA))) {
            throw new UnauthorizedAccessException();
        }
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public KcAttachmentDataDao getKcAttachmentDataDao() {
        return this.kcAttachmentDataDao;
    }

    public void setKcAttachmentDataDao(KcAttachmentDataDao kcAttachmentDataDao) {
        this.kcAttachmentDataDao = kcAttachmentDataDao;
    }

    protected RestAuditLogger getAuditLogger() {
        return this.restAuditLoggerFactory.getNewAuditLogger(FileData.class, List.of("fileDataId", "data"));
    }

    private static final class FileData {
        private final byte[] data;
        private final String fileDataId;

        private FileData(String fileDataId, byte[] data) {
            this.fileDataId = fileDataId;
            this.data = data;
        }

        public String getFileDataId() {
            return this.fileDataId;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

