/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.lookup.LookupableImpl;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="unitLookupableKrad")
@Scope(value="prototype")
public class UnitLookupableKrad
extends LookupableImpl {
    private static final String ACTIVE_FIELD = "active";

    public Collection<?> performSearch(LookupForm form, Map<String, String> searchCriteria, boolean unbounded) {
        String activeFlag = searchCriteria.get(ACTIVE_FIELD);
        Collection results = super.performSearch(form, searchCriteria, unbounded);
        Boolean activeFilter = this.normalizeActiveFlag(activeFlag);
        if (activeFilter == null) {
            return results;
        }
        if (results instanceof List) {
            return ((List)results).stream().filter(obj -> {
                if (obj instanceof Unit) {
                    return ((Unit)obj).isActive() == activeFilter.booleanValue();
                }
                return true;
            }).collect(Collectors.toList());
        }
        return results;
    }

    private Boolean normalizeActiveFlag(String flag) {
        if (StringUtils.isBlank((CharSequence)flag)) {
            return null;
        }
        String f = StringUtils.trim((String)flag);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)f, (CharSequence[])new CharSequence[]{"B", "Both"})) {
            return null;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)f, (CharSequence[])new CharSequence[]{"Y", "YES", "TRUE", "T", "1", "ON"})) {
            return Boolean.TRUE;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)f, (CharSequence[])new CharSequence[]{"N", "NO", "FALSE", "F", "0", "OFF"})) {
            return Boolean.FALSE;
        }
        return null;
    }
}

