/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.budget.api.standalone.StandaloneBudgetImportService;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocValue;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyException;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.state.ProposalStateService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcDocumentRejectionService;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DocumentHeaderService;
import org.kuali.rice.krad.util.NoteType;
import org.kuali.rice.krad.workflow.DocumentInitiator;
import org.kuali.rice.krad.workflow.KualiDocumentXmlMaterializer;
import org.kuali.rice.krad.workflow.KualiTransactionalDocumentInformation;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-PD")
@ParameterConstants.COMPONENT(component="Document")
@Entity
@Table(name="EPS_PROPOSAL_DOCUMENT")
public class ProposalDevelopmentDocument
extends BudgetParentDocument<DevelopmentProposal>
implements Copyable,
SessionDocument,
KrmsRulesContext,
ProposalDevelopmentDocumentContract {
    public static final String PEOPLE_FLOWS = "PeopleFlows";
    private static final String KC_GEN = "KC-GEN";
    private static Logger LOG = LogManager.getLogger(ProposalDevelopmentDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "PRDV";
    private static final String KRA_EXTERNALIZABLE_IMAGES_URI_KEY = "kra.externalizable.images.url";
    private static final String RETURN_TO_PROPOSAL_ALT_TEXT = "return to proposal";
    private static final String RETURN_TO_PROPOSAL_METHOD_TO_CALL = "methodToCall.returnToProposal";
    private static final String HIERARCHY_CHILD_SPLITNODE_QUESTION = "isHierarchyChild";
    @Transient
    private transient DocumentHeaderService documentHeaderService;
    @Transient
    private transient ProposalHierarchyService proposalHierarchyService;
    @Transient
    private transient ProposalStateService proposalStateService;
    @Transient
    private transient KcDocumentRejectionService kcDocumentRejectionService;
    @Transient
    private transient WorkflowDocumentService workflowDocumentService;
    @Transient
    InstitutionalProposalService institutionalProposalService;
    @Transient
    private transient WorkflowDocumentActionsService workflowDocumentActionsService;
    @Transient
    private transient RouteNodeService routeNodeService;
    @Transient
    private transient DataDictionaryService dataDictionaryService;
    @Transient
    private transient DataObjectService dataObjectService;
    @Transient
    private transient KcKrmsFactBuilderServiceHelper proposalDevelopmentFactBuilderService;
    @Transient
    private transient StandaloneBudgetImportService standaloneBudgetImportService;
    @Column(name="PROPOSAL_DELETED")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean proposalDeleted = Boolean.FALSE;
    @OneToOne(orphanRemoval=true, mappedBy="proposalDocument", cascade={CascadeType.ALL})
    private DevelopmentProposal developmentProposal;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="DOCUMENT_NUMBER", referencedColumnName="DOCUMENT_NUMBER")
    private List<CustomAttributeDocValue> customDataList;
    @Transient
    private String institutionalProposalNumber;
    @Transient
    private transient Boolean allowsNoteAttachments;
    @Transient
    private transient ProjectRetrievalService propDevProjectRetrievalService;
    @Transient
    private transient ProjectPublisher projectPublisher;

    public ProposalDevelopmentDocument() {
        DevelopmentProposal newProposal = new DevelopmentProposal();
        newProposal.setProposalDocument(this);
        this.developmentProposal = newProposal;
        this.customDataList = new ArrayList<CustomAttributeDocValue>();
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal proposal) {
        this.developmentProposal = proposal;
    }

    @Override
    public KcPersistableBusinessObjectBase getBusinessObject() {
        return this.getDevelopmentProposal();
    }

    public String getInstitutionalProposalNumber() {
        return this.institutionalProposalNumber;
    }

    public void setInstitutionalProposalNumber(String institutionalProposalNumber) {
        this.institutionalProposalNumber = institutionalProposalNumber;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getDevelopmentProposal().initializeOwnedByUnitNumber();
    }

    protected ProposalHierarchyService getProposalHierarchyService() {
        if (this.proposalHierarchyService == null) {
            this.proposalHierarchyService = KcServiceLocator.getService(ProposalHierarchyService.class);
        }
        return this.proposalHierarchyService;
    }

    protected ProposalStateService getProposalStateService() {
        if (this.proposalStateService == null) {
            this.proposalStateService = KcServiceLocator.getService(ProposalStateService.class);
        }
        return this.proposalStateService;
    }

    protected KcDocumentRejectionService getKcDocumentRejectionService() {
        if (this.kcDocumentRejectionService == null) {
            this.kcDocumentRejectionService = KcServiceLocator.getService(KcDocumentRejectionService.class);
        }
        return this.kcDocumentRejectionService;
    }

    protected WorkflowDocumentService getWorkflowDocumentService() {
        if (this.workflowDocumentService == null) {
            this.workflowDocumentService = KewApiServiceLocator.getWorkflowDocumentService();
        }
        return this.workflowDocumentService;
    }

    protected InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KcServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    protected WorkflowDocumentActionsService getWorkflowDocumentActionsService() {
        if (this.workflowDocumentActionsService == null) {
            this.workflowDocumentActionsService = KewApiServiceLocator.getWorkflowDocumentActionsService();
        }
        return this.workflowDocumentActionsService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KcServiceLocator.getService(DataDictionaryService.class);
        }
        return this.dataDictionaryService;
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    protected KcKrmsFactBuilderServiceHelper getProposalDevelopmentFactBuilderService() {
        if (this.proposalDevelopmentFactBuilderService == null) {
            this.proposalDevelopmentFactBuilderService = (KcKrmsFactBuilderServiceHelper)KcServiceLocator.getService("proposalDevelopmentFactBuilderService");
        }
        return this.proposalDevelopmentFactBuilderService;
    }

    protected StandaloneBudgetImportService getStandaloneBudgetImportService() {
        if (this.standaloneBudgetImportService == null) {
            this.standaloneBudgetImportService = KcServiceLocator.getService(StandaloneBudgetImportService.class);
        }
        return this.standaloneBudgetImportService;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange dto) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(dto);
            String newStatus = dto.getNewRouteStatus();
            String oldStatus = dto.getOldRouteStatus();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Route Status change for document %s from %s to %s", this.getDocumentNumber(), oldStatus, newStatus));
            }
            if (!this.isProposalDeleted()) {
                DevelopmentProposal bp = this.getDevelopmentProposal();
                LOG.info(String.format("Route status change for document %s - proposal number %s is moving from %s to %s", bp.getProposalDocument().getDocumentHeader().getDocumentNumber(), bp.getProposalNumber(), oldStatus, newStatus));
                if (!bp.isInHierarchy()) {
                    try {
                        this.getProposalHierarchyService().calculateAndSetProposalAppDocStatus(this, dto);
                    }
                    catch (ProposalHierarchyException pe) {
                        throw new RuntimeException(String.format("ProposalHierarchyException thrown while updating app doc status for document %s", this.getDocumentNumber()), pe);
                    }
                } else {
                    this.getProposalHierarchyService().updateChildProposalsDocumentStatus(this, dto);
                    if (!bp.isChild()) {
                        this.getProposalHierarchyService().reindexProposal(this);
                    }
                }
                bp.setProposalStateTypeCode(this.getProposalStateService().getProposalStateTypeCode(this, false));
                this.getDataObjectService().save((Object)bp, new PersistenceOption[]{PersistenceOption.LINK_KEYS, PersistenceOption.FLUSH});
            }
            if (this.getDevelopmentProposal() != null) {
                Project project = this.getProjectRetrievalService().retrieveProject(this.getDevelopmentProposal().getProposalNumber());
                if (project != null) {
                    this.getProjectPublisher().publishProject(project);
                }
                if (this.getStandaloneBudgetImportService().isEnabled()) {
                    this.getStandaloneBudgetImportService().proposalUpdated(this.getDevelopmentProposal().getProposalNumber());
                }
            }
            return null;
        });
    }

    public List<ProposalDevelopmentDocumentContract> getHierarchyChildren() {
        return this.getProposalHierarchyService().getHierarchyChildren(this.getDevelopmentProposal().getProposalNumber()).stream().map(DevelopmentProposal::getProposalDocument).collect(Collectors.toList());
    }

    public void doActionTaken(ActionTakenEvent event) {
        this.executeAsLastActionUser(() -> {
            super.doActionTaken(event);
            ActionTaken actionTaken = event.getActionTaken();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Action taken on document %s: event code %s, action taken is %s", this.getDocumentNumber(), event.getDocumentEventCode(), actionTaken.getActionTaken().getCode()));
            }
            if (!this.isProposalDeleted()) {
                if (this.getDevelopmentProposal() != null && this.getDevelopmentProposal().isInHierarchy() && !this.getDevelopmentProposal().isChild()) {
                    this.getProposalHierarchyService().reindexChildProposals(this);
                    this.getProposalHierarchyService().reindexProposal(this);
                }
                if (StringUtils.equals((CharSequence)"A", (CharSequence)actionTaken.getActionTaken().getCode())) {
                    try {
                        if (this.getKcDocumentRejectionService().isDocumentOnInitialNode(this.getDocumentHeader().getWorkflowDocument())) {
                            DocumentRouteStatusChange dto = new DocumentRouteStatusChange(this.getDocumentHeader().getWorkflowDocument().getDocumentId(), this.getDocumentNumber(), "R", "R");
                            if (!this.getDevelopmentProposal().isChild()) {
                                this.getProposalHierarchyService().calculateAndSetProposalAppDocStatus(this, dto);
                            }
                        }
                    }
                    catch (ProposalHierarchyException pe) {
                        throw new RuntimeException(String.format("ProposalHierarchyException encountered trying to re-submit returned parent document:%s", this.getDocumentNumber()), pe);
                    }
                    catch (Exception we) {
                        throw new RuntimeException(String.format("Exception trying to re-submit returned parent:%s", this.getDocumentNumber()), we);
                    }
                }
                String pCode = this.getDevelopmentProposal().getProposalStateTypeCode();
                this.getDevelopmentProposal().setProposalStateTypeCode(this.getProposalStateService().getProposalStateTypeCode(this, this.hasProposalBeenRejected(this.getDocumentHeader().getWorkflowDocument())));
                if (!StringUtils.equals((CharSequence)pCode, (CharSequence)this.getDevelopmentProposal().getProposalStateTypeCode())) {
                    this.getDataObjectService().save((Object)this.getDevelopmentProposal(), new PersistenceOption[]{PersistenceOption.LINK_KEYS, PersistenceOption.FLUSH});
                    this.getDevelopmentProposal().refreshReferenceObject("proposalState");
                }
                if (this.getDevelopmentProposal().isChild() && StringUtils.equals((CharSequence)"X", (CharSequence)actionTaken.getActionTaken().getCode())) {
                    try {
                        this.getProposalHierarchyService().removeFromHierarchy(this.getDevelopmentProposal());
                    }
                    catch (ProposalHierarchyException e) {
                        throw new RuntimeException(String.format("COULD NOT REMOVE CHILD:%s", this.getDevelopmentProposal().getProposalNumber()), e);
                    }
                }
                if (this.isLastSubmitterApprovalAction(event.getActionTaken()) && this.shouldAutogenerateInstitutionalProposal()) {
                    InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().createInstitutionalProposal(this.getDevelopmentProposal());
                    this.setInstitutionalProposalNumber(institutionalProposal.getProposalNumber());
                    this.getDataObjectService().save((Object)this, new PersistenceOption[]{PersistenceOption.LINK_KEYS, PersistenceOption.FLUSH});
                }
            }
            if (this.getDevelopmentProposal() != null) {
                Project project = this.getProjectRetrievalService().retrieveProject(this.getDevelopmentProposal().getProposalNumber());
                if (project != null) {
                    this.getProjectPublisher().publishProject(project);
                }
                if (this.getStandaloneBudgetImportService().isEnabled()) {
                    this.getStandaloneBudgetImportService().proposalUpdated(this.getDevelopmentProposal().getProposalNumber());
                }
            }
            return null;
        });
    }

    public void doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) {
        this.executeAsLastActionUser(() -> {
            super.doRouteLevelChange(levelChangeEvent);
            if (!"Initiated".equals(levelChangeEvent.getOldNodeName()) && "Initiated".equals(levelChangeEvent.getNewNodeName())) {
                DocumentRouteStatusChange dto = new DocumentRouteStatusChange(levelChangeEvent.getDocumentId(), levelChangeEvent.getDocumentId(), "R", "S");
                this.getProposalHierarchyService().updateChildProposalsDocumentStatus(this, dto);
            }
            return null;
        });
    }

    private boolean hasProposalBeenRejected(WorkflowDocument document) {
        return this.getKcDocumentRejectionService().isDocumentOnInitialNode(document) && this.getWorkflowDocumentService().getAllActionsTaken(this.getDocumentNumber()).stream().anyMatch(actionTaken -> actionTaken.getActionTaken() == ActionType.COMPLETE);
    }

    private boolean isLastSubmitterApprovalAction(ActionTaken actionTaken) {
        return actionTaken.getActionTaken().getCode().equals("A") && this.getWorkflowDocumentActionsService().isFinalApprover(actionTaken.getDocumentId(), actionTaken.getPrincipalId());
    }

    private boolean shouldAutogenerateInstitutionalProposal() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "proposaldevelopment.autogenerate.institutionalproposal");
    }

    protected DateTimeService getDateTimeService() {
        return KcServiceLocator.getService(DateTimeService.class);
    }

    public String getFinalrateClassCode() {
        String retVal = "";
        ProposalDevelopmentBudgetExt finalBudget = this.getDevelopmentProposal().getFinalBudget();
        if (finalBudget != null && finalBudget.getRateClass().getCode() != null) {
            retVal = finalBudget.getRateClass().getCode();
        }
        return retVal;
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public KualiDocumentXmlMaterializer wrapDocumentWithMetadataForXmlSerialization() {
        KualiTransactionalDocumentInformation transInfo = new KualiTransactionalDocumentInformation();
        DocumentInitiator initiator = new DocumentInitiator();
        String initiatorPrincipalId = this.getDocumentHeader().getWorkflowDocument().getDocument().getInitiatorPrincipalId();
        Person initiatorUser = KimApiServiceLocator.getPersonService().getPerson(initiatorPrincipalId);
        initiator.setPerson(initiatorUser);
        transInfo.setDocumentInitiator(initiator);
        PropDevDocumentXMLMaterializer xmlWrapper = new PropDevDocumentXMLMaterializer();
        xmlWrapper.setDocument(this);
        xmlWrapper.setKualiTransactionalDocumentInformation(transInfo);
        xmlWrapper.setRolepersons(this.getAllRolePersons());
        return xmlWrapper;
    }

    @Override
    public void prepareForSave() {
        List<ProposalDevelopmentBudgetExt> versions;
        super.prepareForSave();
        this.documentHeader = this.getDocumentHeaderService().saveDocumentHeader(this.documentHeader);
        if (!this.isProposalDeleted() && (versions = this.getBudgetParent().getBudgets()) != null) {
            this.updateBudgetDescriptions(versions);
        }
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        if (!this.isProposalDeleted()) {
            this.getDevelopmentProposal().updateProposalChangeHistory();
            this.getDevelopmentProposal().updateBudgetChangeHistory();
        }
    }

    public Boolean getAllowsNoteAttachments() {
        if (this.allowsNoteAttachments == null) {
            DocumentEntry entry = this.getDataDictionaryService().getDataDictionary().getDocumentEntry(this.getClass().getName());
            this.allowsNoteAttachments = entry.getAllowsNoteAttachments();
        }
        return this.allowsNoteAttachments;
    }

    public void setAllowsNoteAttachments(boolean allowsNoteAttachments) {
        this.allowsNoteAttachments = allowsNoteAttachments;
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.add("Aggregator");
        roleNames.add("Budget Creator");
        roleNames.add("Narrative Writer");
        roleNames.add("Viewer");
        roleNames.add("approver");
        return roleNames;
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getDevelopmentProposal().getProposalNumber();
    }

    @Override
    public String getDocumentKey() {
        return "proposal";
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.addAll(this.getDevelopmentProposal().buildListOfDeletionAwareLists());
        return managedLists;
    }

    @Override
    public boolean isComplete() {
        return this.getDevelopmentProposal().isProposalComplete();
    }

    @Override
    public ExtraButton configureReturnToParentTopButton() {
        ExtraButton returnToProposalButton = new ExtraButton();
        returnToProposalButton.setExtraButtonProperty(RETURN_TO_PROPOSAL_METHOD_TO_CALL);
        returnToProposalButton.setExtraButtonSource(this.buildExtraButtonSourceURI("tinybutton-retprop.gif"));
        returnToProposalButton.setExtraButtonAltText(RETURN_TO_PROPOSAL_ALT_TEXT);
        return returnToProposalButton;
    }

    private String buildExtraButtonSourceURI(String buttonFileName) {
        return this.getConfigurationService().getPropertyValueAsString(KRA_EXTERNALIZABLE_IMAGES_URI_KEY) + buttonFileName;
    }

    @Override
    public DevelopmentProposal getBudgetParent() {
        return this.getDevelopmentProposal();
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getDevelopmentProposal().getProposalNumber();
    }

    @Override
    public Permissionable getBudgetPermissionable() {
        return new Permissionable(){

            @Override
            public String getDocumentKey() {
                return "proposalbudget";
            }

            @Override
            public String getDocumentNumberForPermission() {
                return ProposalDevelopmentDocument.this.getDevelopmentProposal().getProposalNumber();
            }

            @Override
            public List<String> getRoleNames() {
                return new ArrayList<String>();
            }

            @Override
            public String getNamespace() {
                return "KC-B";
            }

            @Override
            public String getLeadUnitNumber() {
                return ProposalDevelopmentDocument.this.getDevelopmentProposal().getOwnedByUnitNumber();
            }

            @Override
            public String getDocumentRoleTypeCode() {
                return "KC-PD";
            }

            @Override
            public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
            }
        };
    }

    @Override
    public boolean answerSplitNodeQuestion(String routeNodeName) {
        LOG.debug("Processing answerSplitNodeQuestion:" + routeNodeName);
        if (StringUtils.equals((CharSequence)HIERARCHY_CHILD_SPLITNODE_QUESTION, (CharSequence)routeNodeName)) {
            return this.getDevelopmentProposal().isChild();
        }
        return super.answerSplitNodeQuestion(routeNodeName);
    }

    @Override
    public String getNamespace() {
        return "KC-PD";
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getDevelopmentProposal().getOwnedByUnitNumber();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-PD";
    }

    public String getProposalBudgetFlag() {
        return "true";
    }

    @Override
    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && ("R".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode()) || "P".equals(docRouteStatus) || "F".equals(docRouteStatus))) {
            isComplete = true;
        }
        return isComplete;
    }

    public boolean isProposalDeleted() {
        return this.proposalDeleted;
    }

    public void setProposalDeleted(boolean proposalDeleted) {
        this.proposalDeleted = proposalDeleted;
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-PD");
        qualifiers.put("name", "KC Proposal Development Context");
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        this.getProposalDevelopmentFactBuilderService().addFacts(factsBuilder, this);
    }

    @Override
    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getDevelopmentProposal().getAllUnitNumbers());
    }

    public void setDefaultDocumentDescription() {
        DevelopmentProposal proposal = this.getDevelopmentProposal();
        String desc = String.format("%s; Proposal No: %s; PI: %s; Sponsor: %s; Due Date: %s", proposal.getTitle() != null ? proposal.getTitle().substring(0, Math.min(proposal.getTitle().length(), 19)) : "null", proposal.getProposalNumber(), proposal.getPrincipalInvestigatorName(), proposal.getSponsorName(), proposal.getDeadlineDate() != null ? this.getDateTimeService().toDateString((Date)proposal.getDeadlineDate()) : "null");
        this.getDocumentHeader().setDocumentDescription(desc);
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getCustomDataList();
    }

    public List<CustomAttributeDocValue> getCustomDataList() {
        return this.customDataList;
    }

    public void setCustomDataList(List<CustomAttributeDocValue> customDataList) {
        this.customDataList = customDataList;
    }

    public boolean isDefaultDocumentDescription() {
        return this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "HIDE_AND_DEFAULT_PROP_DEV_DOC_DESC");
    }

    public String getDocumentTitle() {
        if (this.isDefaultDocumentDescription()) {
            return this.getDocumentHeader().getDocumentDescription();
        }
        return super.getDocumentTitle();
    }

    public NoteType getNoteType() {
        return NoteType.BUSINESS_OBJECT;
    }

    public List<Note> getNotes() {
        if (StringUtils.isNotBlank((CharSequence)this.getNoteTarget().getObjectId())) {
            this.notes = new ArrayList(this.getNoteService().getByRemoteObjectId(this.getNoteTarget().getObjectId()));
        }
        return this.notes;
    }

    public DocumentHeaderService getDocumentHeaderService() {
        if (this.documentHeaderService == null) {
            this.documentHeaderService = KcServiceLocator.getService(DocumentHeaderService.class);
        }
        return this.documentHeaderService;
    }

    void setDocumentHeaderService(DocumentHeaderService documentHeaderService) {
        this.documentHeaderService = documentHeaderService;
    }

    @Override
    public String getCustomLockDescriptor(Person user) {
        return this.getDocumentBoNumber() + "-PROPOSAL DEVELOPMENT";
    }

    public ProjectPublisher getProjectPublisher() {
        if (this.projectPublisher == null) {
            this.projectPublisher = KcServiceLocator.getService(ProjectPublisher.class);
        }
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public ProjectRetrievalService getProjectRetrievalService() {
        if (this.propDevProjectRetrievalService == null) {
            this.propDevProjectRetrievalService = (ProjectRetrievalService)KcServiceLocator.getService("propDevProjectRetrievalService");
        }
        return this.propDevProjectRetrievalService;
    }

    public void setProjectRetrievalService(ProjectRetrievalService propDevProjectRetrievalService) {
        this.propDevProjectRetrievalService = propDevProjectRetrievalService;
    }

    public String getAdHocRouteNodeName() {
        List nodes = this.getRouteNodeService().getCurrentNodeInstances(this.getDocumentNumber());
        if (Objects.isNull(nodes) || nodes.isEmpty()) {
            return null;
        }
        RouteNodeInstance nodeToAdhocRoute = nodes.stream().filter(node -> node.getRouteNode().getRouteNodeName().equalsIgnoreCase(PEOPLE_FLOWS)).findFirst().orElse((RouteNodeInstance)nodes.get(0));
        return nodeToAdhocRoute.getName();
    }

    public RouteNodeService getRouteNodeService() {
        if (this.routeNodeService == null) {
            this.routeNodeService = KEWServiceLocator.getRouteNodeService();
        }
        return this.routeNodeService;
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        qualifiedRoleAttributes.put("proposal", this.getDevelopmentProposal().getProposalNumber());
        qualifiedRoleAttributes.put("unitNumber", this.getDevelopmentProposal().getOwnedByUnitNumber());
    }

    public static class PropDevDocumentXMLMaterializer
    extends KualiDocumentXmlMaterializer {
        List<RolePersons> rolepersons;

        public List<RolePersons> getRolepersons() {
            return this.rolepersons;
        }

        public void setRolepersons(List<RolePersons> rolepersons) {
            this.rolepersons = rolepersons;
        }
    }
}

