/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.model;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.kuali.coeus.sys.framework.model.KcDataObject;
import org.kuali.coeus.sys.framework.model.KcDataObjectService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.data.jpa.DisableVersioning;
import org.kuali.rice.krad.service.PersistenceStructureService;

@DisableVersioning
@MappedSuperclass
public abstract class KcPersistableBusinessObjectBase
extends PersistableBusinessObjectBase
implements KcDataObject {
    @Column(name="UPDATE_USER")
    private String updateUser;
    @Column(name="UPDATE_TIMESTAMP")
    private Timestamp updateTimestamp;
    @Transient
    private boolean updateUserSet;
    @Transient
    private transient PersistableBusinessObjectExtension temporaryExtension;
    @Transient
    private transient KcDataObjectService kcDataObjectService;
    @Transient
    private transient PersistenceStructureService persistenceStructureService;

    protected void prePersist() {
        this.getKcDataObjectService().initVersionNumberForPersist(this);
        this.getKcDataObjectService().initUpdateFieldsForPersist(this);
        this.getKcDataObjectService().initObjectIdForPersist(this);
        super.prePersist();
        if (this.extension != null) {
            this.temporaryExtension = this.extension;
            this.extension = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void postPersist() {
        if (this.temporaryExtension == null) return;
        List fieldNames = this.getPersistenceStructureService().listPrimaryKeyFieldNames(this.getClass());
        try {
            for (String fieldName : fieldNames) {
                try {
                    Method thisGetter = PropertyUtils.getReadMethod((PropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)this, (String)fieldName));
                    Method extensionSetter = PropertyUtils.getWriteMethod((PropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)this.temporaryExtension, (String)fieldName));
                    extensionSetter.invoke((Object)this.temporaryExtension, thisGetter.invoke((Object)this, new Object[0]));
                }
                catch (NoSuchMethodException nsme) {
                    throw new PersistenceBrokerException("Could not find accessor for " + fieldName + " in an extension object", (Throwable)nsme);
                }
                catch (InvocationTargetException ite) {
                    throw new PersistenceBrokerException("Could not invoke accessor for " + fieldName + " on an extension object", (Throwable)ite);
                }
                catch (IllegalAccessException iae) {
                    throw new PersistenceBrokerException("Illegal access when invoking " + fieldName + " accessor on an extension object", (Throwable)iae);
                    return;
                }
            }
        }
        finally {
            this.extension = this.temporaryExtension;
            this.temporaryExtension = null;
        }
    }

    protected void preUpdate() {
        this.getKcDataObjectService().initObjectIdForUpdate(this);
        this.getKcDataObjectService().initVersionNumberForUpdate(this);
        this.getKcDataObjectService().initUpdateFieldsForUpdate(this);
        super.preUpdate();
    }

    @Override
    public Timestamp getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    @Override
    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public boolean isUpdateUserSet() {
        return this.updateUserSet;
    }

    @Override
    public void setUpdateUserSet(boolean updateUserSet) {
        this.updateUserSet = updateUserSet;
    }

    KcDataObjectService getKcDataObjectService() {
        if (this.kcDataObjectService == null) {
            this.kcDataObjectService = KcServiceLocator.getService(KcDataObjectService.class);
        }
        return this.kcDataObjectService;
    }

    PersistenceStructureService getPersistenceStructureService() {
        if (this.persistenceStructureService == null) {
            this.persistenceStructureService = KcServiceLocator.getService(PersistenceStructureService.class);
        }
        return this.persistenceStructureService;
    }

    void setKcDataObjectService(KcDataObjectService kcDataObjectService) {
        this.kcDataObjectService = kcDataObjectService;
    }

    void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public String toString() {
        class BusinessObjectToStringBuilder
        extends ReflectionToStringBuilder {
            private BusinessObjectToStringBuilder(KcPersistableBusinessObjectBase this$0, Object object) {
                super(object);
            }

            public boolean accept(Field field) {
                return String.class.isAssignableFrom(field.getType()) || ClassUtils.isPrimitiveOrWrapper(field.getType());
            }
        }
        BusinessObjectToStringBuilder toStringBuilder = new BusinessObjectToStringBuilder(this, this);
        return toStringBuilder.toString();
    }
}

