/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.custom;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.util.Wrapper;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractCustomDataRoleTypeService
extends DerivedRoleTypeServiceBase {
    @Autowired
    @Qualifier(value="roleService")
    private RoleService roleService;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;

    protected abstract CustomDataContainer getCustomDataContainer(Map<String, String> var1);

    protected abstract String getKeyAttribute();

    public final List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        if (StringUtils.isBlank((CharSequence)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (roleName == null) {
            throw new RiceIllegalArgumentException("roleName was null");
        }
        String roleId = this.getRoleId(namespaceCode, roleName);
        if (StringUtils.isBlank((CharSequence)roleId)) {
            return Collections.emptyList();
        }
        CustomDataContainer customDataContainer = this.getCustomDataContainer(qualification);
        if (customDataContainer != null && customDataContainer.getCustomDataList() != null) {
            return customDataContainer.getCustomDataList().stream().filter(cd -> roleName.equals(cd.getCustomAttribute().getName())).map(cd -> {
                List<Wrapper<String>> listValue = cd.getDeserializedListValue();
                if (listValue != null) {
                    return listValue;
                }
                String value = cd.getValue();
                return value != null ? List.of(new Wrapper<String>(value)) : Collections.emptyList();
            }).flatMap(Collection::stream).filter(Objects::nonNull).map(Wrapper::getValue).filter(StringUtils::isNotBlank).distinct().map(this::getPerson).filter(Objects::nonNull).filter(Person::isActive).map(person -> RoleMembership.Builder.create((String)roleId, null, (String)person.getPrincipalId(), (MemberType)MemberType.PRINCIPAL, null).build()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected final List<String> getRequiredAttributes() {
        return List.of(this.getKeyAttribute());
    }

    private String getRoleId(String namespaceCode, String roleName) {
        return this.getRoleService().getRoleIdByNamespaceCodeAndName(namespaceCode, roleName);
    }

    private Person getPerson(String principalName) {
        return this.getPersonService().getPersonByPrincipalName(principalName);
    }

    public final boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        return true;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

