/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.kra.excon.project.ExconProjectAttachment;
import org.kuali.kra.excon.project.ExconProjectAttachmentsBean;
import org.kuali.kra.excon.project.ExconProjectCommentsBean;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.kra.excon.project.web.struts.action.ExconProjectAction;
import org.kuali.kra.excon.project.web.struts.form.ExconProjectForm;

public class ExconProjectCommentsAndAttachmentsAction
extends ExconProjectAction {
    private static final String CONFIRM_DELETE_ATTACHMENT = "confirmDeleteAttachment";
    private static final String CONFIRM_DELETE_ATTACHMENT_KEY = "confirmDeleteAttachmentKey";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.save(mapping, form, request, response);
    }

    public ActionForward addComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getExconProjectCommentsBean(form).addExconProjectComment();
        return mapping.findForward("basic");
    }

    public ActionForward deleteComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getExconProjectCommentsBean(form).deleteExconProjectComment(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward addAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getExconProjectAttachmentsBean(form).addExconProjectAttachment();
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        int selection = this.getSelectedLine(request);
        ExconProjectAttachment attachment = exconProjectForm.getExconProjectAttachmentsBean().retrieveExistingAttachment(selection);
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), ExconProjectCommentsAndAttachmentsAction.getValidHeaderString(file.getName()), ExconProjectCommentsAndAttachmentsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int delAttachment = this.getLineToDelete(request);
        return this.confirm(this.buildDeleteAttachmentConfirmationQuestion(mapping, form, request, response, delAttachment), CONFIRM_DELETE_ATTACHMENT, "");
    }

    private StrutsConfirmation buildDeleteAttachmentConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, int deleteAttachment) throws Exception {
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        ExconProjectDocument exconProjectDocument = exconProjectForm.getExconProjectDocument();
        ExconProjectAttachment attachment = exconProjectDocument.getExconProject().getExconProjectAttachments().get(deleteAttachment);
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_ATTACHMENT_KEY, "document.question.deleteAttachment.text", "Export Control Project Attachment", attachment.getFile().getName());
    }

    public ActionForward confirmDeleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        ExconProjectDocument exconProjectDocument = exconProjectForm.getExconProjectDocument();
        int delAttachment = this.getLineToDelete(request);
        exconProjectDocument.getExconProject().getExconProjectAttachments().remove(delAttachment);
        return mapping.findForward("basic");
    }

    private ExconProjectCommentsBean getExconProjectCommentsBean(ActionForm form) {
        return ((ExconProjectForm)form).getExconProjectCommentsBean();
    }

    private ExconProjectAttachmentsBean getExconProjectAttachmentsBean(ActionForm form) {
        return ((ExconProjectForm)form).getExconProjectAttachmentsBean();
    }
}

