/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.sensitive;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.kuali.coeus.sys.framework.sensitive.SensitiveFieldMatcher;
import org.kuali.coeus.sys.impl.sensitive.SensitiveFields;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="sensitiveFieldSimpleMatcher")
public class SensitiveFieldSimpleMatcher
implements SensitiveFieldMatcher {
    public static final String STAR_CONSTANT = "*";
    private Set<String> fields = new TreeSet<String>(new Comparator<String>(this){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    });

    @Autowired
    public SensitiveFieldSimpleMatcher(@Qualifier(value="sensitiveFieldResourceLoader") SensitiveFields sensitiveFields) {
        this.addToSortedSet(sensitiveFields.getSensitiveFields());
    }

    private void addToSortedSet(List<String> listOfStrings) {
        for (String str : listOfStrings) {
            if (str.contains(STAR_CONSTANT)) continue;
            this.fields.add(str);
        }
    }

    @Override
    public boolean match(String searchString) {
        return this.fields.contains(searchString);
    }
}

