/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.pdf.forms;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.pdf.forms.PdfForms;
import org.kuali.coeus.common.framework.pdf.forms.PdfFormsService;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="pdfFormsLookupableHelperService")
@Scope(value="prototype")
public class PdfFormsLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    private static final String SYSTEM_DEFAULT = "systemDefault";
    private static final String ID = "id";
    @Autowired
    @Qualifier(value="pdfFormsService")
    private PdfFormsService pdfFormsService;

    public List<PdfForms> getSearchResults(Map<String, String> fieldValues) {
        return super.getSearchResults(this.addSystemDefaultClause(fieldValues));
    }

    public List<PdfForms> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        return super.getSearchResultsUnbounded(this.addSystemDefaultClause(fieldValues));
    }

    private Map<String, String> addSystemDefaultClause(Map<String, String> fieldValues) {
        String systemDefault = fieldValues.get(SYSTEM_DEFAULT);
        String id = fieldValues.get(ID);
        if (StringUtils.isBlank((CharSequence)id)) {
            if ("Y".equals(systemDefault)) {
                fieldValues.put(ID, this.pdfFormsService.systemDefaults().stream().map(d -> d + "%").collect(Collectors.joining("|")));
            } else if ("N".equals(systemDefault)) {
                fieldValues.put(ID, "!" + this.pdfFormsService.systemDefaults().stream().map(d -> d + "%").collect(Collectors.joining("&!")));
            }
        }
        return fieldValues;
    }

    public PdfFormsService getPdfFormsService() {
        return this.pdfFormsService;
    }

    public void setPdfFormsService(PdfFormsService pdfFormsService) {
        this.pdfFormsService = pdfFormsService;
    }
}

