/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.notification.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.notification.impl.KcNotificationAction;
import org.kuali.coeus.common.notification.impl.bo.NotificationType;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.type.ActionTypeService;
import org.kuali.rice.krms.impl.type.KrmsTypeServiceBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="kcNotificationActionTypeService")
public class KcNotificationActionTypeServiceImpl
extends KrmsTypeServiceBase
implements ActionTypeService {
    @Autowired
    @Qualifier(value="krmsTypeRepositoryService")
    private KrmsTypeRepositoryService krmsTypeRepositoryService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    public Action loadAction(ActionDefinition actionDefinition) {
        if (actionDefinition == null) {
            throw new RiceIllegalArgumentException("actionDefinition must not be null");
        }
        if (actionDefinition.getAttributes() == null || !actionDefinition.getAttributes().containsKey("notificationTypeId")) {
            throw new RiceIllegalArgumentException("actionDefinition does not contain an notificationTypeId attribute");
        }
        String notificationTypeId = (String)actionDefinition.getAttributes().get("notificationTypeId");
        if (StringUtils.isBlank((CharSequence)notificationTypeId)) {
            throw new RiceIllegalArgumentException("notificationTypeId attribute must not be null or blank");
        }
        return new KcNotificationAction(notificationTypeId);
    }

    public List<RemotableAttributeError> validateAttributes(String typeId, Map<String, String> attributes) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>(super.validateAttributes(typeId, attributes));
        if (attributes.containsKey("notificationTypeId")) {
            String notificationTypeId = attributes.get("notificationTypeId");
            NotificationType notificationType = (NotificationType)this.businessObjectService.findByPrimaryKey(NotificationType.class, Map.of("notificationTypeId", notificationTypeId));
            if (notificationType == null) {
                errors.add(RemotableAttributeError.Builder.create((String)"notificationTypeId", (String[])new String[]{"error.select.notification"}).build());
            } else if (!"3".equals(notificationType.getModuleCode())) {
                errors.add(RemotableAttributeError.Builder.create((String)"notificationTypeId", (String[])new String[]{"error.select.notification.not.supported"}).build());
            }
        }
        return errors;
    }

    public KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        return this.krmsTypeRepositoryService;
    }

    public void setKrmsTypeRepositoryService(KrmsTypeRepositoryService krmsTypeRepositoryService) {
        this.krmsTypeRepositoryService = krmsTypeRepositoryService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

