/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.modular;

import java.util.List;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModular;
import org.kuali.coeus.propdev.impl.core.ProposalAuditEvent;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetModularTotalDirectCostRule")
public class BudgetModularTotalDirectCostRule {
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService paramService;

    @KcEventMethod
    public boolean validateTotalDirectCost(ProposalAuditEvent event) {
        boolean passed = true;
        List<ProposalDevelopmentBudgetExt> budgets = event.getProposalDevelopmentDocument().getDevelopmentProposal().getBudgets();
        for (int i = 0; i < budgets.size(); ++i) {
            ProposalDevelopmentBudgetExt budget = budgets.get(i);
            if (!budget.isBudgetComplete()) continue;
            passed &= this.checkTotalDirectCost(budget, i);
        }
        return passed;
    }

    private boolean checkTotalDirectCost(Budget budget, int currentIndex) {
        assert (budget != null) : "the budget overview was null";
        assert (currentIndex >= 0) : "the current index was not valid, index: " + currentIndex;
        if (Boolean.FALSE.equals(budget.getModularBudgetFlag())) {
            return true;
        }
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        if (budgetPeriods != null) {
            int positiveCount = -1;
            for (BudgetPeriod budgetPeriod : budgetPeriods) {
                if (budgetPeriod == null) continue;
                BudgetModular budgetModular = budgetPeriod.getBudgetModular();
                int n = positiveCount = positiveCount != -1 ? positiveCount : 0;
                if (budgetModular != null) {
                    ScaleTwoDecimal tdc = budgetModular.getTotalDirectCost();
                    if (tdc.isPositive()) {
                        ++positiveCount;
                        continue;
                    }
                    GlobalVariables.getMessageMap().putWarning("budgetVersionOverview[" + currentIndex + "].budgetStatus", "warning.budgetVersion.Modular.InvalidTotalDirectCost", new String[0]);
                    continue;
                }
                GlobalVariables.getMessageMap().putWarning("budgetVersionOverview[" + currentIndex + "].budgetStatus", "warning.budgetVersion.Modular.InvalidTotalDirectCost", new String[0]);
            }
            if (positiveCount == 0) {
                GlobalVariables.getMessageMap().putError("budgetVersionOverview[" + currentIndex + "].budgetStatus", "error.budgetVersion.budgetStatusCompleteWhenNotModuler", new String[0]);
                return false;
            }
        }
        return true;
    }

    protected String getBudgetStatusCompleteCode() {
        return this.paramService.getParameterValueAsString(Budget.class, "budgetStatusCompleteCode");
    }

    protected ParameterService getParamService() {
        return this.paramService;
    }

    public void setParamService(ParameterService paramService) {
        this.paramService = paramService;
    }
}

