/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectAttachmentType;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class ExconProjectAttachment
extends ExconProjectAssociate
implements Comparable<ExconProjectAttachment> {
    private static final long serialVersionUID = 502762957346287794L;
    private Long projectAttachmentId;
    private Long projectId;
    private String fileId;
    private AttachmentFile file;
    private transient FormFile newFile;
    private String typeCode;
    private ExconProjectAttachmentType type;
    private Integer documentId;
    private String description;
    private String attachUser;
    private Date attachDate;
    private transient KcPersonService kcPersonService;
    private transient PersonService personService;
    private transient BusinessObjectService businessObjectService;

    public ExconProjectAttachment() {
    }

    public ExconProjectAttachment(ExconProject exconProject) {
        this.setExconProject(exconProject);
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public Integer getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Integer documentId) {
        this.documentId = documentId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAttachmentDescription() {
        return "ExconProject Attachment";
    }

    public AttachmentFile getFile() {
        return this.file;
    }

    public void setFile(AttachmentFile file) {
        this.file = file;
    }

    public FormFile getNewFile() {
        return this.newFile;
    }

    public void setNewFile(FormFile newFile) {
        this.newFile = newFile;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public Long getProjectAttachmentId() {
        return this.projectAttachmentId;
    }

    public void setProjectAttachmentId(Long projectAttachmentId) {
        this.projectAttachmentId = projectAttachmentId;
    }

    public ExconProjectAttachmentType getType() {
        if (!StringUtils.isEmpty((CharSequence)this.typeCode)) {
            this.refreshReferenceObject("type");
        }
        return this.type;
    }

    public String getAttachUser() {
        return this.attachUser;
    }

    public void setAttachUser(String attachUser) {
        this.attachUser = attachUser;
    }

    public String getAttachUserName() {
        KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.getAttachUser());
        return ObjectUtils.isNull((Object)person) ? "Person not found" : person.getFullName();
    }

    public Date getAttachDate() {
        return this.attachDate;
    }

    public String getAttachDateStr() {
        return ExconProject.formattedDate(this.attachDate);
    }

    public void setAttachDate(Date attachDate) {
        this.attachDate = attachDate;
    }

    public void setType(ExconProjectAttachmentType type) {
        this.type = type;
    }

    @Override
    public void resetPersistenceState() {
        this.setProjectAttachmentId(null);
    }

    public boolean isNew() {
        return this.getProjectAttachmentId() == null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.documentId == null ? 0 : this.documentId.hashCode());
        result = 31 * result + (this.typeCode == null ? 0 : this.typeCode.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        result = 31 * result + (this.projectAttachmentId == null ? 0 : this.projectAttachmentId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExconProjectAttachment other = (ExconProjectAttachment)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.documentId == null ? other.documentId != null : !this.documentId.equals(other.documentId)) {
            return false;
        }
        if (this.typeCode == null ? other.typeCode != null : !this.typeCode.equals(other.typeCode)) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId)) {
            return false;
        }
        return !(this.projectAttachmentId == null ? other.projectAttachmentId != null : !this.projectAttachmentId.equals(other.projectAttachmentId));
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        if (this.getVersionNumber() == null) {
            this.setVersionNumber(0L);
        }
    }

    public String getUpdateUserName() {
        Person updateUser = this.getPersonService().getPersonByPrincipalName(this.getUpdateUser());
        return updateUser != null ? updateUser.getName() : this.getUpdateUser();
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        if (this.getUpdateTimestamp() == null) {
            super.setUpdateTimestamp(updateTimestamp);
        }
    }

    @Override
    public int compareTo(ExconProjectAttachment o) {
        return this.getProjectAttachmentId().compareTo(o.getProjectAttachmentId());
    }

    protected void preRemove() {
        super.preRemove();
        if (this.getFileId() != null) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("fileId", this.getFileId());
            List otherAttachmentVersions = this.getBusinessObjectService().findMatching(ExconProjectAttachment.class, values);
            if (otherAttachmentVersions.size() > 1) {
                this.setFile(null);
                this.setFileId(null);
            }
        }
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KcServiceLocator.getService(PersonService.class);
        }
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    public void setExconProject(ExconProject exconProject) {
        super.setExconProject(exconProject);
        this.setProjectId(exconProject.getProjectId());
    }
}

