/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.core;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcPostProcessor;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;

public class QuestionnairePostProcessor
extends KcPostProcessor {
    private static final Logger LOG = LogManager.getLogger(QuestionnairePostProcessor.class);

    @Override
    public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) throws Exception {
        ProcessDocReport routeStatusChange = super.doRouteStatusChange(statusChangeEvent);
        if ("P".equals(statusChangeEvent.getNewRouteStatus()) && !this.isApproveByInitiator(statusChangeEvent.getDocumentId().toString())) {
            try {
                DocumentRouteHeaderValue document = this.getRouteHeaderService().getRouteHeader(statusChangeEvent.getDocumentId());
                document.markDocumentFinalized();
            }
            catch (Exception e) {
                LOG.debug("mark Questionnaire doc 'finalized' failed " + e.getMessage(), (Throwable)e);
            }
        }
        return routeStatusChange;
    }

    private boolean isApproveByInitiator(String docId) {
        DocumentRouteHeaderValue document = this.getRouteHeaderService().getRouteHeader(docId);
        String initiatorId = document.getInitiatorWorkflowId();
        ActionTaken lastActionTaken = null;
        for (ActionTakenValue actionTakenValue : document.getActionsTaken()) {
            boolean isLaterAction;
            ActionTaken actionTaken = ActionTakenValue.to((ActionTakenValue)actionTakenValue);
            ActionType actionTakenType = actionTaken.getActionTaken();
            boolean isApprovalAction = actionTakenType.equals((Object)ActionType.APPROVE) || actionTakenType.equals((Object)ActionType.BLANKET_APPROVE);
            boolean bl = isLaterAction = lastActionTaken != null && actionTaken.getActionDate().toDate().after(lastActionTaken.getActionDate().toDate());
            if (lastActionTaken != null && (!isApprovalAction || !isLaterAction)) continue;
            lastActionTaken = actionTaken;
        }
        return StringUtils.equals((CharSequence)initiatorId, (CharSequence)lastActionTaken.getPrincipalId());
    }

    private RouteHeaderService getRouteHeaderService() {
        return KcServiceLocator.getService(RouteHeaderService.class);
    }
}

