/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.datavalidation;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormsService;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentDataValidationController
extends ProposalDevelopmentControllerBase {
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="preproposalFormsService")
    private PreproposalFormsService preproposalFormsService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=validateData"})
    public ModelAndView validateData(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        if (form.isAuditActivated()) {
            if (form.getPreproposalFormsHelper() == null) {
                form.setPreproposalFormsHelper(this.preproposalFormsService.createHelper(form.getProposalDevelopmentDocument(), form.getExternalUrl()));
            }
            form.setDataValidationItems(((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateDataValidation(form));
        }
        return this.getModelAndViewService().showDialog("DataValidationSection", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=toggleValidation"})
    public ModelAndView toggleValidation(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        form.setAuditActivated(!form.isAuditActivated());
        if (form.isAuditActivated()) {
            form.setDataValidationItems(((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateDataValidation(form));
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=navigateToError"})
    public ModelAndView navigateToError(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        String pageId;
        if (form.getPreproposalFormsHelper() == null) {
            form.setPreproposalFormsHelper(this.preproposalFormsService.createHelper(form.getProposalDevelopmentDocument(), form.getExternalUrl()));
        }
        if (StringUtils.equals((CharSequence)(pageId = form.getActionParamaterValue("navigateToPageId")), (CharSequence)"PropDev-CreditAllocationPage")) {
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateCreditSplits(form);
        }
        if (StringUtils.equals((CharSequence)pageId, (CharSequence)"PropDev-QuestionnairePage")) {
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateQuestionnaires(form);
        }
        if (StringUtils.equals((CharSequence)pageId, (CharSequence)"PropDev-SupplementalPage")) {
            ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateCustomData(form);
        }
        this.getAuditHelper().auditConditionally(form);
        form.setAjaxReturnType("update-page");
        return this.getNavigationControllerService().navigate((UifFormBase)form);
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public PreproposalFormsService getPreproposalFormsService() {
        return this.preproposalFormsService;
    }

    public void setPreproposalFormsService(PreproposalFormsService preproposalFormsService) {
        this.preproposalFormsService = preproposalFormsService;
    }
}

