/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.logging.controller;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.impl.logging.controller.LogLevel;
import org.kuali.coeus.sys.impl.logging.controller.LogLevelConfig;
import org.kuali.coeus.sys.impl.logging.controller.LogLevels;
import org.kuali.coeus.sys.impl.logging.controller.LoggerConfiguration;
import org.kuali.coeus.sys.impl.logging.controller.LoggerConfigurationComparator;
import org.kuali.coeus.sys.impl.logging.controller.LoggerLevels;
import org.kuali.coeus.sys.impl.logging.controller.SingleLoggerLevels;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller(value="loggersController")
public final class LoggersController
extends RestController {
    private static final Comparator<LoggerConfiguration> CONFIGURATION_COMPARATOR = new LoggerConfigurationComparator("");
    private static final LogLevels<Level> LEVELS = new LogLevels();
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;

    @RequestMapping(value={"/api/v1/loggers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Map<String, Object> loggers() {
        if (!this.authServiceRestUtilService.isServiceUser()) {
            throw new UnauthorizedAccessException();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("levels", this.getLevels());
        result.put("loggers", this.getLoggers(this.getLoggerConfigurations()));
        return result;
    }

    @RequestMapping(value={"/api/v1/loggers/{logger.name}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public LoggerLevels loggerLevels(@PathVariable(value="logger.name") String name) {
        if (!this.authServiceRestUtilService.isServiceUser()) {
            throw new UnauthorizedAccessException();
        }
        Assert.notNull((Object)name, (String)"Name must not be null");
        LoggerConfiguration configuration = this.getLoggerConfiguration(name);
        return configuration != null ? new SingleLoggerLevels(configuration) : null;
    }

    @RequestMapping(value={"/api/v1/loggers/{logger.name}"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void configureLogLevel(@PathVariable(value="logger.name") String name, @RequestBody(required=false) @Nullable LogLevelConfig configuredLevel) {
        if (!this.authServiceRestUtilService.isServiceUser()) {
            throw new UnauthorizedAccessException();
        }
        Assert.notNull((Object)name, (String)"Name must not be empty");
        this.setLogLevel(name, configuredLevel != null ? configuredLevel.getConfiguredLevel() : null);
    }

    private NavigableSet<LogLevel> getLevels() {
        return new TreeSet<LogLevel>(LEVELS.getSupported()).descendingSet();
    }

    private Map<String, LoggerLevels> getLoggers(Collection<LoggerConfiguration> configurations) {
        LinkedHashMap<String, LoggerLevels> loggers = new LinkedHashMap<String, LoggerLevels>(configurations.size());
        for (LoggerConfiguration configuration : configurations) {
            loggers.put(configuration.getName(), new SingleLoggerLevels(configuration));
        }
        return loggers;
    }

    private List<LoggerConfiguration> getLoggerConfigurations() {
        return this.getLoggerContext().getConfiguration().getLoggers().values().stream().map(this::convertLoggerConfiguration).sorted(CONFIGURATION_COMPARATOR).collect(Collectors.toList());
    }

    private LoggerConfiguration getLoggerConfiguration(String loggerName) {
        return this.convertLoggerConfiguration(this.getLoggerConfig(loggerName));
    }

    private LoggerConfig getLoggerConfig(String name) {
        if (!StringUtils.hasLength((String)name) || "".equals(name)) {
            name = "";
        }
        return (LoggerConfig)this.getLoggerContext().getConfiguration().getLoggers().get(name);
    }

    private LoggerContext getLoggerContext() {
        return (LoggerContext)LogManager.getContext((boolean)false);
    }

    private LoggerConfiguration convertLoggerConfiguration(LoggerConfig loggerConfig) {
        if (loggerConfig == null) {
            return null;
        }
        LogLevel level = LEVELS.convertNativeToSystem(loggerConfig.getLevel());
        String name = loggerConfig.getName();
        if (!StringUtils.hasLength((String)name) || "".equals(name)) {
            name = "";
        }
        return new LoggerConfiguration(name, level, level);
    }

    private void setLogLevel(String loggerName, LogLevel logLevel) {
        Level level = LEVELS.convertSystemToNative(logLevel);
        LoggerConfig loggerConfig = this.getLoggerConfig(loggerName);
        if (loggerConfig == null) {
            loggerConfig = new LoggerConfig(loggerName, level, true);
            this.getLoggerContext().getConfiguration().addLogger(loggerName, loggerConfig);
        } else {
            loggerConfig.setLevel(level);
        }
        this.getLoggerContext().updateLoggers();
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    static {
        LEVELS.map(LogLevel.TRACE, Level.TRACE);
        LEVELS.map(LogLevel.DEBUG, Level.DEBUG);
        LEVELS.map(LogLevel.INFO, Level.INFO);
        LEVELS.map(LogLevel.WARN, Level.WARN);
        LEVELS.map(LogLevel.ERROR, Level.ERROR);
        LEVELS.map(LogLevel.FATAL, Level.FATAL);
        LEVELS.map(LogLevel.OFF, Level.OFF);
    }
}

