/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.award.api.AwardApiService;
import org.kuali.coeus.award.api.AwardPostResult;
import org.kuali.coeus.award.dto.AwardDto;
import org.kuali.coeus.award.finance.AwardAccount;
import org.kuali.coeus.award.finance.AwardPostStatus;
import org.kuali.coeus.award.finance.AwardPosts;
import org.kuali.coeus.award.finance.dao.AccountDao;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.kra.award.commitments.AwardFandaRateService;
import org.kuali.kra.award.contacts.AwardCentralAdminContact;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardFinanceIntegrationService;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.KualiRestTemplateResponseErrorHandler;
import org.kuali.kra.award.home.ValidRates;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Service(value="awardFinanceIntegrationService")
public class AwardFinanceIntegrationServiceImpl
implements AwardFinanceIntegrationService {
    public static final String ACCOUNT_NUMBER = "accountNumber";
    public static final String AWARD_FAMILY = "awardFamily";
    private static final Logger LOG = LogManager.getLogger(AwardFinanceIntegrationServiceImpl.class);
    private static final String AUTH_USER_PUSH_USE_DEV_PASSWORD = "auth.user.push.use.dev.password";
    private static final String AUTH_USER_PUSH_DEV_PASSWORD = "auth.user.push.dev.password";
    private static final String FINANCIALS_INTEGRATION_TEAM_CODE_FALLBACK_ARGUMENT_NAME = "ATSPApprovers";
    private static final String FINANCIALS_INTEGRATION_TEAM_CODE_FALLBACK_ADMINISTRATOR_TYPE_CODE = "4";
    private static final String FINANCIALS_INTEGRATION_TEAM_CODE = "CTRL";
    private static final int CSU_CUSTOM_DATA_TEAM_ID_CODE = 38;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="awardApiService")
    private AwardApiService awardApiService;
    @Autowired
    @Qualifier(value="awardFandaRateService")
    private AwardFandaRateService awardFandaRateService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="accountDao")
    private AccountDao accountDao;

    @Override
    public AwardPostResult transmitAwardAccountPost(Award award, String docNumber, String docStatus) {
        String postType = "Award account post ";
        AwardDto awardDto = this.getAwardApiService().convertAwardToDto(award);
        this.addFinancialsIntegrationToAwardDto(awardDto, award);
        awardDto.setDocNbr(docNumber);
        awardDto.setDocStatus(docStatus);
        HttpMethod method = HttpMethod.POST;
        String endpointUrl = this.getAwardPostPostApiUrl();
        if (this.isAccountPreviouslyPostedSuccess(award.getAccountNumber(), award.getAwardNumber())) {
            method = HttpMethod.PUT;
            endpointUrl = this.getAwardPostPutApiUrl();
        }
        return this.doRestCall(award, endpointUrl, method, this.getEntity(awardDto), postType);
    }

    private void addFinancialsIntegrationToAwardDto(AwardDto awardDto, Award award) {
        List<ValidRates> validRates;
        awardDto.setRequestId(UUID.randomUUID().toString());
        Optional<AwardCustomData> teamCode = award.getAwardCustomDataList().stream().filter(v -> v.getCustomAttributeId() == 38L).findFirst();
        if (teamCode.isEmpty() || !teamCode.get().getValue().equalsIgnoreCase(FINANCIALS_INTEGRATION_TEAM_CODE)) {
            List teamCodeArgValues;
            Optional<AwardCentralAdminContact> adminContact = award.getAwardCentralAdminContacts().stream().filter(v -> v.getUnitAdministratorTypeCode().equals(FINANCIALS_INTEGRATION_TEAM_CODE_FALLBACK_ADMINISTRATOR_TYPE_CODE)).findFirst();
            if (adminContact.isPresent() && adminContact.get().getPerson() != null && StringUtils.isNotEmpty((CharSequence)adminContact.get().getPerson().getFirstName()) && !(teamCodeArgValues = this.businessObjectService.findMatching(ArgValueLookup.class, Map.of("ARGUMENT_NAME", FINANCIALS_INTEGRATION_TEAM_CODE_FALLBACK_ARGUMENT_NAME, "VALUE", adminContact.get().getPerson().getUserName()))).isEmpty()) {
                awardDto.setTeamCode(((ArgValueLookup)teamCodeArgValues.getFirst()).getDescription());
            }
        } else {
            awardDto.setTeamCode(teamCode.get().getValue());
        }
        if (award.getCurrentFandaRate() != null && !(validRates = this.awardFandaRateService.getValidRates(award.getCurrentFandaRate())).isEmpty()) {
            awardDto.setIcrRateCode(validRates.getFirst().getIcrRateCode());
        }
    }

    protected AwardPostResult processPostResult(ResponseEntity<AwardPostResult> postResult, String postType) {
        AwardPostResult result = (AwardPostResult)postResult.getBody();
        if (result == null) {
            result = new AwardPostResult();
            result.setProcessStatus(AwardPostStatus.ERROR.getStatus());
            result.setStatusDetails("Malformed Server response.");
            LOG.error(postType + "server response malformed: missing status and details, ResponseEntity<AwardPostResult>: " + postResult.toString());
        } else if (postResult.getStatusCode().is2xxSuccessful()) {
            result.setProcessStatus(result.getProcessStatus());
        } else if (postResult.getStatusCode().is4xxClientError()) {
            result.setProcessStatus(result.getProcessStatus() + ": " + postResult.getStatusCodeValue());
            result.setStatusDetails(this.processPostErrorBody(result.getStatusDetails(), postType));
            LOG.error(postType + " failed with: " + String.valueOf(postResult.getStatusCode()), postResult);
        } else if (postResult.getStatusCode().is5xxServerError()) {
            result.setProcessStatus(result.getProcessStatus() + ": " + postResult.getStatusCodeValue());
            result.setStatusDetails(this.processPostErrorBody(result.getStatusDetails(), postType));
            LOG.error(postType + " failed with: " + String.valueOf(postResult.getStatusCode()), postResult);
        } else {
            result = new AwardPostResult();
            result.setProcessStatus(AwardPostStatus.ERROR.getStatus() + ": " + String.valueOf(postResult.getStatusCode()));
            result.setStatusDetails("Contact system support and retry.");
            LOG.error(postType + " failed with: " + String.valueOf(postResult.getStatusCode()), postResult);
        }
        return result;
    }

    protected HttpEntity<AwardDto> getEntity(AwardDto awardDto) {
        HttpHeaders headers = null;
        headers = StringUtils.isNotBlank((CharSequence)this.getAwardPostPushApiToken()) ? this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForToken(this.getAwardPostPushApiToken()) : this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser();
        String originUrl = this.getConfigurationService().getPropertyValueAsString("award.fin.integration.origin.url");
        if (StringUtils.isNotBlank((CharSequence)originUrl)) {
            headers.add("res-origin", originUrl);
        } else {
            headers.add("res-origin", this.getConfigurationService().getPropertyValueAsString("appserver.url"));
        }
        return new HttpEntity((Object)awardDto, (MultiValueMap)headers);
    }

    protected RestTemplate getRestTemplate() {
        RestTemplate template = (RestTemplate)this.restOperations;
        template.setErrorHandler((ResponseErrorHandler)new KualiRestTemplateResponseErrorHandler());
        return template;
    }

    private String processPostErrorBody(String rawError, String postType) {
        Object errorString = null;
        Map parsedResponse = null;
        try {
            parsedResponse = (Map)new ObjectMapper().readValue(rawError, Map.class);
        }
        catch (Exception e) {
            LOG.error(postType + " error message parsing failed on errorMessage: " + rawError, (Throwable)e);
        }
        if (parsedResponse != null && !parsedResponse.isEmpty()) {
            List errorList = (List)parsedResponse.get("errorMessages");
            errorString = StringUtils.join((Iterable)errorList, (char)',');
        } else {
            errorString = postType + (String)(StringUtils.isNotBlank((CharSequence)rawError) ? " error: " + rawError : "error detail missing.");
        }
        return StringUtils.truncate((String)errorString, (int)499);
    }

    @Override
    public AwardPostResult transmitTimeAndMoneyPost(Award award, String docNumber) {
        String postType = "Time and Money post ";
        AwardDto awardDto = this.getAwardApiService().convertAwardToDto(award);
        awardDto.setRequestId(UUID.randomUUID().toString());
        awardDto.setDocNbr(docNumber);
        return this.doRestCall(award, this.getTaMPostPutApiUrl(), HttpMethod.PUT, this.getEntity(awardDto), postType);
    }

    @Override
    public AwardPostResult transmitAwardBudgetPost(Award award, String docNumber) {
        String postType = "Award budget post ";
        AwardDto awardDto = this.getAwardApiService().convertAwardToDto(award);
        awardDto.setRequestId(UUID.randomUUID().toString());
        awardDto.setDocNbr(docNumber);
        if (LOG.isInfoEnabled()) {
            LOG.info("Award Request Id => " + awardDto.getRequestId());
            LOG.info("Award DTO Doc number => " + awardDto.getDocNbr());
            LOG.info("Award DTO Doc status => " + awardDto.getDocStatus());
        }
        return this.doRestCall(award, this.getAwardBudgetApiUrl(), HttpMethod.POST, this.getEntity(awardDto), postType);
    }

    private AwardPostResult doRestCall(Award award, String apiUrl, HttpMethod method, HttpEntity<AwardDto> entity, String postType) {
        AwardPostResult result = new AwardPostResult();
        ResponseEntity postResult = null;
        try {
            postResult = this.getRestTemplate().exchange(apiUrl, method, entity, AwardPostResult.class, new Object[0]);
            result = this.processPostResult((ResponseEntity<AwardPostResult>)postResult, postType);
        }
        catch (ResourceAccessException rae) {
            result.setProcessStatus(AwardPostStatus.ERROR.getStatus());
            result.setStatusDetails("Resource access error for " + postType + "- endpoint refused connection.");
            LOG.error(postType + "error.", (Throwable)rae);
        }
        catch (Exception e) {
            result.setProcessStatus(AwardPostStatus.ERROR.getStatus());
            result.setStatusDetails("Unhandled error for " + postType);
            LOG.error(postType + "error.", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean accountPostIsQueued(String accountNumber, String awardNumber) {
        HashMap<String, String> accountsMap = new HashMap<String, String>();
        accountsMap.put(ACCOUNT_NUMBER, accountNumber);
        accountsMap.put(AWARD_FAMILY, AwardService.getAwardFamily(awardNumber));
        int count = this.getDataObjectService().findMatching(AwardPosts.class, QueryByCriteria.Builder.andAttributes(accountsMap).setCountFlag(CountFlag.ONLY).build()).getTotalRowCount();
        return count != 0;
    }

    @Override
    public boolean isAccountPreviouslyPostedSuccess(String accountNumber, String awardNumber) {
        HashMap searchCriteria = new HashMap();
        List previousSuccessfulPosts = this.accountDao.getAllPostsForAwardNumber(awardNumber).stream().filter(post -> post.getAccountNumber() != null && post.getAccountNumber().contentEquals(accountNumber) && post.getPostStatus() != null && StringUtils.containsIgnoreCase((CharSequence)post.getPostStatus(), (CharSequence)AwardPostStatus.SUCCESS.getStatus())).collect(Collectors.toList());
        return !previousSuccessfulPosts.isEmpty();
    }

    @Override
    public boolean awardAccountExists(String accountNumber) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        List accounts = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)accountNumber)) {
            searchCriteria.put(ACCOUNT_NUMBER, accountNumber);
            accounts = this.dataObjectService.findMatching(AwardAccount.class, QueryByCriteria.Builder.andAttributes(searchCriteria).build()).getResults();
        }
        return !accounts.isEmpty();
    }

    protected String getAwardPostPostApiUrl() {
        return this.configurationService.getPropertyValueAsString("award.account.create.url");
    }

    protected String getAwardPostPutApiUrl() {
        return this.configurationService.getPropertyValueAsString("award.account.update.url");
    }

    protected String getAwardPostPushApiToken() {
        return this.configurationService.getPropertyValueAsString("award.account.auth.token");
    }

    protected String getTaMPostPostApiUrl() {
        return this.configurationService.getPropertyValueAsString("award.tam.post.create.url");
    }

    protected String getTaMPostPutApiUrl() {
        return this.configurationService.getPropertyValueAsString("award.tam.post.update.url");
    }

    protected String getTaMPostPushApiToken() {
        return this.configurationService.getPropertyValueAsString("award.tam.auth.token");
    }

    protected String getAwardBudgetApiUrl() {
        return this.configurationService.getPropertyValueAsString("award.budget.update.url");
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public AwardApiService getAwardApiService() {
        return this.awardApiService;
    }

    public void setAwardApiService(AwardApiService awardApiService) {
        this.awardApiService = awardApiService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public AwardFandaRateService getAwardFandaRateService() {
        return this.awardFandaRateService;
    }

    public void setAwardFandaRateService(AwardFandaRateService awardFandaRateService) {
        this.awardFandaRateService = awardFandaRateService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

