/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardProjectPersonsAuditRule
implements DocumentAuditRule {
    private static final String CONTACTS_AUDIT_WARNINGS = "contactsAuditWarnings";
    private static final String AWARD_UNCERTIFIED_PARAM = "awardUncertifiedKeyPersonnel";
    private List<AuditError> auditErrors = new ArrayList<AuditError>();
    private List<AuditError> auditWarnings = new ArrayList<AuditError>();
    public static final String AWARD_PROJECT_PERSON_LIST_ERROR_KEY = "document.awardList[0].projectPerson.auditErrors";
    public static final String ERROR_AWARD_PROJECT_PERSON_NO_PI = "error.awardProjectPerson.no.pi.exists";
    public static final String ERROR_AWARD_PROJECT_PERSON_MULTIPLE_PI_EXISTS = "error.awardProjectPerson.pi.exists";
    public static final String ERROR_AWARD_PROJECT_PERSON_UNIT_DETAILS_REQUIRED = "error.awardProjectPerson.unit.details.required";
    public static final String ERROR_AWARD_PROJECT_PERSON_LEAD_UNIT_REQUIRED = "error.awardProjectPerson.lead.unit.required";
    public static final String ERROR_AWARD_PROJECT_PERSON_UNCERTIFIED = "error.awardProjectPerson.uncertified";
    public static final String ERROR_AWARD_PRJECT_PERSON_UNIT_REQUIRED = "error.awardProjectPerson.unit.required";
    private ParameterService parameterService;
    private AwardService awardService;
    private InstitutionalProposalService institutionalProposalService;

    public boolean processRunAuditBusinessRules(Document document) {
        AwardDocument awardDocument = (AwardDocument)document;
        this.auditErrors = new ArrayList<AuditError>();
        this.auditWarnings = new ArrayList<AuditError>();
        boolean valid = this.checkUnitExists(awardDocument.getAward().getProjectPersons());
        valid &= this.checkPrincipalInvestigators(awardDocument.getAward().getProjectPersons());
        valid &= this.checkUnits(awardDocument.getAward().getProjectPersons());
        valid &= this.checkLeadUnits(awardDocument.getAward().getProjectPersons());
        this.reportAndCreateAuditCluster();
        return valid &= this.checkCertifiedInvestigators(awardDocument.getAward());
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            AuditCluster existingErrors = (AuditCluster)GlobalVariables.getAuditErrorMap().get("contactsAuditErrors");
            if (existingErrors == null) {
                GlobalVariables.getAuditErrorMap().put("contactsAuditErrors", new AuditCluster("Contacts", this.auditErrors, "Error"));
            } else {
                existingErrors.getAuditErrorList().addAll(this.auditErrors);
            }
        }
        if (this.auditWarnings.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(CONTACTS_AUDIT_WARNINGS, new AuditCluster("Contacts", this.auditWarnings, "Warnings"));
        }
    }

    protected boolean checkPrincipalInvestigators(List<AwardPerson> awardPersons) {
        boolean valid = true;
        List<AwardPerson> principalInvestigators = this.getPrincipalInvestigators(awardPersons);
        int piCount = principalInvestigators.size();
        if (piCount == 0) {
            valid = false;
            this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_NO_PI, "contacts.Contacts"));
        } else if (piCount > 1) {
            valid = false;
            this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_MULTIPLE_PI_EXISTS, "contacts.Contacts"));
        }
        return valid;
    }

    protected boolean checkUnits(List<AwardPerson> awardPersons) {
        boolean valid = true;
        for (AwardPerson person : awardPersons) {
            if (!person.isPrincipalInvestigator() && !person.isCoInvestigator() || person.getUnits() == null || person.getUnits().size() != 0) continue;
            valid = false;
            this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_UNIT_DETAILS_REQUIRED, "contacts.Contacts", new String[]{person.getFullName()}));
        }
        return valid;
    }

    protected boolean checkLeadUnits(List<AwardPerson> awardPersons) {
        boolean valid = true;
        List<AwardPerson> principalInvestigators = this.getPrincipalInvestigators(awardPersons);
        if (principalInvestigators != null && principalInvestigators.size() == 1) {
            List<AwardPersonUnit> piUnits = principalInvestigators.get(0).getUnits();
            int leadUnits = 0;
            for (AwardPersonUnit unit : piUnits) {
                if (!unit.isLeadUnit()) continue;
                ++leadUnits;
            }
            if (leadUnits != 1) {
                valid = false;
                this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_LEAD_UNIT_REQUIRED, "contacts.Contacts"));
            }
        }
        return valid;
    }

    protected List<AwardPerson> getPrincipalInvestigators(List<AwardPerson> projectPersons) {
        ArrayList<AwardPerson> principalInvestigators = new ArrayList<AwardPerson>();
        for (AwardPerson p : projectPersons) {
            if (!p.isPrincipalInvestigator()) continue;
            principalInvestigators.add(p);
        }
        return principalInvestigators;
    }

    protected boolean checkCertifiedInvestigators(Award award) {
        String parmVal = this.getParameterService().getParameterValueAsString(AwardDocument.class, AWARD_UNCERTIFIED_PARAM);
        if (StringUtils.equals((CharSequence)parmVal, (CharSequence)"0")) {
            return true;
        }
        boolean error = StringUtils.equals((CharSequence)parmVal, (CharSequence)"2");
        ArrayList<DevelopmentProposal> devProposals = new ArrayList<DevelopmentProposal>();
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(award.getAwardNumber());
        for (Award curAward : awards) {
            List<AwardFundingProposal> fundingProposals = curAward.getFundingProposals();
            for (AwardFundingProposal fundingProposal : fundingProposals) {
                devProposals.addAll(this.getInstitutionalProposalService().getAllLinkedDevelopmentProposals(fundingProposal.getProposal().getProposalNumber()));
            }
        }
        boolean retval = true;
        for (AwardPerson person : award.getProjectPersons()) {
            boolean personFoundCheck = false;
            block3: for (DevelopmentProposal proposal : devProposals) {
                for (ProposalPerson propPerson : proposal.getProposalPersons()) {
                    if ((person == null || !StringUtils.equals((CharSequence)person.getPersonId(), (CharSequence)propPerson.getPersonId())) && (person.getRolodexId() == null || !Objects.equals(person.getRolodexId(), propPerson.getRolodexId())) || !StringUtils.equals((CharSequence)propPerson.getProposalPersonRoleId(), (CharSequence)"COI") && !StringUtils.equals((CharSequence)propPerson.getProposalPersonRoleId(), (CharSequence)"PI") && !propPerson.getOptInCertificationStatus().booleanValue()) continue;
                    personFoundCheck = true;
                    continue block3;
                }
            }
            if (personFoundCheck) continue;
            retval = false;
            if (error && !person.isKeyPerson()) {
                this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_UNCERTIFIED, "contacts.Contacts", new String[]{person.getFullName()}));
                continue;
            }
            this.auditWarnings.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PROJECT_PERSON_UNCERTIFIED, "contacts.Contacts", new String[]{person.getFullName()}));
        }
        return retval;
    }

    protected boolean checkUnitExists(List<AwardPerson> awardPersons) {
        boolean valid = true;
        for (AwardPerson person : awardPersons) {
            if (!person.isKeyPerson() || !person.isOptInUnitStatus() || person.getUnits() != null && person.getUnits().size() >= 1) continue;
            valid = false;
            String[] params = new String[]{person.getContact().getFullName()};
            this.auditErrors.add(new AuditError(AWARD_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_AWARD_PRJECT_PERSON_UNIT_REQUIRED, "contacts.Contacts", params));
        }
        return valid;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KcServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }
}

