/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.config;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;

public final class DbConnectionConfigUtil {
    private static final String DATASOURCE_OJB_PLATFORM = "datasource.ojb.platform";
    private static final String DATASOURCE_URL = "datasource.url";
    private static final String SERVER_DATASOURCE_OJB_PLATFORM = "server.datasource.ojb.platform";
    private static final String SERVER_DATASOURCE_URL = "server.datasource.url";
    private static final String DATASOURCE_CONNECTION_PROPERTY = "datasource.connection.property";
    private static final String SERVER_DATASOURCE_CONNECTION_PROPERTY = "server.datasource.connection.property";

    private DbConnectionConfigUtil() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void setUpdatedDatabaseConnection(JAXBConfigImpl config) {
        DbConnectionConfigUtil.setUpdatedDatabaseConnection(config, DATASOURCE_OJB_PLATFORM, DATASOURCE_URL, DATASOURCE_CONNECTION_PROPERTY);
        DbConnectionConfigUtil.setUpdatedDatabaseConnection(config, SERVER_DATASOURCE_OJB_PLATFORM, SERVER_DATASOURCE_URL, SERVER_DATASOURCE_CONNECTION_PROPERTY);
    }

    private static void setUpdatedDatabaseConnection(JAXBConfigImpl config, String platformPropName, String urlPropName, String propertyPrefix) {
        String dataSourcePlatform = config.getProperty(platformPropName);
        String prefix = propertyPrefix + "." + dataSourcePlatform + ".";
        String dataSourceUrl = config.getProperty(urlPropName);
        String connectionString = config.getProperties().entrySet().stream().map(DbConnectionConfigUtil::unsafeCast).filter(e -> ((String)e.getKey()).startsWith(prefix)).map(e -> CollectionUtils.entry(((String)e.getKey()).replace(prefix, ""), (String)e.getValue())).filter(e -> !dataSourceUrl.contains((CharSequence)e.getKey())).map(e -> (String)e.getKey() + (String)(StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue())) ? "=" + (String)e.getValue() : "")).collect(Collectors.joining("&"));
        if (StringUtils.isNotBlank((CharSequence)connectionString)) {
            config.putProperty(urlPropName, (dataSourceUrl.contains("?") ? dataSourceUrl + "&" : dataSourceUrl + "?") + connectionString);
        }
    }

    private static <K, V> Map.Entry<K, V> unsafeCast(Map.Entry entry) {
        return entry;
    }
}

