/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.citi;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.citi.CitiJob;
import org.kuali.coeus.common.framework.person.citi.CitiService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.quartz.JobExecutionContext;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component(value="citiJob")
public class CitiJobImpl
extends QuartzJobBean
implements CitiJob {
    private static final String CITI_DAYS_TO_LOAD_PARAM = "citi.job.daysToLoad";
    private CitiService citiService;
    private ParameterService parameterService;

    @Override
    public void executeInternal(JobExecutionContext context) {
        String daysToLoadParam = this.getParameterService().getParameterValueAsString("KC-SYS", "All", CITI_DAYS_TO_LOAD_PARAM);
        LocalDateTime startDate = Optional.ofNullable(daysToLoadParam).map(String::trim).filter(StringUtils::isNumeric).map(Integer::parseInt).map(daysToLoad -> LocalDateTime.now().truncatedTo(ChronoUnit.DAYS).minusDays(daysToLoad.intValue())).orElse(null);
        this.citiService.loadAndProcess(startDate, null);
    }

    public CitiService getCitiService() {
        return this.citiService;
    }

    public void setCitiService(CitiService citiService) {
        this.citiService = citiService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

