/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.preproposal;

import java.io.Serializable;
import java.sql.Date;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormDatum;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormsValueConverter;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildAppDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildDocumentDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildGadgetDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildSimulationDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildUserDto;
import org.kuali.rice.core.api.util.RiceConstants;

public class PreproposalForm
implements Serializable {
    public static final Comparator<PreproposalForm> UI_ORDER = (x, y) -> {
        Comparator<PreproposalForm> compareWorkflowStatus = Comparator.comparing(PreproposalForm::getWorkflowStatusOrdinal);
        Function<PreproposalForm, String> appName = p -> p.getApp() != null ? p.getApp().getName() : null;
        Comparator<PreproposalForm> compareNames = Comparator.nullsLast(Comparator.comparing(appName));
        Function<PreproposalForm, String> documentId = p -> p.getDocument() != null ? p.getDocument().getId() : null;
        Comparator<PreproposalForm> compareIds = Comparator.nullsLast(Comparator.comparing(documentId));
        return Objects.compare(x, y, compareWorkflowStatus.thenComparing(compareNames).thenComparing(compareIds));
    };
    private final KualiBuildAppDto app;
    private final KualiBuildDocumentDto document;
    private final String actionId;
    private final String currentStep;
    private final List<PreproposalFormDatum> data;
    private final List<WorkflowDetail> workflowDetails;
    private final Integer workflowStatusOrdinal;
    private final KualiBuildSimulationDto.Step assignment;

    public static PreproposalFormBuilder builder() {
        return new PreproposalFormBuilder();
    }

    protected PreproposalForm(KualiBuildAppDto app, KualiBuildDocumentDto document, String actionId, List<PreproposalFormDatum> data, String currentStep, List<WorkflowDetail> workflowDetails, Integer workflowStatusOrdinal, KualiBuildSimulationDto.Step assignment) {
        this.app = app;
        this.document = document;
        this.actionId = actionId;
        this.data = data;
        this.currentStep = currentStep;
        this.workflowDetails = workflowDetails;
        this.workflowStatusOrdinal = workflowStatusOrdinal;
        this.assignment = assignment;
    }

    public boolean isActive() {
        return this.hasWorkflowStatus("Draft") || this.hasWorkflowStatus("In Progress");
    }

    public boolean isActiveOrComplete() {
        return this.isActive() || this.hasWorkflowStatus("Complete");
    }

    public boolean isResubmittable() {
        return this.hasWorkflowStatus("Denied");
    }

    public boolean isDiscardable() {
        return this.hasWorkflowStatus("Draft");
    }

    public boolean isWithdrawable() {
        return this.hasWorkflowStatus("In Progress");
    }

    private boolean hasWorkflowStatus(String workflowStatus) {
        return this.document != null && this.document.getMeta() != null && workflowStatus.equalsIgnoreCase(this.document.getMeta().getWorkflowStatus());
    }

    public boolean isHasLatestComment() {
        if (this.workflowDetails.isEmpty()) {
            return false;
        }
        WorkflowDetail last = this.workflowDetails.get(this.workflowDetails.size() - 1);
        return StringUtils.isNotBlank((CharSequence)last.comment()) || StringUtils.isNotBlank((CharSequence)last.user());
    }

    public String getLatestComment() {
        if (this.workflowDetails.isEmpty()) {
            return "";
        }
        WorkflowDetail last = this.workflowDetails.get(this.workflowDetails.size() - 1);
        StringBuilder result = new StringBuilder(last.stepName());
        result.append(" - ").append(last.status());
        if (StringUtils.isNotBlank((CharSequence)last.user())) {
            result.append("Sent".equals(last.status()) ? " to " : " by ").append(last.user());
        }
        if (last.date() != null) {
            result.append(" on ").append(RiceConstants.getDefaultDateFormat().format(last.date()));
        }
        if (StringUtils.isNotBlank((CharSequence)last.comment())) {
            result.append(": ").append(last.comment());
        } else {
            result.append(" without comment.");
        }
        return result.toString();
    }

    public KualiBuildAppDto getApp() {
        return this.app;
    }

    public KualiBuildDocumentDto getDocument() {
        return this.document;
    }

    public String getCurrentStep() {
        return this.currentStep;
    }

    public Optional<String> getActionId() {
        return Optional.ofNullable(this.actionId);
    }

    public List<PreproposalFormDatum> getData() {
        return this.data;
    }

    public List<WorkflowDetail> getWorkflowDetails() {
        return this.workflowDetails;
    }

    public Integer getWorkflowStatusOrdinal() {
        return this.workflowStatusOrdinal;
    }

    public KualiBuildSimulationDto.Step getAssignment() {
        return this.assignment;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("app", (Object)this.app).append("document", (Object)this.document).append("actionId", (Object)this.actionId).append("currentStep", (Object)this.currentStep).append("data", this.data).append("workflowDetails", this.workflowDetails).append("workflowStatusOrdinal", (Object)this.workflowStatusOrdinal).append("assignment", (Object)this.assignment).build();
    }

    public static class PreproposalFormBuilder {
        private KualiBuildAppDto app;
        private KualiBuildDocumentDto document;
        private String username;
        private PreproposalFormsValueConverter valueConverter;

        public PreproposalFormBuilder withApp(KualiBuildAppDto app) {
            this.app = app;
            return this;
        }

        public PreproposalFormBuilder withDocument(KualiBuildDocumentDto document) {
            this.document = document;
            return this;
        }

        public PreproposalFormBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public PreproposalFormBuilder withValueConverter(PreproposalFormsValueConverter valueConverter) {
            this.valueConverter = valueConverter;
            return this;
        }

        public PreproposalForm build() {
            int workflowStatusOrdinal;
            String actionId = this.document.getMeta().getSimulation().getSteps().stream().filter(s -> "In Progress".equalsIgnoreCase(s.getStatus())).filter(s -> "formfill".equalsIgnoreCase(s.getType())).findFirst().map(KualiBuildSimulationDto.Step::getActionId).orElse(null);
            List<PreproposalFormDatum> data = this.document.getForm().getSchema().stream().map(this::datumForGadget).flatMap(Optional::stream).toList();
            String workflowStatus = this.document.getMeta().getWorkflowStatus();
            String currentStep = "In Progress".equalsIgnoreCase(workflowStatus) ? this.document.getMeta().getSimulation().getSteps().stream().filter(s -> "In Progress".equalsIgnoreCase(s.getStatus())).map(KualiBuildSimulationDto.Step::getStepName).filter(Objects::nonNull).collect(Collectors.joining(", ")) : "";
            List<WorkflowDetail> workflowDetails = this.document.getMeta().getSimulation().getSteps().stream().filter(step -> !"In Progress".equalsIgnoreCase(step.getStatus())).filter(step -> !"Simulated".equalsIgnoreCase(step.getStatus())).flatMap(step -> step.getUsers().stream().filter(user -> user.getWorkflowAction() != null).map(user -> new WorkflowDetail((KualiBuildSimulationDto.Step)step, (KualiBuildUserDto)user))).toList();
            KualiBuildSimulationDto.Step assignment = this.document.getMeta().getSimulation().getSteps().stream().filter(s -> "In Progress".equalsIgnoreCase(s.getStatus())).filter(s -> s.getUsers().stream().anyMatch(a -> a.getUsername().equals(this.username))).findFirst().orElse(null);
            if (workflowStatus != null) {
                workflowStatusOrdinal = switch (workflowStatus) {
                    case "Draft" -> 0;
                    case "In Progress" -> 0;
                    case "Complete" -> 1;
                    case "Denied" -> 8;
                    case "Withdrawn" -> 9;
                    default -> 99;
                };
            } else {
                workflowStatusOrdinal = 99;
            }
            return new PreproposalForm(this.app, this.document, actionId, data, currentStep, workflowDetails, workflowStatusOrdinal, assignment);
        }

        private Optional<PreproposalFormDatum> datumForGadget(KualiBuildGadgetDto gadget) {
            Optional<?> value = this.valueForGadget(gadget);
            if (value.isEmpty() || String.valueOf(value).isBlank()) {
                return Optional.empty();
            }
            return Optional.of(new PreproposalFormDatum(gadget, value.get()));
        }

        private Optional<?> valueForGadget(KualiBuildGadgetDto gadget) {
            if (gadget.getCustomFormKey() == null || !gadget.getCustomFormKey().isEnabled()) {
                return Optional.empty();
            }
            Object raw = this.document.getData().get(gadget.getCustomFormKey().getValue());
            return this.valueConverter.convertValueFromBuild(gadget, raw);
        }
    }

    public record WorkflowDetail(String stepName, String status, String user, Date date, String comment) implements Serializable
    {
        public WorkflowDetail(KualiBuildSimulationDto.Step step, KualiBuildUserDto user) {
            this(step.getStepName(), step.getStatus(), user.getDisplayName(), user.getWorkflowAction().getDate(), (String)ObjectUtils.defaultIfNull((Object)user.getWorkflowAction().getComment(), (Object)""));
        }
    }
}

