<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.2in" margin-right="0.2in">
				<fo:region-body margin-top="0.92in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.92in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:block/>
							<xsl:for-each select="template">
								<xsl:for-each select="schoolInfo">
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block text-align="center" margin="0pt">
										<fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block padding-bottom="0" margin-left="(100% - 100%) div 2" margin-right="(100% - 100%) div 2" font-size="large" font-weight="bold" margin="0pt">
												<fo:block>
													<xsl:for-each select="SchoolName">
														<xsl:variable name="value-of-template">
															<xsl:apply-templates/>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																<fo:block font-family="Arial" font-weight="bold">
																	<xsl:copy-of select="$value-of-template"/>
																</fo:block>
															</xsl:when>
															<xsl:otherwise>
																<fo:inline font-family="Arial" font-weight="bold">
																	<xsl:copy-of select="$value-of-template"/>
																</fo:inline>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:for-each>
												</fo:block>
											</fo:block>
										</fo:block>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block font-family="Arial" padding-bottom="0" text-align="center" margin="0pt">
										<fo:block>
											<fo:inline font-size="14pt" font-weight="bold">
												<xsl:text>Sponsor Template Report</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:block>
								</xsl:for-each>
							</xsl:for-each>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:block/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="20%"/>
								<fo:table-column column-width="30%"/>
								<fo:table-column column-width="40"/>
								<fo:table-column column-width="25%"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Template Code:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<xsl:for-each select="templateMaster">
														<xsl:for-each select="templateCode">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" text-align="right" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Template</xsl:text>
													<xsl:text>&#160;</xsl:text> 
													<xsl:text>Status:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<xsl:for-each select="templateMaster">
														<xsl:for-each select="templateStatus">
															<xsl:for-each select="statusDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Description:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<xsl:for-each select="templateMaster">
														<xsl:for-each select="description">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="center">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Prime Sponsor:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" font-weight="normal" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<xsl:for-each select="templateMaster">
														<xsl:for-each select="primeSponsor">
															<xsl:for-each select="sponsorCode">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
															<fo:inline>
																<xsl:text> : </xsl:text>
															</fo:inline>
															<xsl:for-each select="sponsorName">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="center">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="25%"/>
								<fo:table-column column-width="60%"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>					
																	
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="25%"/>
								<fo:table-column column-width="60%"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row font-family="Arial">
										<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
													<xsl:text>Payment:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding-left="20pt" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Basis of Payment:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" padding-left="20pt" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<xsl:for-each select="templateMaster">
														<xsl:for-each select="basisPayment">
															<xsl:for-each select="basisPaymentDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding-left="20pt" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Method of Payment:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" padding-left="20pt" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<xsl:for-each select="templateMaster">
														<xsl:for-each select="paymentMethod">
															<xsl:for-each select="paymentMethodDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell>
										<fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
										</fo:block>
									</fo:table-cell>
									</fo:table-row>		
									
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding-left="20pt" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-weight="bold">
													<xsl:text>Invoice Instructions:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="9pt" padding-left="20pt" padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<xsl:for-each select="comment">
													<xsl:if test="Description = 'Invoice Instructions'">
													    <xsl:for-each select="Comments">
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</fo:block>
															</fo:block>
														</xsl:for-each>
													</xsl:if>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									
									
								</fo:table-body>
							</fo:table>									
							
							<fo:table font-family="Times New Roman" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block/>
												<fo:inline font-size="12pt" font-weight="bold">
													<xsl:text>Sponsor List:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<xsl:if test="contact">
														<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="22%"/>
															<fo:table-column column-width="53%"/>
															<fo:table-column column-width="25%"/>
															<fo:table-header start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell border-width="0" font-family="Arial" margin="0" padding="0" height="1" text-align="right" display-align="before">
																		<fo:block/>
																	</fo:table-cell>
																	<fo:table-cell border-width="0" font-family="Arial" padding="2pt" height="1" display-align="center">
																		<fo:block/>
																	</fo:table-cell>
																	<fo:table-cell border-width="0" font-family="Arial" padding="2pt" height="1" display-align="center">
																		<fo:block/>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-header>
															<fo:table-body start-indent="0pt">
																<xsl:for-each select="contact">
																	<fo:table-row>
																		<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold" text-decoration="underline">
																					<xsl:text>Contact Type:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="ContactTypeDesc">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold" text-decoration="underline">
																					<xsl:text>Rolodex ID: </xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:text>&#160;&#160;&#160;&#160;&#160; </xsl:text>
																				</fo:inline>
																				<xsl:for-each select="RolodexDetails">
																					<xsl:for-each select="RolodexId">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="0" padding-top="1pt" number-columns-spanned="3" display-align="center">
																			<fo:block>
																				<xsl:for-each select="RolodexDetails">
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																						<fo:table-column column-width="130"/>
																						<fo:table-column column-width="proportional-column-width(1)"/>
																						<fo:table-column column-width="76"/>
																						<fo:table-column column-width="proportional-column-width(1)"/>
																						<fo:table-body start-indent="0pt">
																							<fo:table-row>
																								<fo:table-cell font-family="Arial" padding-top="5pt" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>Name:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding-top="5pt" number-columns-spanned="3" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="LastName">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																										<xsl:for-each select="FirstName">
																											<fo:inline>
																												<xsl:text>, </xsl:text>
																											</fo:inline>
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																										<xsl:for-each select="MiddleName">
																											<fo:inline>
																												<xsl:text>&#160;</xsl:text>
																											</fo:inline>
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																										<fo:inline>
																											<xsl:text>&#160;&#160;&#160; </xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>Organization:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" number-columns-spanned="3" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="Organization">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>Address:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" number-columns-spanned="3" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="Address1">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" number-columns-spanned="3" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="Address2">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" number-columns-spanned="3" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="Address3">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>Title:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="Title">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>Phone:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="PhoneNumber">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>City:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="City">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>State:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="StateDescription">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>Postal Code:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="PostalCode">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>Country:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="CountryDescription">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>Fax:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="Fax">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-weight="bold">
																											<xsl:text>E Mail:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
																									<fo:block>
																										<xsl:for-each select="Email">
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline>
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</xsl:for-each>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																						</fo:table-body>
																					</fo:table>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																			<fo:block>
																				<fo:block text-align="center">
																					<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																				</fo:block>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</xsl:for-each>
															</fo:table-body>
														</fo:table>
													</xsl:if>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							
							
							
							
							
							
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Times New Roman" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block/>
												<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
													<xsl:text>Comments:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<xsl:if test="comment">
														<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="25%"/>
															<fo:table-column column-width="60%"/>
															<fo:table-body start-indent="0pt">
																<xsl:for-each select="comment">
																	<xsl:if test="Description != 'Invoice Instructions'">				
																	<fo:table-row>
																		<fo:table-cell padding-bottom="5pt" padding-left="20pt" padding-top="0" padding="2pt" display-align="before">
																			<fo:block>
																				<xsl:for-each select="Description">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																					<fo:inline font-weight="bold">
																						<xsl:text>:</xsl:text>
																					</fo:inline>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding-bottom="5pt" padding-left="20pt" padding-top="0" padding="2pt" display-align="before">
																			<fo:block>
																				<xsl:for-each select="Comments">
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																						<fo:block>
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</fo:block>
																					</fo:block>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	</xsl:if>
																</xsl:for-each>
															</fo:table-body>
														</fo:table>
													</xsl:if>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Times New Roman" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
													<xsl:text>Terms:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<xsl:if test="term">
														<fo:table table-layout="fixed" width="100%" border-spacing="0pt">
															<fo:table-column column-width="90%"/>
															<fo:table-body start-indent="0pt">
																<xsl:for-each select="term">
																	<fo:table-row>
																		<fo:table-cell padding-left="20pt" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																			<fo:block>
																				<xsl:for-each select="Description">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-family="Arial" font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-family="Arial" font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding-left="20pt" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																			<fo:block>
																				<fo:inline-container>
																					<fo:block>
																						<xsl:text>&#x2029;</xsl:text>
																					</fo:block>
																				</fo:inline-container>
																				<xsl:if test="TermDetails">
																					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																						<fo:table-column column-width="3%"/>
																						<fo:table-column column-width="97%"/>
																						<fo:table-body start-indent="0pt">
																							<xsl:for-each select="TermDetails">
																								<fo:table-row>
																									<fo:table-cell padding-left="20pt" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>-</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding-left="20pt" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<xsl:for-each select="TermDescription">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates/>
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</xsl:for-each>
																						</fo:table-body>
																					</fo:table>
																				</xsl:if>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</xsl:for-each>
															</fo:table-body>
														</fo:table>
													</xsl:if>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-bottom="0" padding-top="0" display-align="center">
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Times New Roman" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
													<xsl:text>Reports:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block>
												<xsl:for-each select="template">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<xsl:if test="report">
														<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="95%"/>
															<fo:table-body start-indent="0pt">
																<xsl:for-each select="report">
																	<fo:table-row>
																		<fo:table-cell padding-top="0" padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="Description">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block font-family="Arial" font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline font-family="Arial" font-weight="bold">
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="0" display-align="center">
																			<fo:block>
																				<fo:inline-container>
																					<fo:block>
																						<xsl:text>&#x2029;</xsl:text>
																					</fo:block>
																				</fo:inline-container>
																				<xsl:if test="ReportTermDetails">
																					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																						<fo:table-column column-width="20"/>
																						<fo:table-column column-width="160"/>
																						<fo:table-column column-width="proportional-column-width(1)"/>
																						<fo:table-body start-indent="0pt">
																							<xsl:for-each select="ReportTermDetails">
																								<fo:table-row>
																									<fo:table-cell padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Report Type: </xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<xsl:for-each select="ReportCodeDesc">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates/>
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Frequency:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<xsl:for-each select="FrequencyCodeDesc">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates/>
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Frequency Basis: </xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<xsl:for-each select="FrequencyBaseDesc">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates/>
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Due Date:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" font-size="9pt" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<xsl:if test="DueDate != &apos;1900-01-01+00:00&apos;">
																												<xsl:for-each select="DueDate">
																													<fo:inline>
																														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																														<xsl:text>/</xsl:text>
																														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																														<xsl:text>/</xsl:text>
																														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																													</fo:inline>
																												</xsl:for-each>
																											</xsl:if>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>OSP File_Copy:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell font-family="Arial" padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block>
																											<xsl:for-each select="OSPDistributionDesc">
																												<xsl:variable name="value-of-template">
																													<xsl:apply-templates/>
																												</xsl:variable>
																												<xsl:choose>
																													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																														<fo:block>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:block>
																													</xsl:when>
																													<xsl:otherwise>
																														<fo:inline>
																															<xsl:copy-of select="$value-of-template"/>
																														</fo:inline>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="0" padding-bottom="0" padding-top="0" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="0" padding-bottom="0" padding-top="0" number-columns-spanned="2" display-align="center">
																										<fo:block>
																											<xsl:if test="MailCopies/RolodexId &gt; -1">
																												<fo:inline-container>
																													<fo:block>
																														<xsl:text>&#x2029;</xsl:text>
																													</fo:block>
																												</fo:inline-container>
																												<xsl:if test="MailCopies">
																													<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																														<fo:table-column column-width="proportional-column-width(1)"/>
																														<fo:table-column column-width="proportional-column-width(1)"/>
																														<fo:table-body start-indent="0pt">
																															<xsl:for-each select="MailCopies">
																																<fo:table-row>
																																	<fo:table-cell padding="0" padding-bottom="0" padding-top="0" number-columns-spanned="2" display-align="center">
																																		<fo:block>
																																			<fo:inline>
																																				<xsl:text>&#160;&#160; Mail </xsl:text>
																																			</fo:inline>
																																			<xsl:for-each select="NumberOfCopies">
																																				<xsl:variable name="value-of-template">
																																					<xsl:apply-templates/>
																																				</xsl:variable>
																																				<xsl:choose>
																																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																						<fo:block>
																																							<xsl:copy-of select="$value-of-template"/>
																																						</fo:block>
																																					</xsl:when>
																																					<xsl:otherwise>
																																						<fo:inline>
																																							<xsl:copy-of select="$value-of-template"/>
																																						</fo:inline>
																																					</xsl:otherwise>
																																				</xsl:choose>
																																			</xsl:for-each>
																																			<fo:inline>
																																				<xsl:text>&#160;</xsl:text>
																																			</fo:inline>
																																			<xsl:choose>
																																				<xsl:when test="NumberOfCopies &gt;1">
																																					<fo:inline>
																																						<xsl:text>copies</xsl:text>
																																					</fo:inline>
																																				</xsl:when>
																																				<xsl:when test="NumberOfCopies &lt;2">
																																					<fo:inline>
																																						<xsl:text>copy</xsl:text>
																																					</fo:inline>
																																				</xsl:when>
																																			</xsl:choose>
																																			<fo:inline>
																																				<xsl:text> to Rolodex Id </xsl:text>
																																			</fo:inline>
																																			<xsl:for-each select="RolodexId">
																																				<xsl:variable name="value-of-template">
																																					<xsl:apply-templates/>
																																				</xsl:variable>
																																				<xsl:choose>
																																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																						<fo:block>
																																							<xsl:copy-of select="$value-of-template"/>
																																						</fo:block>
																																					</xsl:when>
																																					<xsl:otherwise>
																																						<fo:inline>
																																							<xsl:copy-of select="$value-of-template"/>
																																						</fo:inline>
																																					</xsl:otherwise>
																																				</xsl:choose>
																																			</xsl:for-each>
																																		</fo:block>
																																	</fo:table-cell>
																																</fo:table-row>
																															</xsl:for-each>
																														</fo:table-body>
																													</fo:table>
																												</xsl:if>
																											</xsl:if>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</xsl:for-each>
																						</fo:table-body>
																					</fo:table>
																				</xsl:if>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</xsl:for-each>
															</fo:table-body>
														</fo:table>
													</xsl:if>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table font-family="Times New Roman" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="10%"/>
						<fo:table-column column-width="65%"/>
						<fo:table-column column-width="10%"/>
						<fo:table-column column-width="15%"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" padding-bottom="0" number-columns-spanned="4" height="18" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Verdana" font-size="9pt" padding-bottom="0" padding="2pt" text-align="left" display-align="center">
									<fo:block>
										<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
											<xsl:text>Template: </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Arial" font-size="9pt" padding-bottom="0" padding-left="0" number-rows-spanned="2" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="template">
											<xsl:for-each select="templateMaster">
												<xsl:for-each select="templateCode">
													<xsl:if test=". != 0">
														<xsl:variable name="value-of-template">
															<xsl:apply-templates/>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																<fo:block font-family="Verdana" font-size="9pt">
																	<xsl:copy-of select="$value-of-template"/>
																</fo:block>
															</xsl:when>
															<xsl:otherwise>
																<fo:inline font-family="Verdana" font-size="9pt">
																	<xsl:copy-of select="$value-of-template"/>
																</fo:inline>
															</xsl:otherwise>
														</xsl:choose>
														<fo:inline>
															<xsl:text> : </xsl:text>
														</fo:inline>
													</xsl:if>
												</xsl:for-each>
												<xsl:for-each select="description">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
															<fo:block>
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline>
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Arial" font-size="9pt" padding-bottom="0" padding-right="5pt" padding="2pt" text-align="right" display-align="center">
									<fo:block>
										<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
											<xsl:text>Page: </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Arial" font-size="9pt" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<fo:page-number font-family="Verdana" font-size="9pt"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding-top="0" padding="2pt" text-align="left" display-align="before">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-family="Arial" padding-right="6pt" padding-top="0" padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
											<xsl:text>Report</xsl:text>
											<xsl:text>&#160;</xsl:text> 
											<xsl:text>Date:</xsl:text> 											
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Arial" font-size="9pt" padding-bottom="0" padding-left="0" padding-top="0" padding="2pt" text-align="left" display-align="center">
									<fo:block>
										<xsl:for-each select="template">
											<xsl:for-each select="templateMaster">
												<xsl:for-each select="CurrentDate">
													<fo:inline font-family="Verdana" font-size="9pt" padding-right="3pt" padding-top="3pt">
														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
														<xsl:text>/</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
														<xsl:text>/</xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Verdana" font-size="9pt" padding="0" padding-top="0" number-columns-spanned="4" text-align="left" display-align="before">
									<fo:block>
										<fo:block text-align="center">
											<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
										</fo:block>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
