/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.compliance.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.compliance.exemption.SpecialReviewExemption;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ProfileUtils;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.kra.excon.project.service.ExconProjectService;
import org.kuali.kra.infrastructure.DocumentType;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public abstract class SpecialReviewHelperBase<T extends SpecialReview<? extends SpecialReviewExemption>>
implements Serializable {
    private static final long serialVersionUID = 4726816248612555502L;
    private T newSpecialReview;
    private boolean canModifySpecialReview;
    private boolean canCreateExconProject;
    private boolean isExportControlEnabled;
    private transient PermissionService permissionService;
    private transient ExconProjectService exconProjectService;
    private transient ConfigurationService configurationService;
    private transient BusinessObjectService businessObjectService;
    private static final String PROTOCOL_NUMBER = ".protocolNumber";

    public T getNewSpecialReview() {
        return this.newSpecialReview;
    }

    public void setNewSpecialReview(T newSpecialReview) {
        this.newSpecialReview = newSpecialReview;
    }

    public boolean getCanModifySpecialReview() {
        return this.canModifySpecialReview;
    }

    public boolean getCanCreateExconProject() {
        return this.canCreateExconProject;
    }

    public boolean getIsExportControlEnabled() {
        return this.isExportControlEnabled;
    }

    public void prepareView() {
        this.initializePermissions();
        this.initializeProtocolLinkView();
    }

    protected abstract List<T> getSpecialReviews();

    protected abstract boolean hasModifySpecialReviewPermission(String var1);

    public void prepareProtocolLinkViewFields(T specialReview) {
        this.prepareProtocolLinkViewFields(specialReview, true);
    }

    public void prepareProtocolLinkViewFields(T specialReview, boolean setLinkedFlag) {
        if (this.isExportControlReview(specialReview)) {
            this.findExconProject(specialReview).ifPresent(exconProject -> {
                specialReview.setApprovalTypeCode("RESBOOT-1000");
                specialReview.setProtocolStatus(exconProject.getProjectStatus().getDescription());
                specialReview.setApplicationDate(exconProject.getProjectStartDate());
                specialReview.setExpirationDate(exconProject.getProjectEndDate());
                specialReview.setLinkedToProtocol(setLinkedFlag);
            });
        }
    }

    public Optional<String> getForwardUrl(T specialReview) {
        if (this.isExportControlReview(specialReview)) {
            return this.findExconProject(specialReview).map(ExconProject::getExconProjectDocument).map(ExconProjectDocument::buildForwardUrl);
        }
        return Optional.empty();
    }

    public String getCreateUrl(String referenceId, String title, String returnUrl) {
        T specialReview = this.getNewSpecialReview();
        if (this.isExportControlReview(specialReview)) {
            String baseUrl = this.getConfigurationService().getPropertyValueAsString("application.url") + "/exconProjectHome.do";
            Properties parameters = new Properties();
            parameters.put("methodToCall", "docHandler");
            parameters.put("command", "initiate");
            parameters.put("docTypeName", DocumentType.EXPORT_CONTROLS_DOCUMENT.getName());
            parameters.put("assocDocTypeCode", this.getExconAssociatedDocType(specialReview));
            parameters.put("assocDocNumber", referenceId);
            parameters.put("assocDocTitle", title);
            parameters.put("returnLocation", returnUrl);
            return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
        }
        return "";
    }

    public void syncProtocolReferences(List<T> specialReviews, String referenceId, String title, List<T> deletedSpecialReviews) {
        if (this.isExportControlEnabled) {
            specialReviews.forEach(sr -> this.ensureSpecialReviewReference(sr, referenceId, title));
            for (SpecialReview toDelete : deletedSpecialReviews) {
                this.getExconProjectService().deleteAssociatedDocument(toDelete.getProtocolNumber(), this.getExconAssociatedDocType(toDelete), referenceId);
            }
        }
    }

    private void ensureSpecialReviewReference(T specialReview, String referenceId, String title) {
        if (this.isExportControlReview(specialReview)) {
            this.getExconProjectService().createOrUpdateAssociatedDocument(((SpecialReview)specialReview).getProtocolNumber(), this.getExconAssociatedDocType(specialReview), referenceId, title);
        }
    }

    private String getExconAssociatedDocType(T specialReview) {
        if (specialReview instanceof AwardSpecialReview) {
            return "AWARD";
        }
        if (specialReview instanceof InstitutionalProposalSpecialReview) {
            return "INSTPROP";
        }
        if (specialReview instanceof ProposalSpecialReview) {
            return "DEVPROP";
        }
        return null;
    }

    private boolean isExportControlReview(T specialReview) {
        return this.isExportControlEnabled && specialReview != null && "RESBOOT-1000".equals(((SpecialReview)specialReview).getSpecialReviewTypeCode());
    }

    private Optional<ExconProject> findExconProject(T specialReview) {
        return this.isExportControlEnabled ? this.getExconProjectService().getExconProject(((SpecialReview)specialReview).getProtocolNumber()).stream().findFirst() : Optional.empty();
    }

    public void syncProtocolLinkViews() {
        if (this.isExportControlEnabled) {
            this.getSpecialReviews().forEach(this::prepareProtocolLinkViewFields);
        }
    }

    private void initializePermissions() {
        this.canModifySpecialReview = this.hasModifySpecialReviewPermission(this.getUserIdentifier());
        this.isExportControlEnabled = ProfileUtils.isProfileActive("excon");
        this.canCreateExconProject = this.isExportControlEnabled && this.getPermissionService().hasPermissionByTemplate(this.getUserIdentifier(), "KR-SYS", "Initiate Document", Collections.singletonMap("documentTypeName", ExconProjectDocument.class.getSimpleName()));
    }

    private void initializeProtocolLinkView() {
        this.prepareProtocolLinkViewFields(this.getNewSpecialReview());
        for (SpecialReview specialReview : this.getSpecialReviews()) {
            this.prepareProtocolLinkViewFields(specialReview);
        }
    }

    public Optional<String> getProtocolSaveLocationPrefix(Map<String, String[]> requestParameters) {
        return requestParameters.keySet().stream().filter(parameterName -> parameterName.endsWith(PROTOCOL_NUMBER)).map(parameterName -> StringUtils.removeEnd((String)parameterName, (String)PROTOCOL_NUMBER)).findFirst();
    }

    public int getProtocolIndex(String prefix) {
        String lineNumber;
        int lastLeftBracketIndex = StringUtils.lastIndexOf((CharSequence)prefix, (int)91);
        int lastRightBracketIndex = StringUtils.lastIndexOf((CharSequence)prefix, (int)93);
        if (lastLeftBracketIndex != -1 && lastRightBracketIndex != -1 && NumberUtils.isDigits((String)(lineNumber = prefix.substring(lastLeftBracketIndex + 1, lastRightBracketIndex)))) {
            return Integer.parseInt(lineNumber);
        }
        return -1;
    }

    private String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public ExconProjectService getExconProjectService() {
        if (this.exconProjectService == null) {
            this.exconProjectService = KcServiceLocator.getService(ExconProjectService.class);
        }
        return this.exconProjectService;
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }
}

