/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireHelperBase;
import org.kuali.coeus.elasticsearch.AbstractDocument;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.NotificationDocument;
import org.kuali.coeus.elasticsearch.PreproposalForm;
import org.kuali.coeus.elasticsearch.SpecialReviewDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.question.ProposalPersonQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.bo.AbstractPerson;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kim.api.identity.PersonService;

public class ElasticsearchDevelopmentProposalSerializer
extends ElasticsearchDocumentSerializer {
    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)doc;
        DevelopmentProposal devProposal = document.getDevelopmentProposal();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, document);
        if (devProposal.isInHierarchy()) {
            if (devProposal.isChild()) {
                List proposalDevelopmentDocuments = this.getDataObjectService().findMatching(ProposalDevelopmentDocument.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("developmentProposal.proposalNumber", devProposal.getHierarchyParentProposalNumber())).build()).getResults();
                if (proposalDevelopmentDocuments.size() > 0) {
                    ProposalDevelopmentDocument parentDocument = (ProposalDevelopmentDocument)proposalDevelopmentDocuments.get(0);
                    if (!parentDocument.getDocumentHeader().hasWorkflowDocument()) {
                        parentDocument.getDocumentHeader().setWorkflowDocument(WorkflowDocumentFactory.loadDocument((String)"kr", (String)parentDocument.getDocumentNumber()));
                    }
                    DocumentStatus parentStatus = parentDocument.getDocumentHeader().getWorkflowDocument().getStatus();
                    esDoc.setHierarchyRouteStatus(parentStatus.getLabel());
                    esDoc.setParentProposalNumber(devProposal.getHierarchyParentProposalNumber());
                    if (parentDocument.getDocumentHeader().getWorkflowDocument().getStatus() == DocumentStatus.ENROUTE) {
                        this.setActionRequestFields(esDoc, parentDocument);
                    }
                }
            } else {
                esDoc.setHierarchyRouteStatus(esDoc.getRouteStatus());
                esDoc.setParentProposalNumber(devProposal.getProposalNumber());
            }
            esDoc.setHierarchyChild(devProposal.isChild());
        } else {
            esDoc.setHierarchyRouteStatus(esDoc.getRouteStatus());
            esDoc.setHierarchyChild(false);
        }
        esDoc.setPrimaryKey(devProposal.getProposalNumber());
        esDoc.setNamespace(document.getNamespace());
        esDoc.setSequenceNumber(0);
        esDoc.setSequenceStatus(VersionStatus.ACTIVE.name());
        esDoc.setTypeCode(devProposal.getProposalTypeCode());
        esDoc.setTypeDescription(devProposal.getProposalType().getDescription());
        esDoc.setStatusCode(devProposal.getProposalStateTypeCode());
        esDoc.setStatusDescription(devProposal.getProposalState().getDescription());
        Optional.ofNullable(devProposal.getActivityType()).ifPresent(at -> esDoc.setActivityTypes(Set.of(devProposal.getActivityType().getDescription())));
        esDoc.setStartDate(DateUtils.toUtc(devProposal.getRequestedStartDateInitial()));
        esDoc.setEndDate(DateUtils.toUtc(devProposal.getRequestedEndDateInitial()));
        esDoc.setAssignedApproverId(devProposal.getApproverId());
        Optional.ofNullable(devProposal.getApproverId()).map(arg_0 -> ((PersonService)this.personService).getPerson(arg_0)).map(this::formatNameForElasticsearch).ifPresent(esDoc::setAssignedApproverName);
        devProposal.getActiveBudget().ifPresent(budget -> esDoc.setTotalBudgetAmount(budget.getTotalCost().doubleValue()));
        esDoc.addCfdaNumber(devProposal.getProposalCfdas().stream().map(ProposalCfda::getCfdaNumber).collect(Collectors.toSet()));
        esDoc.setSpecialReviews(devProposal.getPropSpecialReviews().stream().map(specialReview -> new SpecialReviewDocument(specialReview.getSpecialReviewType() != null ? specialReview.getSpecialReviewType().getDescription() : null, this.getSpecialReviewApprovalType((SpecialReview<?>)specialReview))).collect(Collectors.toList()));
        this.setSearchDocCustomDataIfEnabled(esDoc, devProposal);
        this.setCommonFields(esDoc, document, devProposal);
        return esDoc;
    }

    void setCommonFields(GrantsSearchDocument esDoc, ProposalDevelopmentDocument document, DevelopmentProposal devProposal) {
        esDoc.addProposalNumber(devProposal.getProposalNumber());
        esDoc.addDevProposalNumber(devProposal.getProposalNumber());
        esDoc.setTitle(devProposal.getTitle());
        esDoc.setSponsorCode(devProposal.getSponsorCode());
        esDoc.setSponsorName(devProposal.getSponsorName());
        if (devProposal.getPrimeSponsor() != null) {
            esDoc.setPrimeSponsorCode(devProposal.getPrimeSponsorCode());
            esDoc.setPrimeSponsorName(devProposal.getPrimeSponsor().getSponsorName());
        }
        esDoc.setLeadUnitNumber(devProposal.getOwnedByUnitNumber());
        esDoc.setLeadUnitName(devProposal.getOwnedByUnitName());
        esDoc.setNsfSequenceNumber(devProposal.getNsfSequenceNumber());
        esDoc.setKeywords(devProposal.getPropScienceKeywords().stream().map(keyword -> keyword.getScienceKeyword().getDescription()).collect(Collectors.toSet()));
        esDoc.setAbstracts(devProposal.getProposalAbstracts().stream().map(a -> new AbstractDocument(a.getAbstractDetails(), a.getAbstractType().getDescription())).collect(Collectors.toList()));
        esDoc.setNotifications(devProposal.getNotifications().stream().map(n -> new NotificationDocument(n.getSubject(), n.getMessage())).collect(Collectors.toList()));
        esDoc.setBudgetJustifications(devProposal.getBudgets().stream().map(b -> new BudgetJustificationWrapper(b.getBudgetJustification()).getJustificationText()).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
        this.setDevProposalPersonFields(esDoc, devProposal);
        this.setPdSpecificFields(esDoc, devProposal);
        this.setQuestionnaireAnswerFields(esDoc, document, devProposal);
        esDoc.setMailType(devProposal.getMailType());
        if (devProposal.getMailTypeRef() != null) {
            esDoc.setMailTypeDescription(devProposal.getMailTypeRef().getDescription());
        }
        esDoc.setMailBy(devProposal.getMailBy());
        if (devProposal.getMailByRef() != null) {
            esDoc.setMailByDescription(devProposal.getMailByRef().getDescription());
        }
        if (devProposal.getPreproposalForms() != null) {
            esDoc.addPreproposalForms(devProposal.getPreproposalForms().stream().map(ppf -> {
                PreproposalForm form = new PreproposalForm();
                form.setAppId(ppf.getAppId());
                form.setAppName(ppf.getAppName());
                form.setDocId(ppf.getDocId());
                form.setDocWorkflowStatus(ppf.getDocWorkflowStatus());
                return form;
            }).collect(Collectors.toList()));
        }
    }

    protected void setDevProposalPersonFields(GrantsSearchDocument esDoc, DevelopmentProposal devProposal) {
        ProposalPerson proposalPerson = devProposal.getPrincipalInvestigator();
        if (proposalPerson != null) {
            esDoc.setPrincipalInvestigatorId(proposalPerson.getPersonId());
            String piName = this.formatNameForElasticsearch(proposalPerson);
            esDoc.setPrincipalInvestigatorName(piName);
            String alternateName = this.formatNameForElasticsearch((AbstractPerson)proposalPerson);
            if (!piName.equals(alternateName)) {
                esDoc.setPrincipalInvestigatorAlternateName(alternateName);
            }
        }
        devProposal.getProposalPersons().forEach(person -> this.addPersonnel(esDoc, (ProposalPerson)person));
    }

    @Override
    public String getNamespace() {
        return "KC-PD";
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of("View Proposal");
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof ProposalDevelopmentDocument;
    }

    private void setQuestionnaireAnswerFields(GrantsSearchDocument esDoc, ProposalDevelopmentDocument document, DevelopmentProposal devProposal) {
        boolean enabled = this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "Elasticsearch_Index_QuestionnaireAnswers_Enabled", Boolean.FALSE);
        if (!enabled) {
            return;
        }
        HashMap<String, List<String>> questionnaireAnswers = new HashMap<String, List<String>>();
        this.getQuestionnaireHelpers(document, devProposal).flatMap(qh -> {
            qh.populateAnswers();
            return qh.getAnswerHeaders().stream();
        }).flatMap(ah -> ah.getAnswers().stream()).filter(a -> !StringUtils.isEmpty((CharSequence)a.getAnswer())).forEach(a -> {
            if (!questionnaireAnswers.containsKey(a.getQuestionId().toString())) {
                questionnaireAnswers.put(a.getQuestionId().toString(), new ArrayList());
            }
            ((List)questionnaireAnswers.get(a.getQuestionId().toString())).add(a.getAnswer());
        });
        esDoc.setQuestionnaireAnswers(questionnaireAnswers);
    }

    private Stream<? extends QuestionnaireHelperBase> getQuestionnaireHelpers(ProposalDevelopmentDocument document, DevelopmentProposal devProposal) {
        ProposalDevelopmentQuestionnaireHelper proposalDevelopmentQuestionnaireHelper = new ProposalDevelopmentQuestionnaireHelper(document);
        ProposalDevelopmentS2sQuestionnaireHelper proposalDevelopmentS2sQuestionnaireHelper = new ProposalDevelopmentS2sQuestionnaireHelper(document);
        List proposalPersonQuestionnaireHelpers = devProposal.getProposalPersons().stream().map(ProposalPersonQuestionnaireHelper::new).collect(Collectors.toList());
        return Stream.of(Stream.of(proposalDevelopmentQuestionnaireHelper), Stream.of(proposalDevelopmentS2sQuestionnaireHelper), proposalPersonQuestionnaireHelpers.stream()).reduce(Stream::concat).orElseGet(Stream::empty);
    }
}

