/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.kuali.coeus.propdev.api.attachment.NarrativeAttachmentContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.impl.s2s.map.Attachment;
import org.kuali.coeus.propdev.impl.s2s.map.AttachmentMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.Attachments;
import org.kuali.coeus.propdev.impl.s2s.map.MappingConstants;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="attachmentMappingService")
public class AttachmentMappingServiceImpl
implements AttachmentMappingService {
    @Autowired
    @Qualifier(value="grantApplicationHashService")
    private GrantApplicationHashService hashService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;
    private static final String APPLICATION_URL = "application.url";

    @Override
    public Attachments getAttachments(DevelopmentProposalContract proposal) {
        Attachments attachments = new Attachments();
        attachments.getAdditionalProperties().putAll(proposal.getNarratives().stream().filter(this::hasAttachment).collect(Collectors.toMap(this::mapAttachmentType, this::toAttachment, this::mergeAttachments)));
        return attachments;
    }

    private boolean hasAttachment(NarrativeContract narrative) {
        return narrative.getNarrativeAttachment() != null && narrative.getNarrativeAttachment().getData() != null && narrative.getNarrativeAttachment().getData().length > 0;
    }

    private List<Attachment> toAttachment(NarrativeContract narrative) {
        byte[] content = narrative.getNarrativeAttachment().getData();
        String fileHash = this.hashService.computeAttachmentHash(content);
        Attachment attachment = new Attachment();
        attachment.setFileName(narrative.getNarrativeAttachment().getName());
        attachment.setHashValue(fileHash);
        attachment.setFileId(this.getFileId(narrative, fileHash));
        attachment.setUrl(this.getAttachmentUrl(narrative.getNarrativeAttachment()));
        attachment.setToken("Bearer " + this.jwtService.createToken());
        return Collections.singletonList(attachment);
    }

    private List<Attachment> mergeAttachments(List<Attachment> a, List<Attachment> b) {
        return Stream.concat(a.stream(), b.stream()).collect(Collectors.toList());
    }

    private String getFileId(NarrativeContract narrative, String fileHash) {
        return DigestUtils.md5Hex((String)(narrative.getModuleNumber() + narrative.getModuleSequenceNumber() + fileHash));
    }

    private String mapAttachmentType(NarrativeContract narrative) {
        String attachmentType = narrative.getNarrativeType().getCode();
        return MappingConstants.ATTACHMENT_TYPES.getOrDefault(attachmentType, attachmentType);
    }

    private String getAttachmentUrl(NarrativeAttachmentContract attachmentContract) {
        return this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/research-common/api/v1/file-data/" + attachmentContract.getFileDataId();
    }

    public GrantApplicationHashService getHashService() {
        return this.hashService;
    }

    public void setHashService(GrantApplicationHashService hashService) {
        this.hashService = hashService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }
}

