/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.controller.DocHandlerService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.AwardReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingDao;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingPrintingService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingType;
import org.kuali.kra.award.web.struts.action.ReportTrackingLookupForm;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.lookup.Lookupable;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.KualiLookupAction;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ReportTrackingLookupAction
extends KualiLookupAction {
    private static final Logger LOG = LogManager.getLogger(ReportTrackingLookupForm.class);
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private ReportTrackingDao reportTrackingDao;
    private DateTimeService dateTimeService;
    private DocumentService documentService;
    private VersionHistoryService versionHistoryService;
    private UnitAuthorizationService unitAuthorizationService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.isAuthorized();
        return super.execute(mapping, form, request, response);
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        Lookupable kualiLookupable = lookupForm.getLookupable();
        if (kualiLookupable == null) {
            LOG.error("Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        kualiLookupable.validateSearchParameters(lookupForm.getFields());
        if (lookupForm.isViewRawResults()) {
            return super.search(mapping, (ActionForm)lookupForm, request, response);
        }
        LookupUtils.preProcessRangeFields((Map)lookupForm.getFields());
        List<ReportTracking> groupedResults = this.getReportTrackingDao().getResultsGroupedBy(lookupForm.getFields(), lookupForm.getGroupedByFields(), lookupForm.getGroupedByDisplayFields());
        lookupForm.setGroupedByResults(groupedResults);
        return mapping.findForward("basic");
    }

    public ActionForward getDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        LookupUtils.preProcessRangeFields((Map)lookupForm.getFields());
        HashMap<String, String> allFields = new HashMap<String, String>(lookupForm.getFields());
        this.populateAggregateValues(lookupForm.getGroupedByResults().get(lookupForm.getGroupByResultIndex()), allFields, lookupForm.getGroupedByFields());
        List<ReportTracking> detailResults = this.getReportTrackingDao().getDetailResults(allFields, lookupForm.getDetailFields());
        lookupForm.setDetailResults(detailResults);
        return mapping.findForward("ajaxDetails");
    }

    public ActionForward updateView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        lookupForm.setCurrentView();
        lookupForm.setViewRawResults(false);
        return this.search(mapping, (ActionForm)lookupForm, request, response);
    }

    public ActionForward resetCustomView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        lookupForm.resetCustomFields();
        lookupForm.setCurrentView();
        return this.search(mapping, (ActionForm)lookupForm, request, response);
    }

    public ActionForward viewRawResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        lookupForm.setViewRawResults(true);
        lookupForm.setHideReturnLink(true);
        lookupForm.setSuppressActions(true);
        return this.search(mapping, (ActionForm)lookupForm, request, response);
    }

    public ActionForward viewAggregateResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        lookupForm.setViewRawResults(false);
        return this.search(mapping, (ActionForm)lookupForm, request, response);
    }

    public ActionForward moveGroupByColumns(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        String fieldName = lookupForm.getMoveField();
        Integer newIndex = lookupForm.getNewColumnIndex() - 1;
        Integer oldIndex = lookupForm.getGroupedByDisplayFields().indexOf(fieldName);
        if (newIndex >= 0 && oldIndex >= 0) {
            lookupForm.getGroupedByDisplayFields().remove(fieldName);
            if (newIndex > oldIndex) {
                Integer n = newIndex;
                newIndex = newIndex - 1;
            }
            lookupForm.getGroupedByDisplayFields().add(newIndex, fieldName);
            String origItem = lookupForm.getGroupedByFields().get(oldIndex);
            lookupForm.getGroupedByFields().remove(origItem);
            lookupForm.getGroupedByFields().add(newIndex, origItem);
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveDetailColumns(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        String fieldName = lookupForm.getMoveField();
        Integer newIndex = lookupForm.getNewColumnIndex();
        Integer oldIndex = lookupForm.getDetailFields().indexOf(fieldName);
        if (newIndex >= 0 && oldIndex >= 0) {
            lookupForm.getDetailFields().remove(fieldName);
            if (newIndex > oldIndex) {
                Integer n = newIndex;
                newIndex = newIndex - 1;
            }
            lookupForm.getDetailFields().add(newIndex, fieldName);
        }
        return mapping.findForward("basic");
    }

    public ActionForward printAllReportTracking(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        ArrayList<Printable> printableArtifactLists = new ArrayList<Printable>();
        HashMap<String, String> allFields = new HashMap<String, String>(lookupForm.getFields());
        List<ReportTracking> detailResults = this.getReportTrackingDao().getResultsGroupedBy(allFields, lookupForm.getGroupedByFields(), lookupForm.getGroupedByDisplayFields());
        for (ReportTracking detailResult : detailResults) {
            AwardReportTracking printables = new AwardReportTracking();
            printables = this.getReportTrackingPrintingService().getReportPrintable(ReportTrackingType.AWARD_REPORT_TRACKING, detailResult, printables);
            printableArtifactLists.add((AwardReportTracking)printables.clone());
        }
        AttachmentDataSource attachmentDataSource = this.getReportTrackingPrintingService().printAwardReportTracking(printableArtifactLists);
        this.streamToResponse(attachmentDataSource, response);
        actionForward = RESPONSE_ALREADY_HANDLED;
        return actionForward;
    }

    public ActionForward printReportTracking(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        ReportTrackingLookupForm lookupForm = (ReportTrackingLookupForm)form;
        List<ReportTracking> detailResults = lookupForm.getGroupedByResults();
        String line = request.getParameter("line");
        ReportTracking reportTracking = detailResults.get(Integer.parseInt(line));
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        AwardReportTracking printable = new AwardReportTracking();
        printable = this.getReportTrackingPrintingService().getReportPrintable(ReportTrackingType.AWARD_REPORT_TRACKING, reportTracking, printable);
        printableArtifactList.add(printable);
        AttachmentDataSource attachmentDataSource = this.getReportTrackingPrintingService().printAwardReportTracking(printableArtifactList);
        this.streamToResponse(attachmentDataSource, response);
        actionForward = RESPONSE_ALREADY_HANDLED;
        return actionForward;
    }

    public ActionForward openAwardReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String awardNumber = this.getSelectedAwardNumber(request);
        List<VersionHistory> versions = KcServiceLocator.getService(VersionHistoryService.class).loadVersionHistory(Award.class, awardNumber);
        Award newest = null;
        for (VersionHistory version : versions) {
            if (newest != null && (version.getSequenceOwnerSequenceNumber() <= newest.getSequenceNumber() || version.getStatus() == VersionStatus.CANCELED)) continue;
            newest = (Award)version.getSequenceOwner();
        }
        String docNumber = newest.getAwardDocument().getDocumentNumber();
        AwardDocument awardDocument = (AwardDocument)this.getDocumentService().getByDocumentHeaderId(docNumber);
        String forwardUrl = this.buildForwardUrl(awardDocument.getDocumentHeader().getWorkflowDocument().getDocumentId());
        return new ActionForward(forwardUrl, true);
    }

    protected String getSelectedAwardNumber(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            return StringUtils.substringBetween((String)parameterName, (String)".awardNumber", (String)".");
        }
        return null;
    }

    protected String buildForwardUrl(String routeHeaderId) {
        DocHandlerService researchDocumentService = KcServiceLocator.getService(DocHandlerService.class);
        Object forward = researchDocumentService.getDocHandlerUrl(routeHeaderId);
        forward = ((String)forward).indexOf("?") == -1 ? (String)forward + "?" : (String)forward + "&";
        forward = (String)forward + "docId=" + routeHeaderId;
        forward = (String)forward + "&command=displayDocSearchView";
        if (GlobalVariables.getUserSession().isBackdoorInUse()) {
            forward = (String)forward + "&backdoorId=" + GlobalVariables.getUserSession().getPrincipalName();
        }
        return forward;
    }

    protected void populateAggregateValues(ReportTracking aggregateValues, Map<String, String> fields, List<String> columns) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (String column : columns) {
            if (Date.class.isAssignableFrom(ObjectUtils.easyGetPropertyType((Object)aggregateValues, (String)column)) && ObjectUtils.getPropertyValue((Object)aggregateValues, (String)column) != null) {
                fields.put(column, this.getDateTimeService().toDateString((java.util.Date)ObjectUtils.getPropertyValue((Object)aggregateValues, (String)column)));
                continue;
            }
            fields.put(column, BeanUtils.getProperty((Object)aggregateValues, (String)column));
        }
    }

    protected void isAuthorized() {
        boolean userHasPermission = false;
        String permissionName = AwardPermissionConstants.VIEW_AWARD.getAwardPermission();
        userHasPermission = this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-AWARD", permissionName);
        if (!userHasPermission) {
            permissionName = AwardPermissionConstants.MODIFY_AWARD.getAwardPermission();
            userHasPermission = this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-AWARD", permissionName);
        }
        if (!userHasPermission) {
            permissionName = AwardPermissionConstants.MODIFY_AWARD_REPORT_TRACKING.getAwardPermission();
            userHasPermission = this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-AWARD", permissionName);
        }
        if (!userHasPermission) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalName(), "Search", "Report Tracking");
        }
    }

    protected ReportTrackingDao getReportTrackingDao() {
        if (this.reportTrackingDao == null) {
            this.reportTrackingDao = KcServiceLocator.getService(ReportTrackingDao.class);
        }
        return this.reportTrackingDao;
    }

    public void setReportTrackingDao(ReportTrackingDao reportTrackingDao) {
        this.reportTrackingDao = reportTrackingDao;
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = KcServiceLocator.getService(DocumentService.class);
        }
        return this.documentService;
    }

    public VersionHistoryService getVersionHistoryService() {
        if (this.versionHistoryService == null) {
            this.versionHistoryService = KcServiceLocator.getService(VersionHistoryService.class);
        }
        return this.versionHistoryService;
    }

    private ReportTrackingPrintingService getReportTrackingPrintingService() {
        return KcServiceLocator.getService(ReportTrackingPrintingService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void streamToResponse(AttachmentDataSource attachmentDataSource, HttpServletResponse response) throws Exception {
        byte[] xbts = attachmentDataSource.getData();
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(xbts.length);
            baos.write(xbts);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)attachmentDataSource.getType(), (ByteArrayOutputStream)baos, (String)attachmentDataSource.getName());
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {
                LOG.error("Error while downloading attachment");
                throw new RuntimeException("IOException occurred while downloading attachment", ioEx);
            }
        }
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        if (this.unitAuthorizationService == null) {
            this.unitAuthorizationService = KcServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.unitAuthorizationService;
    }
}

