/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.institutionalproposal.IndirectcostRateType;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddUnrecoveredFandARuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSaveUnrecoveredFandARuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalUnrecoveredFandARule;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class InstitutionalProposalUnrecoveredFandARuleImpl
extends KcTransactionalDocumentRuleBase
implements InstitutionalProposalUnrecoveredFandARule {
    private static final String NEW_PROPOSAL_UNRECOVERED_FNA = "newInstitutionalProposalUnrecoveredFandA";
    private static final String FISCAL_YEAR_PROP = ".fiscalYear";
    private static final String COMMITMENT_AMOUNT_PROP = ".commitmentAmount";
    private static final String RATE_TYPE_CODE_PROP = ".rateTypeCode";
    private static final String COST_SHARE_PERCENTAGE_PROP = ".costSharePercentage";
    private static final String SOURCE_ACCOUNT_PROP = ".sourceAccount";
    private static final String INDIRECTCOST_RATE_TYPE_CODE = "indirectcostRateTypeCode";
    private ParameterService parameterService;

    @Override
    public boolean processAddInstitutionalProposalUnrecoveredFandABusinessRules(InstitutionalProposalAddUnrecoveredFandARuleEvent institutionalProposalAddUnrecoveredFandARuleEvent) {
        return this.processCommonValidations(institutionalProposalAddUnrecoveredFandARuleEvent.getUnrecoveredFandAForValidation(), institutionalProposalAddUnrecoveredFandARuleEvent.getInstitutionalProposalUnrecoveredFandAs());
    }

    @Override
    public boolean processSaveInstitutionalProposalUnrecoveredFandABusinessRules(InstitutionalProposalSaveUnrecoveredFandARuleEvent institutionalProposalAddUnrecoveredFandARuleEvent) {
        return this.processCommonValidations(institutionalProposalAddUnrecoveredFandARuleEvent.getUnrecoveredFandAForValidation(), institutionalProposalAddUnrecoveredFandARuleEvent.getInstitutionalProposalUnrecoveredFandAs());
    }

    public boolean processCommonValidations(InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA, List<InstitutionalProposalUnrecoveredFandA> institutionalProposalUnrecoveredFandAs) {
        if (this.isUnrecoveredFandAApplicable().booleanValue() && this.isUnrecoveredFandAEnforced().booleanValue()) {
            boolean validFiscalYearRange = this.validateUnrecoveredFandAFiscalYearRange(institutionalProposalUnrecoveredFandA);
            boolean validPercentage = this.validatePercentage(institutionalProposalUnrecoveredFandA.getApplicableIndirectcostRate());
            boolean validRateType = this.validateRateType(institutionalProposalUnrecoveredFandA.getIndirectcostRateTypeCode());
            boolean validSourceAccount = this.validateSourceAccount(institutionalProposalUnrecoveredFandA.getSourceAccount());
            boolean validAmount = this.validateAmount(institutionalProposalUnrecoveredFandA.getAmount());
            boolean validRows = this.checkNoDuplicates(institutionalProposalUnrecoveredFandA, institutionalProposalUnrecoveredFandAs);
            return validFiscalYearRange && validPercentage && validRateType && validSourceAccount && validAmount && validRows;
        }
        return true;
    }

    public boolean validateUnrecoveredFandAFiscalYearRange(InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA) {
        boolean valid = true;
        if (institutionalProposalUnrecoveredFandA.getFiscalYear() != null) {
            try {
                int fiscalYear = Integer.parseInt(institutionalProposalUnrecoveredFandA.getFiscalYear());
                if (fiscalYear < Constants.MIN_FISCAL_YEAR || fiscalYear > Constants.MAX_FISCAL_YEAR) {
                    valid = false;
                    this.reportError("newInstitutionalProposalUnrecoveredFandA.fiscalYear", "error.institutionalProposalUnrecoveredFandA.fiscalYear.range", new String[0]);
                }
            }
            catch (NumberFormatException e) {
                valid = false;
                this.reportError("newInstitutionalProposalUnrecoveredFandA.fiscalYear", "error.institutionalProposalUnrecoveredFandA.fiscalYear.IncorrectFormat", new String[0]);
            }
        } else {
            valid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.fiscalYear", "error.institutionalProposalUnrecoveredFandA.fiscalYear.required", new String[0]);
        }
        return valid;
    }

    private boolean validatePercentage(ScaleTwoDecimal percentage) {
        boolean isValid = true;
        if (percentage != null && percentage.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.costSharePercentage", "error.institutionalProposalUnrecoveredFandA.percentage.range", new String[0]);
        }
        return isValid;
    }

    private boolean validateRateType(Integer rateTypeCode) {
        boolean isValid = true;
        if (rateTypeCode == null) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.rateTypeCode", "error.institutionalProposalUnrecoveredFandA.rateTypeCode.required", new String[0]);
        } else if (this.getBusinessObjectService().countMatching(IndirectcostRateType.class, Collections.singletonMap(INDIRECTCOST_RATE_TYPE_CODE, rateTypeCode)) != 1) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.rateTypeCode", "error.institutionalProposalUnrecoveredFandA.rateTypeCode.invalid", rateTypeCode.toString());
        }
        return isValid;
    }

    private boolean validateSourceAccount(String a) {
        boolean isValid = true;
        if (StringUtils.isBlank((CharSequence)a)) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.sourceAccount", "error.institutionalProposalUnrecoveredFandA.sourceAccount.required", new String[0]);
        }
        return isValid;
    }

    public Boolean isUnrecoveredFandAEnforced() {
        return this.getParameterService().getParameterValueAsBoolean("KC-B", "Document", "budgetUnrecoveredFandAEnforcementFlag");
    }

    public Boolean isUnrecoveredFandAApplicable() {
        return this.getParameterService().getParameterValueAsBoolean("KC-B", "Document", "budgetUnrecoveredFandAApplicabilityFlag");
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    private boolean validateAmount(ScaleTwoDecimal amount) {
        boolean isValid = true;
        if (amount == null) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.commitmentAmount", "error.institutionalProposalUnrecoveredFandA.amount.required", new String[0]);
        } else if (amount.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.commitmentAmount", "error.institutionalProposalUnrecoveredFandA.amount.invalid", amount.toString());
        }
        return isValid;
    }

    private boolean checkNoDuplicates(InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA, List<InstitutionalProposalUnrecoveredFandA> institutionalProposalUnrecoveredFandAs) {
        boolean noDuplicates = true;
        for (InstitutionalProposalUnrecoveredFandA a : institutionalProposalUnrecoveredFandAs) {
            if (a == institutionalProposalUnrecoveredFandA || !StringUtils.equals((CharSequence)a.getFiscalYear(), (CharSequence)institutionalProposalUnrecoveredFandA.getFiscalYear()) || !Objects.equals(a.getIndirectcostRateTypeCode(), institutionalProposalUnrecoveredFandA.getIndirectcostRateTypeCode()) || !Objects.equals(a.getApplicableIndirectcostRate(), institutionalProposalUnrecoveredFandA.getApplicableIndirectcostRate()) || !Objects.equals(a.getOnCampusFlag(), institutionalProposalUnrecoveredFandA.getOnCampusFlag()) || !StringUtils.equals((CharSequence)a.getSourceAccount(), (CharSequence)institutionalProposalUnrecoveredFandA.getSourceAccount())) continue;
            noDuplicates = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.fiscalYear", "error.institutionalProposalUnrecoveredFandA.duplicate.row", new String[0]);
        }
        return noDuplicates;
    }
}

